/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api.cmmn.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.BaseTeamAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.MemberAPI;
import org.cafienne.cmmn.instance.team.Team;

public class CaseRoleAPI
extends BaseTeamAPI {
    private final CaseRoleDefinition role;
    private final Collection<MemberAPI> members;
    private final Collection<MemberAPI> users;
    private final Collection<MemberAPI> tenantRoles;
    private final Collection<MemberAPI> groups;

    public CaseRoleAPI(Team team, CaseRoleDefinition caseRoleDefinition) {
        super(team);
        this.role = caseRoleDefinition;
        this.users = team.getUsers().stream().map(this::wrap).collect(Collectors.toList());
        this.tenantRoles = team.getTenantRoles().stream().map(this::wrap).collect(Collectors.toList());
        this.groups = team.getGroups().stream().map(this::wrap).collect(Collectors.toList());
        this.members = new ArrayList<MemberAPI>();
        this.members.addAll(this.users);
        this.members.addAll(this.tenantRoles);
        this.members.addAll(this.groups);
        this.addPropertyReader("members", () -> this.members);
        this.addPropertyReader("member", () -> this.members.stream().findFirst().orElse(null));
        this.addPropertyReader("users", () -> this.users);
        this.addPropertyReader("user", () -> this.users.stream().findFirst().orElse(null));
        this.addPropertyReader("tenantRoles", () -> this.tenantRoles);
        this.addPropertyReader("tenantRole", () -> this.tenantRoles.stream().findFirst().orElse(null));
        this.addPropertyReader("groups", () -> this.groups);
        this.addPropertyReader("group", () -> this.groups.stream().findFirst().orElse(null));
    }
}

