/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import org.cafienne.actormodel.response.CommandResponseListener;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.command.plan.task.CompleteTask;
import org.cafienne.cmmn.actorapi.command.plan.task.FailTask;
import org.cafienne.cmmn.actorapi.command.plan.task.HandleTaskImplementationTransition;
import org.cafienne.cmmn.actorapi.event.CaseOutputFilled;
import org.cafienne.cmmn.definition.CasePlanDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.StateMachine;
import org.cafienne.cmmn.instance.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasePlan
extends Stage<CasePlanDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(CasePlan.class);

    public CasePlan(String string, CasePlanDefinition casePlanDefinition, Case case_) {
        super(string, 0, (ItemDefinition)casePlanDefinition, casePlanDefinition, null, case_, StateMachine.CasePlan);
    }

    @Override
    protected void suspendInstance() {
        super.suspendInstance();
        this.informParent(Transition.Suspend);
    }

    @Override
    protected void reactivateInstance() {
        super.reactivateInstance();
        this.informParent(Transition.Reactivate);
    }

    @Override
    protected void completeInstance() {
        super.completeInstance();
        this.addEvent(new CaseOutputFilled(this.getCaseInstance(), this.getCaseInstance().getOutputParameters()));
        this.informParent(() -> new CompleteTask(this.getCaseInstance(), this.getCaseInstance().getOutputParameters()));
    }

    @Override
    protected void terminateInstance() {
        super.terminateInstance();
        this.informParent(Transition.Terminate);
    }

    @Override
    protected void failInstance() {
        super.failInstance();
        this.informParent(() -> new FailTask(this.getCaseInstance(), this.getCaseInstance().getOutputParameters()));
    }

    private void informParent(Transition transition) {
        this.informParent(() -> new HandleTaskImplementationTransition(this.getCaseInstance(), transition));
    }

    private void informParent(CommandCreator commandCreator) {
        String string = this.getCaseInstance().getParentCaseId();
        if (string.isEmpty()) {
            return;
        }
        CaseCommand caseCommand = commandCreator.createCommand();
        this.getCaseInstance().informParent(caseCommand, commandFailure -> logger.error("Parent case " + string + " did not accept our request " + caseCommand + " and responded with a failure\n" + commandFailure), new CommandResponseListener[0]);
    }

    @Override
    public void migrateDefinition(CasePlanDefinition casePlanDefinition, boolean bl) {
        this.addDebugInfo(() -> "\nMigrating Case Plan", new Object[0]);
        this.migrateItemDefinition((ItemDefinition)casePlanDefinition, casePlanDefinition, bl);
        this.addDebugInfo(() -> "Completed Case Plan migration\n", new Object[0]);
    }

    @FunctionalInterface
    static interface CommandCreator {
        public CaseCommand createCommand();
    }
}

