/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.sentry.EntryCriterionDefinition;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.CriteriaListener;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.EntryCriterion;
import org.w3c.dom.Element;

public class PlanItemEntry
extends CriteriaListener<EntryCriterionDefinition, EntryCriterion> {
    private Criterion<?> earlyBird = null;

    PlanItemEntry(PlanItem<?> planItem) {
        super(planItem, planItem.getItemDefinition().getEntryCriteria());
    }

    @Override
    protected EntryCriterion createCriterion(EntryCriterionDefinition entryCriterionDefinition) {
        return new EntryCriterion(this, entryCriterionDefinition);
    }

    public void beginLifeCycle() {
        Transition transition = this.item.getEntryTransition();
        if (this.criteria.isEmpty()) {
            this.item.addDebugInfo(() -> this.item + ": Starting lifecycle with " + transition + " because there are no entry criteria defined", new Object[0]);
            this.item.makeTransition(transition);
        } else if (this.earlyBird != null) {
            this.item.addDebugInfo(() -> this.item + ": Starting lifecycle with " + transition + " because of " + this.earlyBird, new Object[0]);
            this.handleCriterionSatisfied(this.earlyBird);
        } else {
            for (Criterion criterion : this.criteria) {
                if (!criterion.isSatisfied()) continue;
                this.item.addDebugInfo(() -> this.item + ": an EntryCriterion is satisfied, making transition " + transition, new Object[0]);
                this.handleCriterionSatisfied(criterion);
                return;
            }
            this.item.addDebugInfo(() -> this.item + ": Not starting lifecycle with " + transition + " because none of the entry criteria is satisfied", new Object[0]);
        }
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    @Override
    public void satisfy(Criterion<?> criterion) {
        if (this.item.getState().isNull()) {
            this.earlyBird = criterion;
            return;
        }
        this.handleCriterionSatisfied(criterion);
    }

    private void handleCriterionSatisfied(Criterion<?> criterion) {
        if (this.item.getIndex() == 0 && this.item.getState().isAvailable()) {
            this.item.addDebugInfo(() -> criterion + " is satisfied and will trigger " + this.item.getEntryTransition(), new Object[0]);
            if (this.willNotRepeat()) {
                this.stopListening();
            }
            this.item.makeTransition(this.item.getEntryTransition());
        } else {
            this.item.addDebugInfo(() -> criterion + " is satisfied and will repeat " + this.item, new Object[0]);
            this.stopListening();
            this.item.repeat("an entry criterion was satisfied");
        }
    }

    private boolean willNotRepeat() {
        return this.item.getItemDefinition().getPlanItemControl().getRepetitionRule().isDefault();
    }

    public void dumpMemoryStateToXML(Element element) {
        if (this.criteria.isEmpty()) {
            return;
        }
        element.appendChild(element.getOwnerDocument().createComment(" Entry criteria "));
        for (Criterion criterion : this.criteria) {
            criterion.dumpMemoryStateToXML(element, true);
        }
    }

    @Override
    protected void migrateCriteria(ItemDefinition itemDefinition, boolean bl) {
        this.migrateCriteria(itemDefinition.getEntryCriteria(), bl);
        if (bl) {
            return;
        }
        if (this.isDisconnected()) {
            return;
        }
        if (this.criteria.isEmpty()) {
            this.beginLifeCycle();
        }
    }
}

