/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import org.cafienne.cmmn.actorapi.event.plan.task.TaskCommandRejected;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskImplementationNotStarted;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskImplementationReactivated;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskImplementationStarted;
import org.cafienne.cmmn.instance.Task;

public class TaskImplementationActorState {
    private final Task<?> task;
    private boolean isStarted = false;
    private boolean foundFailure = false;

    TaskImplementationActorState(Task<?> task) {
        this.task = task;
    }

    public boolean isStarted() {
        return this.isStarted || !this.foundFailure && this.task.getState().isAlive();
    }

    void updateState(TaskImplementationStarted taskImplementationStarted) {
        this.task.addDebugInfo(() -> "Task " + this.task + " confirmed a successful start.", new Object[0]);
        this.isStarted = true;
    }

    void updateState(TaskImplementationNotStarted taskImplementationNotStarted) {
        this.task.addDebugInfo(() -> "Task " + this.task + " could not be started.", new Object[0]);
        this.isStarted = false;
        this.updateState((TaskCommandRejected)taskImplementationNotStarted);
    }

    void updateState(TaskImplementationReactivated taskImplementationReactivated) {
        this.task.addDebugInfo(() -> "Task " + this.task + " confirmed a successful reactivate.", new Object[0]);
        this.isStarted = true;
    }

    void updateState(TaskCommandRejected taskCommandRejected) {
        this.task.addDebugInfo(() -> "Task " + this.task + " reported a command rejection.", taskCommandRejected.rawJson());
        this.foundFailure = true;
    }

    public String toString() {
        return "TaskImplementationActorState{task=" + this.task + ", task.state=" + this.task.getState() + ", isStarted=" + this.isStarted + ", foundFailure=" + this.foundFailure + ", isStarted()=" + this.isStarted() + "}";
    }
}

