/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.casefile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemChildRemoved;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemCollectionDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.casefile.InvalidPathException;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

public abstract class CaseFileItemCollection<T extends CaseFileItemCollectionDefinition>
extends CMMNElement<T> {
    private final List<CaseFileItem> items = new ArrayList<CaseFileItem>();
    protected final CaseFileItemCollection<?> host;

    protected CaseFileItemCollection(Case case_, T t, CaseFileItemCollection<?> caseFileItemCollection) {
        super(case_, t);
        this.host = caseFileItemCollection;
    }

    private CaseFileItem constructItem(CaseFileItemDefinition caseFileItemDefinition) {
        CaseFileItem caseFileItem = caseFileItemDefinition.createInstance(this.getCaseInstance(), this);
        this.items.add(caseFileItem);
        return caseFileItem;
    }

    private void removeItem(CaseFileItem caseFileItem) {
        this.items.remove(caseFileItem);
    }

    protected List<CaseFileItem> getItems() {
        return new ArrayList<CaseFileItem>(this.items);
    }

    public String getName() {
        return ((CaseFileItemCollectionDefinition)this.getDefinition()).getName();
    }

    public void releaseBootstrapEvents() {
        this.getItems().forEach(CaseFileItem::releaseBootstrapEvents);
    }

    public CaseFileItem getArrayElement(int n) {
        throw new InvalidPathException("This is not an iterable case file item");
    }

    public CaseFileItem getItem(String string) {
        for (CaseFileItem object : this.getItems()) {
            if (!object.getName().equals(string)) continue;
            return object;
        }
        CaseFileItemDefinition caseFileItemDefinition = ((CaseFileItemCollectionDefinition)this.getDefinition()).getChild(string);
        if (caseFileItemDefinition == null) {
            return null;
        }
        for (CaseFileItem caseFileItem : this.getItems()) {
            if (!((CaseFileItemDefinition)caseFileItem.getDefinition()).equals(caseFileItemDefinition)) continue;
            return caseFileItem;
        }
        return this.constructItem(caseFileItemDefinition);
    }

    protected boolean isUndefined(String string) {
        return ((CaseFileItemCollectionDefinition)this.getDefinition()).isUndefined(string);
    }

    public abstract void createContent(Value<?> var1);

    public abstract void deleteContent();

    public abstract void replaceContent(Value<?> var1);

    protected void removeReplacedItems(ValueMap valueMap) {
        Set set = ((Map)valueMap.getValue()).keySet();
        List<CaseFileItem> list = this.getItems().stream().filter(caseFileItem -> !set.contains(caseFileItem.getName())).collect(Collectors.toList());
        list.forEach(this::removeChildItem);
    }

    protected void removeChildItem(CaseFileItem caseFileItem) {
        this.addEvent(new CaseFileItemChildRemoved(this, caseFileItem.getPath()));
    }

    public void updateState(CaseFileItemChildRemoved caseFileItemChildRemoved) {
        Path path = caseFileItemChildRemoved.getChildPath();
        CaseFileItem caseFileItem = this.getItem(path.getName());
        if (path.isArrayElement()) {
            ((CaseFileItem)caseFileItem.getContainer()).itemRemoved(path.index);
        } else {
            this.removeItem(caseFileItem);
        }
    }

    public abstract void updateContent(Value<?> var1);

    public abstract void validateTransition(CaseFileItemTransition var1, Value<?> var2);

    public State getState() {
        return State.Available;
    }

    public int getIndex() {
        return -1;
    }

    public Path getPath() {
        return new Path("");
    }

    @Override
    public void migrateDefinition(T t, boolean bl) {
        super.migrateDefinition(t, bl);
        Map<String, CaseFileItemDefinition> map = ((CaseFileItemCollectionDefinition)t).getChildren().stream().collect(Collectors.toMap(XMLElementDefinition::getName, caseFileItemDefinition -> caseFileItemDefinition));
        Map<String, CaseFileItemDefinition> map2 = ((CaseFileItemCollectionDefinition)t).getChildren().stream().collect(Collectors.toMap(XMLElementDefinition::getId, caseFileItemDefinition -> caseFileItemDefinition));
        this.getItems().forEach(caseFileItem -> {
            CaseFileItemDefinition caseFileItemDefinition = (CaseFileItemDefinition)caseFileItem.getDefinition();
            CaseFileItemDefinition caseFileItemDefinition2 = (CaseFileItemDefinition)map.get(caseFileItemDefinition.getName());
            if (caseFileItemDefinition2 != null) {
                caseFileItem.migrateDefinition(caseFileItemDefinition2, bl);
            } else {
                if (bl) {
                    return;
                }
                caseFileItemDefinition2 = (CaseFileItemDefinition)map2.get(caseFileItemDefinition.getId());
                if (caseFileItemDefinition2 != null) {
                    String string = caseFileItemDefinition2.getName();
                    this.addDebugInfo(() -> "Migrating child name '" + caseFileItemDefinition.getName() + "' to '" + string + "'", new Object[0]);
                    caseFileItem.migrateDefinition(caseFileItemDefinition2, bl);
                    caseFileItem.migrateName(caseFileItemDefinition2);
                } else {
                    this.addDebugInfo(() -> "Dropping child CaseFileItem[" + caseFileItem.getPath() + "]", new Object[0]);
                    caseFileItem.lostDefinition();
                }
            }
        });
    }

    protected void childDropped(CaseFileItem caseFileItem) {
        this.items.remove(caseFileItem);
    }

    protected void renameChildItem(String string, String string2) {
    }
}

