/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Consumer;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.sentry.CriterionDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.sentry.Criterion;

public abstract class CriteriaListener<T extends CriterionDefinition, C extends Criterion<T>>
extends CMMNElement<ItemDefinition> {
    protected final PlanItem<?> item;
    protected final Collection<C> criteria = new ArrayList<C>();
    protected final Collection<T> definitions;
    private final String logDescription;
    private boolean isConnected = false;

    protected CriteriaListener(PlanItem<?> planItem, Collection<T> collection) {
        super(planItem, planItem.getItemDefinition());
        this.item = planItem;
        this.definitions = collection;
        this.logDescription = this.getClass().getSimpleName().substring(8).toLowerCase(Locale.ROOT) + " criteria";
    }

    public void startListening() {
        this.isConnected = true;
        this.definitions.forEach(this::addCriterion);
        if (!this.criteria.isEmpty()) {
            this.item.getCaseInstance().addDebugInfo(() -> "Connected " + this.item + " to " + this.criteria.size() + " " + this.logDescription, new Object[0]);
        }
    }

    protected boolean isDisconnected() {
        return !this.isConnected;
    }

    private void addCriterion(T t) {
        this.addDebugInfo(() -> " - creating " + t.toString(), new Object[0]);
        C c = this.createCriterion(t);
        this.criteria.add(c);
    }

    protected abstract C createCriterion(T var1);

    public void stopListening() {
        this.isConnected = false;
        if (!this.criteria.isEmpty()) {
            this.addDebugInfo(() -> "Disconnecting " + this.item + " from " + this.criteria.size() + " " + this.logDescription, new Object[0]);
        }
        new ArrayList<C>(this.criteria).forEach((Consumer<C>)((Consumer<Criterion>)this::release));
    }

    private void release(C c) {
        this.criteria.remove(c);
        ((Criterion)c).release();
    }

    public abstract void satisfy(Criterion<?> var1);

    protected abstract void migrateCriteria(ItemDefinition var1, boolean var2);

    protected void migrateCriteria(Collection<T> collection, boolean bl) {
        if (this.isDisconnected()) {
            this.addDebugInfo(() -> "Skipping " + this.logDescription + " criteria migration of " + this.item + " as they are disconnected", new Object[0]);
            return;
        }
        this.addDebugInfo(() -> {
            if (this.criteria.isEmpty() && collection.isEmpty()) {
                return "";
            }
            return "Migrating " + this.logDescription + " of " + this.item;
        }, new Object[0]);
        ArrayList<C> arrayList = new ArrayList<C>(this.criteria);
        arrayList.forEach(criterion -> this.migrateCriterion(criterion, collection, bl));
        collection.stream().filter(this::notYetHasCriterion).forEach(this::addCriterion);
    }

    private boolean notYetHasCriterion(T t) {
        return this.criteria.stream().noneMatch(criterion -> criterion.getDefinition() == t);
    }

    private void migrateCriterion(C c, Collection<T> collection, boolean bl) {
        DefinitionElement definitionElement = ((Criterion)c).getDefinition();
        CriterionDefinition criterionDefinition = (CriterionDefinition)DefinitionElement.findDefinition(definitionElement, collection);
        if (criterionDefinition != null) {
            ((Criterion)c).migrateDefinition((CriterionDefinition)criterionDefinition, bl);
        } else {
            this.addDebugInfo(() -> " - dropping " + c, new Object[0]);
            this.release(c);
        }
    }
}

