/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.sentry.OnPartDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.cmmn.instance.sentry.TransitionGenerator;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public abstract class OnPart<T extends OnPartDefinition, E extends StandardEvent<?, ?>, I extends TransitionGenerator<E>>
extends CMMNElement<T> {
    protected final Criterion<?> criterion;
    protected Collection<I> connectedItems = new ArrayList<I>();

    protected OnPart(Criterion<?> criterion, T t) {
        super(criterion, t);
        this.criterion = criterion;
    }

    public Criterion<?> getCriterion() {
        return this.criterion;
    }

    @Override
    public String toString() {
        String string = this.connectedItems.isEmpty() ? "" : ": [" + this.connectedItems.stream().map(transitionGenerator -> transitionGenerator.getPath().getPart()).collect(Collectors.joining(",")) + "]";
        return this.getStandardEvent() + " of " + this.getSourceType() + "[" + this.getSourceName() + "] - connected to " + this.connectedItems.size() + " items" + string;
    }

    protected String getSourceName() {
        return ((OnPartDefinition)this.getDefinition()).getSourceDefinition().getName();
    }

    protected String getSourceType() {
        return ((OnPartDefinition)this.getDefinition()).getSourceDefinition().getType();
    }

    abstract Enum<?> getStandardEvent();

    abstract void connectToCase();

    abstract void releaseFromCase();

    protected void establishPotentialConnection(CaseFileItem caseFileItem) {
    }

    protected void removeConnection(CaseFileItem caseFileItem) {
    }

    protected void establishPotentialConnection(PlanItem<?> planItem) {
    }

    protected void removeConnection(PlanItem<?> planItem) {
    }

    public abstract void inform(I var1, E var2);

    abstract ValueMap toJson();

    abstract void dumpMemoryStateToXML(Element var1, boolean var2);
}

