/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.definition.sentry.PlanItemOnPartDefinition;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.OnPart;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public class PlanItemOnPart
extends OnPart<PlanItemOnPartDefinition, PlanItemTransitioned, PlanItem<?>> {
    private boolean isActive;
    private Criterion<?> relatedExitCriterion;
    private PlanItemTransitioned lastEvent;

    public PlanItemOnPart(Criterion<?> criterion, PlanItemOnPartDefinition planItemOnPartDefinition) {
        super(criterion, planItemOnPartDefinition);
    }

    @Override
    protected String getSourceType() {
        return ((PlanItemOnPartDefinition)this.getDefinition()).getSourceDefinition().getPlanItemDefinition().getType();
    }

    Transition getStandardEvent() {
        return ((PlanItemOnPartDefinition)this.getDefinition()).getStandardEvent();
    }

    private boolean isNotSomewhereSibling(PlanItem<?> planItem, PlanItem<?> planItem2) {
        if (planItem2 == null) {
            return true;
        }
        for (PlanItem<?> planItem3 = planItem; planItem3 != null; planItem3 = planItem3.getStage()) {
            if (!planItem3.getItemDefinition().equals(planItem2.getItemDefinition()) || planItem3 == planItem2) continue;
            return false;
        }
        return this.isNotSomewhereSibling(planItem, planItem2.getStage());
    }

    @Override
    void connectToCase() {
        for (PlanItem<?> planItem : new ArrayList(this.getCaseInstance().getPlanItems())) {
            this.establishPotentialConnection(planItem);
        }
    }

    @Override
    protected void establishPotentialConnection(PlanItem<?> planItem) {
        if (this.connectedItems.contains(planItem)) {
            return;
        }
        if (!((PlanItemOnPartDefinition)this.getDefinition()).getSourceDefinition().samePath(planItem.getItemDefinition())) {
            return;
        }
        if (this.isNotSomewhereSibling(planItem, this.getCriterion().getTarget())) {
            this.addDebugInfo(() -> "Connecting " + planItem + " to " + this.criterion, new Object[0]);
            this.connectedItems.add(planItem);
            planItem.connectOnPart(this);
            if (((PlanItemOnPartDefinition)this.getDefinition()).getRelatedExitCriterion() != null) {
                this.relatedExitCriterion = this.getCaseInstance().getSentryNetwork().findRelatedExitCriterion(planItem, ((PlanItemOnPartDefinition)this.getDefinition()).getRelatedExitCriterion());
            }
        } else {
            this.addDebugInfo(() -> "Not connecting plan item " + planItem + " to " + this.criterion + " because it belongs to a sibling stage", new Object[0]);
        }
    }

    @Override
    protected void removeConnection(PlanItem<?> planItem) {
        this.connectedItems.remove(planItem);
    }

    @Override
    public void releaseFromCase() {
        this.connectedItems.forEach(planItem -> planItem.releaseOnPart(this));
    }

    @Override
    public void inform(PlanItem<?> planItem, PlanItemTransitioned planItemTransitioned) {
        this.addDebugInfo(() -> planItem + " informs " + this.criterion + " about transition " + planItemTransitioned.getTransition(), new Object[0]);
        this.lastEvent = planItemTransitioned;
        this.isActive = this.getStandardEvent().equals((Object)planItemTransitioned.getTransition());
        if (this.isActive) {
            if (this.relatedExitCriterion != null) {
                if (this.relatedExitCriterion.isActive()) {
                    this.criterion.activate(this);
                } else {
                    this.addDebugInfo(() -> this.criterion + ": onPart '" + this.getSourceName() + "=>" + planItemTransitioned.getTransition() + "' is not activated, because related exit criterion is not active", this.criterion.toJson());
                }
            } else {
                this.criterion.activate(this);
            }
        } else {
            this.criterion.deactivate(this);
        }
    }

    @Override
    ValueMap toJson() {
        return new ValueMap(new Object[]{"planitem", this.getSourceName(), "active", this.isActive, "awaiting-transition", this.getStandardEvent(), "last-found-transition", "" + this.lastEvent});
    }

    @Override
    void dumpMemoryStateToXML(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("onPart");
        element.appendChild(element2);
        element2.setAttribute("active", "" + this.isActive);
        element2.setAttribute("source", this.getSourceName() + "." + this.getStandardEvent());
        element2.setAttribute("last", "" + this.lastEvent);
        if (bl) {
            for (PlanItem planItem : this.connectedItems) {
                String string = planItem.getName() + "." + planItem.getLastTransition();
                Element element3 = element.getOwnerDocument().createElement("planitem");
                element3.setAttribute("last", string);
                element3.setAttribute("id", planItem.getId());
                element3.setAttribute("stage", planItem.getStage().getId());
                element2.appendChild(element3);
            }
        }
    }
}

