/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.List;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.infrastructure.enginedeveloper.EngineDeveloperConsole;

class TransitionCallStack {
    private Frame currentFrame = null;

    TransitionCallStack() {
    }

    void pushEvent(StandardEvent<?, ?> standardEvent) {
        if (standardEvent.hasBehavior()) {
            Frame frame = new Frame(standardEvent, this.currentFrame);
            frame.invokeImmediateBehavior();
            frame.postponeDelayedBehavior();
        }
    }

    private class Frame {
        private final StandardEvent<?, ?> event;
        private final List<Frame> children = new ArrayList<Frame>();
        private final int depth;

        Frame(StandardEvent<?, ?> standardEvent, Frame frame) {
            this.event = standardEvent;
            this.depth = frame == null ? 1 : frame.depth + 1;
        }

        private String print(String string) {
            return string + " for " + this.event.getSource().getDescription() + "." + this.event.getTransition();
        }

        private void postponeDelayedBehavior() {
            if (TransitionCallStack.this.currentFrame == null) {
                this.invokeDelayedBehavior();
            } else {
                TransitionCallStack.this.currentFrame.children.add(0, this);
                if (EngineDeveloperConsole.enabled()) {
                    EngineDeveloperConsole.debugIndentedConsoleLogging(this.print("* postponing delayed behavior"));
                    EngineDeveloperConsole.indent(2);
                    TransitionCallStack.this.currentFrame.children.forEach(frame -> EngineDeveloperConsole.debugIndentedConsoleLogging("- " + frame.event.getDescription()));
                    EngineDeveloperConsole.outdent(2);
                }
            }
        }

        void invokeImmediateBehavior() {
            EngineDeveloperConsole.indent(2);
            Frame frame = TransitionCallStack.this.currentFrame;
            TransitionCallStack.this.currentFrame = this;
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("\n-------- " + this + this.print("Running immediate behavior"));
            }
            EngineDeveloperConsole.indent(1);
            this.event.runImmediateBehavior();
            EngineDeveloperConsole.outdent(1);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("-------- " + this + this.print("Finished immediate behavior") + "\n");
            }
            EngineDeveloperConsole.outdent(2);
            TransitionCallStack.this.currentFrame = frame;
        }

        void invokeDelayedBehavior() {
            Frame frame = TransitionCallStack.this.currentFrame;
            TransitionCallStack.this.currentFrame = this;
            EngineDeveloperConsole.indent(2);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("\n******** " + this + this.print("Running delayed behavior"));
            }
            EngineDeveloperConsole.indent(1);
            this.event.runDelayedBehavior();
            if (!this.children.isEmpty() && EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging(this + "Loading " + this.children.size() + " nested frames at level [" + (this.depth + 1) + "] as a consequence of " + this.event.getDescription());
            }
            this.children.forEach(Frame::invokeDelayedBehavior);
            EngineDeveloperConsole.outdent(1);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("******** " + this + this.print("Completed delayed behavior"));
            }
            EngineDeveloperConsole.outdent(2);
            TransitionCallStack.this.currentFrame = frame;
        }

        public String toString() {
            return "StackFrame[" + this.depth + "]: ";
        }
    }
}

