/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.repository;

import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.repository.DefinitionProvider;
import org.cafienne.cmmn.repository.WriteDefinitionException;
import org.cafienne.cmmn.repository.file.SimpleLRUCache;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.util.XMLHelper;
import org.xml.sax.SAXException;

public class StartCaseDefinitionProvider
implements DefinitionProvider {
    private final Map<String, DefinitionsDocument> cache = new SimpleLRUCache<String, DefinitionsDocument>(Cafienne.config().repository().cacheSize());
    private static final String AUTHORIZED_TENANT_ROLES = "authorized-tenant-roles";
    private final List<String> authorizedTenantRoles = this.readTenantRoles();

    @Override
    public List<String> list(UserIdentity userIdentity, String string) {
        return new ArrayList<String>();
    }

    private List<String> readTenantRoles() {
        Config config = Cafienne.config().repository().config();
        if (config.hasPath(AUTHORIZED_TENANT_ROLES)) {
            return config.getStringList(AUTHORIZED_TENANT_ROLES);
        }
        return new ArrayList<String>();
    }

    private void checkAccess(UserIdentity userIdentity, String string) {
        if (this.authorizedTenantRoles.isEmpty()) {
            return;
        }
        throw new AuthorizationException("User " + userIdentity.id() + " is not allowed to perform this operation");
    }

    @Override
    public DefinitionsDocument read(UserIdentity userIdentity, String string, String string2) throws InvalidDefinitionException {
        this.checkAccess(userIdentity, string);
        try {
            DefinitionsDocument definitionsDocument = this.cache.get(string2);
            if (definitionsDocument == null) {
                definitionsDocument = new DefinitionsDocument(XMLHelper.loadXML(string2));
                this.cache.put(string2, definitionsDocument);
            }
            return definitionsDocument;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new InvalidDefinitionException("Cannot parse definition", exception);
        }
    }

    @Override
    public void write(UserIdentity userIdentity, String string, String string2, DefinitionsDocument definitionsDocument) throws WriteDefinitionException {
        throw new WriteDefinitionException("This operation is not supported");
    }
}

