/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.repository.DefinitionProvider;
import org.cafienne.cmmn.repository.MissingDefinitionException;
import org.cafienne.cmmn.repository.WriteDefinitionException;
import org.cafienne.cmmn.repository.file.FileBasedDefinition;
import org.cafienne.cmmn.repository.file.SimpleLRUCache;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FileBasedDefinitionProvider
implements DefinitionProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedDefinitionProvider.class);
    private final Map<String, FileBasedDefinition> cache = new SimpleLRUCache<String, FileBasedDefinition>(Cafienne.config().repository().cacheSize());
    private String deployDirectory = null;
    private final String EXTENSION = ".xml";

    @Override
    public List<String> list(UserIdentity userIdentity, String string) {
        return this.listDefinitions();
    }

    @Override
    public DefinitionsDocument read(UserIdentity userIdentity, String string, String object) throws MissingDefinitionException, InvalidDefinitionException {
        if (!((String)object).endsWith(".xml")) {
            object = (String)object + ".xml";
        }
        try {
            long l = -1L;
            InputStream inputStream = null;
            File file = this.getFile((String)object);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
                l = file.lastModified();
            } else {
                inputStream = DefinitionsDocument.class.getClassLoader().getResourceAsStream((String)object);
                if (inputStream == null) {
                    throw new IOException("A file with name " + (String)object + " cannot be found in the deployment directory, nor in the class path");
                }
            }
            FileBasedDefinition fileBasedDefinition = this.cache.get(object);
            if (fileBasedDefinition == null || fileBasedDefinition.lastModified != l) {
                DefinitionsDocument definitionsDocument = new DefinitionsDocument(XMLHelper.getXMLDocument(inputStream));
                fileBasedDefinition = new FileBasedDefinition(l, definitionsDocument);
                this.cache.put((String)object, fileBasedDefinition);
            }
            return fileBasedDefinition.contents;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new MissingDefinitionException("Cannot find or load definition " + (String)object, exception);
        }
    }

    @Override
    public void write(UserIdentity userIdentity, String string, String object, DefinitionsDocument definitionsDocument) throws WriteDefinitionException {
        if (!((String)object).endsWith(".xml")) {
            object = (String)object + ".xml";
        }
        String string2 = this.getDeployDirectory() + File.separator;
        String string3 = string2 + (String)object;
        File file = new File(string3);
        File file2 = new File(string2);
        logger.debug("Saving definitions document " + (String)object + " to " + file.getAbsolutePath());
        try {
            XMLHelper.persist(definitionsDocument.getDocument(), file.getAbsoluteFile());
        }
        catch (IOException | TransformerException exception) {
            String string4 = exception.getMessage().replace(file2.getAbsolutePath() + File.separator, "");
            throw new WriteDefinitionException("Failed to deploy definitions to '" + (String)object + "': " + string4, exception);
        }
    }

    private File getFile(String string) {
        return new File(this.getDeployDirectory() + "/" + string).getAbsoluteFile();
    }

    public String getDeployDirectory() {
        if (this.deployDirectory == null) {
            this.deployDirectory = Cafienne.config().repository().location();
            File file = new File(this.deployDirectory);
            if (!file.exists()) {
                logger.warn("The deploy directory '" + file.getAbsolutePath() + "' does not exist (location configured is '" + this.deployDirectory + "'). The case engine will only read definitions from the class path until the deploy directory is created.");
            } else if (!file.isDirectory()) {
                logger.warn("The deploy directory '" + file.getAbsolutePath() + "' exists but is not a directory (location configured is '" + this.deployDirectory + "'). The case engine will only read definitions from the class path.. Configured location is '" + this.deployDirectory + "'");
            } else {
                logger.info("Reading case definitions from directory " + file.getAbsolutePath());
            }
        }
        return this.deployDirectory;
    }

    public List<String> listDefinitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            File[] fileArray = new File(this.getDeployDirectory()).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsolutePath().endsWith(".xml")) continue;
                arrayList.add(fileArray[i].getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            return arrayList;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        FileBasedDefinitionProvider fileBasedDefinitionProvider = new FileBasedDefinitionProvider();
        Scanner scanner = new Scanner(System.in);
        System.out.println("Usage: DefinitionsDocument [filename] [num parse]");
        while (scanner.hasNextLine()) {
            DefinitionsDocument definitionsDocument;
            String string = scanner.nextLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            long l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                File file = fileBasedDefinitionProvider.getFile(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                definitionsDocument = new DefinitionsDocument(XMLHelper.getXMLDocument(fileInputStream));
            }
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                definitionsDocument = fileBasedDefinitionProvider.read(null, null, string2);
            }
            long l3 = System.currentTimeMillis();
            File file = fileBasedDefinitionProvider.getFile(string2);
            System.out.printf("Parsing file " + string2 + " of size " + file.length() + " every time took %d, caching took %d\n", l2 - l, l3 - l2);
            System.out.println("Usage: DefinitionsDocument [filename] [num parse]");
        }
    }
}

