/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.command;

import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.command.CollectiveCommand;
import org.cafienne.consentgroup.actorapi.exception.ConsentGroupException;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupCreatedResponse;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class CreateConsentGroup
extends CollectiveCommand
implements BootstrapMessage {
    public CreateConsentGroup(ConsentGroupUser consentGroupUser, ConsentGroup consentGroup) {
        super(consentGroupUser, consentGroup);
    }

    public CreateConsentGroup(ValueMap valueMap) {
        super(valueMap);
    }

    @Override
    public void validate(ConsentGroupActor consentGroupActor) throws InvalidCommandException {
        if (consentGroupActor.exists()) {
            throw new ConsentGroupException("Consent group already exists");
        }
    }

    @Override
    public void processGroupCommand(ConsentGroupActor consentGroupActor) {
        consentGroupActor.create(this);
        this.setResponse(new ConsentGroupCreatedResponse(this));
    }

    @Override
    public String tenant() {
        return this.newGroupInfo.tenant();
    }
}

