/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.definition.extension.workflow.FourEyesDefinition;
import org.cafienne.cmmn.definition.extension.workflow.RendezVousDefinition;
import org.cafienne.cmmn.definition.extension.workflow.TaskPairingDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.actorapi.response.HumanTaskResponse;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.humantask.instance.WorkflowTask;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class WorkflowCommand
extends CaseCommand {
    private final String taskId;
    private HumanTask task;

    protected WorkflowCommand(CaseUserIdentity caseUserIdentity, String string, String string2) {
        super(caseUserIdentity, string);
        if (string2 == null || string2.trim().isEmpty()) {
            throw new NullPointerException("Task id should not be null or empty");
        }
        this.taskId = string2;
    }

    protected WorkflowCommand(ValueMap valueMap) {
        super(valueMap);
        this.taskId = valueMap.readString((Object)Fields.taskId, new String[0]);
    }

    protected String getTaskId() {
        return this.taskId;
    }

    @Override
    public void validate(Case case_) throws InvalidCommandException {
        super.validate(case_);
        Object t = case_.getPlanItemById(this.taskId);
        if (t == null) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + ": The task with id " + this.taskId + " could not be found in case " + case_.getId());
        }
        if (!(t instanceof HumanTask)) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + ": The plan item with id " + ((PlanItem)t).getId() + " in case " + case_.getId() + " is not a HumanTask");
        }
        this.task = (HumanTask)t;
        State state = this.task.getState();
        if (state.isSemiTerminal() && state != State.Failed || state == State.Null || state == State.Available) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + " cannot be done because task " + ((PlanItem)t).getName() + " (" + this.taskId + ") is in state " + state);
        }
        this.validate(this.task);
    }

    @Override
    public abstract void validate(HumanTask var1) throws InvalidCommandException;

    @Override
    public void processCaseCommand(Case case_) {
        this.processWorkflowCommand(this.task.getImplementation());
        if (this.getResponse() == null) {
            this.setResponse(new HumanTaskResponse(this));
        }
    }

    public abstract void processWorkflowCommand(WorkflowTask var1);

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.taskId, this.taskId);
    }

    protected void validateState(HumanTask humanTask, TaskState ... taskStateArray) {
        TaskState taskState = humanTask.getImplementation().getCurrentState();
        for (TaskState taskState2 : taskStateArray) {
            if (!taskState2.equals((Object)taskState)) continue;
            return;
        }
        this.raiseException("Cannot be done because the task is in " + taskState + " state, but should be in any of " + Arrays.asList(taskStateArray) + " state");
    }

    protected void mustBeActive(HumanTask humanTask) {
        this.validateProperCaseRole(humanTask);
        TaskState taskState = humanTask.getImplementation().getCurrentState();
        if (!taskState.isActive()) {
            this.raiseException("Cannot be done because the task is not Active but " + taskState);
        }
    }

    protected void verifyTaskPairRestrictions(HumanTask humanTask) {
        this.verifyTaskPairRestrictions(humanTask, (CaseUserIdentity)this.getUser());
    }

    private List<HumanTask> getReferencedTasks(TaskPairingDefinition taskPairingDefinition) {
        return this.task.getCaseInstance().getPlanItems().stream().filter(planItem -> taskPairingDefinition.references(planItem.getItemDefinition())).filter(planItem -> planItem instanceof HumanTask).map(planItem -> (HumanTask)planItem).filter(humanTask -> humanTask.getState().isInitiated()).filter(humanTask -> humanTask.getImplementation().getCurrentState().isWorkedOn()).collect(Collectors.toList());
    }

    protected void verifyTaskPairRestrictions(HumanTask humanTask, CaseUserIdentity caseUserIdentity) {
        List<HumanTask> list;
        TaskPairingDefinition taskPairingDefinition;
        if (humanTask.getItemDefinition().hasFourEyes()) {
            taskPairingDefinition = humanTask.getItemDefinition().getFourEyesDefinition();
            list = this.getReferencedTasks(taskPairingDefinition);
            humanTask.getCaseInstance().addDebugInfo(() -> this.lambda$verifyTaskPairRestrictions$8(humanTask, caseUserIdentity, (FourEyesDefinition)taskPairingDefinition, list), new Object[0]);
            list.forEach(humanTask2 -> {
                if (humanTask2.getImplementation().getAssignee().equals(caseUserIdentity.id())) {
                    this.raiseAuthorizationException("Since you have worked on " + humanTask2.getName() + " you cannot also work on " + humanTask.getName());
                }
            });
        } else {
            humanTask.getCaseInstance().addDebugInfo(() -> "FourEyes Verification is not defined for task " + humanTask.getName(), new Object[0]);
        }
        if (humanTask.getItemDefinition().hasRendezVous()) {
            taskPairingDefinition = humanTask.getItemDefinition().getRendezVousDefinition();
            list = this.getReferencedTasks(taskPairingDefinition);
            humanTask.getCaseInstance().addDebugInfo(() -> this.lambda$verifyTaskPairRestrictions$14(humanTask, caseUserIdentity, (RendezVousDefinition)taskPairingDefinition, list), new Object[0]);
            list.forEach(humanTask2 -> {
                if (!humanTask2.getImplementation().getAssignee().equals(caseUserIdentity.id())) {
                    this.raiseAuthorizationException("Since you have not worked on " + humanTask2.getName() + " you cannot work on " + humanTask.getName());
                }
            });
        } else {
            humanTask.getCaseInstance().addDebugInfo(() -> "RendezVous Verification is not defined for task " + humanTask.getName(), new Object[0]);
        }
    }

    protected void validateCaseOwnership(HumanTask humanTask) {
        if (!humanTask.getCaseInstance().getCurrentTeamMember().isRoleManager(humanTask.getPerformer())) {
            this.raiseAuthorizationException("You must be case owner to perform this operation");
        }
    }

    protected void validateProperCaseRole(HumanTask humanTask) {
        if (!humanTask.currentUserIsAuthorized()) {
            this.raiseAuthorizationException("You do not have permission to perform this operation");
        }
    }

    protected void validateTaskOwnership(HumanTask humanTask) {
        if (humanTask.getCaseInstance().getCurrentTeamMember().isRoleManager(humanTask.getPerformer())) {
            return;
        }
        String string = humanTask.getImplementation().getAssignee();
        if (string == null || string.isEmpty()) {
            this.validateProperCaseRole(humanTask);
        } else {
            String string2 = ((CaseUserIdentity)this.getUser()).id();
            if (!string2.equals(string)) {
                this.raiseAuthorizationException("You do not have permission to perform this operation");
            }
        }
    }

    protected void raiseAuthorizationException(String string) {
        throw new AuthorizationException(this.getClass().getSimpleName() + "[" + this.getTaskId() + "]: " + string);
    }

    protected void raiseException(String string) {
        throw new InvalidCommandException(this.getClass().getSimpleName() + "[" + this.getTaskId() + "]: " + string);
    }

    private /* synthetic */ Object lambda$verifyTaskPairRestrictions$14(HumanTask humanTask2, CaseUserIdentity caseUserIdentity, RendezVousDefinition rendezVousDefinition, List list) {
        ValueMap valueMap = new ValueMap("RendezVous Verification on " + humanTask2.getName(), "Checking " + this.getClass().getSimpleName() + " constraints for user " + caseUserIdentity.id());
        valueMap.plus(" Related tasks", "Rendez-vous has been defined on " + rendezVousDefinition.getAllReferredItemNames());
        String string = " Verification result";
        ValueMap valueMap2 = valueMap.with(string);
        if (list.isEmpty()) {
            valueMap2.plus("ok", "none of the defined elements has been assigned yet, so no need for rendez vous check");
        } else {
            list.forEach(humanTask -> {
                String string = humanTask.getImplementation().getAssignee().equals(caseUserIdentity.id()) ? "check succeeds" : "check fails   ";
                valueMap2.plus(humanTask.getName(), string + " - task is assigned to " + humanTask.getImplementation().getAssignee());
            });
            rendezVousDefinition.getAllReferences().forEach(itemDefinition -> {
                if (list.stream().map(PlanItem::getItemDefinition).noneMatch(itemDefinition2 -> itemDefinition2.equals(itemDefinition))) {
                    valueMap2.plus(itemDefinition.getName(), "check succeeds - task has not yet been assigned");
                }
            });
        }
        return valueMap;
    }

    private /* synthetic */ Object lambda$verifyTaskPairRestrictions$8(HumanTask humanTask2, CaseUserIdentity caseUserIdentity, FourEyesDefinition fourEyesDefinition, List list) {
        ValueMap valueMap = new ValueMap("FourEyes Verification on " + humanTask2.getName(), "Checking " + this.getClass().getSimpleName() + " constraints for user " + caseUserIdentity.id());
        valueMap.plus(" Related tasks", "Four eyes has been defined for " + fourEyesDefinition.getAllReferredItemNames());
        String string = " Verification result";
        ValueMap valueMap2 = valueMap.with(string);
        if (list.isEmpty()) {
            valueMap2.plus("ok", "none of the defined elements has been assigned yet, so no need for four eyes check");
        } else {
            list.forEach(humanTask -> {
                String string = humanTask.getImplementation().getAssignee().equals(caseUserIdentity.id()) ? "check fails   " : "check succeeds";
                valueMap2.plus(humanTask.getName(), string + " - task is assigned to " + humanTask.getImplementation().getAssignee());
            });
            fourEyesDefinition.getAllReferences().forEach(itemDefinition -> {
                if (list.stream().map(PlanItem::getItemDefinition).noneMatch(itemDefinition2 -> itemDefinition2.equals(itemDefinition))) {
                    valueMap2.plus(itemDefinition.getName(), "check succeeds - task has not yet been assigned");
                }
            });
        }
        return valueMap;
    }
}

