/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.infrastructure.serialization.CafienneSerializer;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters;

public interface CafienneSerializable {
    public static final Logger logger = LoggerFactory.getLogger(CafienneSerializer.class);

    default public byte[] toBytes() {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.writeThisObject(jsonGenerator);
            jsonGenerator.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failure in serialization of an object with type " + this.getClass().getName() + "\n" + iOException.getMessage(), iOException);
        }
        catch (Throwable throwable) {
            logger.error("Failed to serialize an object of type " + this.getClass().getName(), throwable);
            throw throwable;
        }
        return byteArrayOutputStream.toByteArray();
    }

    default public String asString() {
        return new String(this.toBytes());
    }

    default public void writeThisObject(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        this.write(jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    public void write(JsonGenerator var1) throws IOException;

    default public void writeListField(JsonGenerator jsonGenerator, Object object, Collection<? extends CafienneJson> collection) throws IOException {
        jsonGenerator.writeArrayFieldStart(String.valueOf(object));
        for (CafienneJson cafienneJson : collection) {
            if (cafienneJson == null) {
                jsonGenerator.writeNull();
                continue;
            }
            cafienneJson.toValue().print(jsonGenerator);
        }
        jsonGenerator.writeEndArray();
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Iterable<String> iterable) throws IOException {
        this.writeField(jsonGenerator, object, CollectionConverters.IterableHasAsJava(iterable).asJavaCollection());
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Collection<String> collection) throws IOException {
        jsonGenerator.writeArrayFieldStart(String.valueOf(object));
        for (String string : collection) {
            if (string == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeEndArray();
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, boolean bl) throws IOException {
        jsonGenerator.writeBooleanField(String.valueOf(object), bl);
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, CMMNElementDefinition cMMNElementDefinition) throws IOException {
        if (cMMNElementDefinition == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeFieldName(String.valueOf(object));
            cMMNElementDefinition.toJSON().print(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Value<?> value) throws IOException {
        if (value == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeFieldName(String.valueOf(object));
            value.print(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, String string) throws IOException {
        if (string == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeStringField(String.valueOf(object), string);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Path path) throws IOException {
        if (path == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeStringField(String.valueOf(object), String.valueOf(path));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Instant instant) throws IOException {
        if (instant == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeStringField(String.valueOf(object), String.valueOf(instant));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, Enum<?> enum_) throws IOException {
        if (enum_ == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeStringField(String.valueOf(object), String.valueOf(enum_));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, CafienneJson cafienneJson) throws IOException {
        if (cafienneJson == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeFieldName(String.valueOf(object));
            cafienneJson.write(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Object object, CafienneSerializable cafienneSerializable) throws IOException {
        if (cafienneSerializable == null) {
            jsonGenerator.writeNullField(String.valueOf(object));
        } else {
            jsonGenerator.writeFieldName(String.valueOf(object));
            cafienneSerializable.writeThisObject(jsonGenerator);
        }
    }
}

