/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.journal.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import javax.sql.DataSource;
import org.cafienne.journal.jdbc.DatabaseDataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.MigrateResult;
import scala.runtime.BoxedUnit;
import slick.jdbc.H2Profile;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.jdbc.PostgresProfile;
import slick.jdbc.SQLServerProfile;

public final class FlywayEventDB$
implements LazyLogging {
    public static final FlywayEventDB$ MODULE$ = new FlywayEventDB$();
    private static final String compatibilityFolder;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        compatibilityFolder = "akka-jdbc-4/";
    }

    private Logger logger$lzycompute() {
        FlywayEventDB$ flywayEventDB$ = this;
        synchronized (flywayEventDB$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private String compatibilityFolder() {
        return compatibilityFolder;
    }

    public MigrateResult validateSchema(JdbcBackend.DatabaseDef db, JdbcProfile profile) {
        BoxedUnit boxedUnit;
        String string;
        DatabaseDataSource dataSource = new DatabaseDataSource(db);
        JdbcProfile jdbcProfile = profile;
        if (jdbcProfile instanceof PostgresProfile) {
            string = this.checkCompatibilityRequirement$1("postgres", "SELECT * FROM journal LIMIT 1", dataSource);
        } else if (jdbcProfile instanceof SQLServerProfile) {
            string = this.checkCompatibilityRequirement$1("sqlserver", "SELECT TOP(1) * FROM journal", dataSource);
        } else if (jdbcProfile instanceof H2Profile) {
            string = "h2";
        } else {
            throw new IllegalArgumentException("Cannot start EventDatabase provider for unsupported JDBC profile of type " + profile.getClass().getName());
        }
        String folder = string;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running event database migrations with scripts " + folder);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String dbScriptsLocation = folder;
        Flyway flyway = Flyway.configure().mixed(true).dataSource((DataSource)dataSource).locations(new String[]{"classpath:db/events/" + dbScriptsLocation}).load();
        return flyway.migrate();
    }

    private final String checkCompatibilityRequirement$1(String folder, String sql, DataSource dataSource$1) {
        Object object;
        try {
            dataSource$1.getConnection().createStatement().executeQuery(sql).next();
            object = this.compatibilityFolder() + folder;
        }
        catch (Throwable throwable) {
            object = folder;
        }
        return object;
    }

    private FlywayEventDB$() {
    }
}

