/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.cafienne.json.Value;

public class ValueList
extends Value<List<Value<?>>>
implements List<Value<?>> {
    public ValueList(Object ... objectArray) {
        super(new ArrayList());
        for (Object object : objectArray) {
            this.add(ValueList.convert(object));
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public void clearOwner() {
        super.clearOwner();
        ((List)this.getValue()).forEach(Value::clearOwner);
    }

    @Override
    public boolean isSupersetOf(Value<?> value) {
        if (value == null || !value.isList()) {
            return false;
        }
        ValueList valueList = value.asList();
        if (valueList.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < valueList.size(); ++i) {
            Object object;
            Object object2 = this.get(i);
            if (((Value)object2).isSupersetOf((Value<?>)(object = valueList.get(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void print(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray(this.value, ((List)this.value).size());
        for (Value value : (List)this.value) {
            if (value != null) {
                value.print(jsonGenerator);
                continue;
            }
            jsonGenerator.writeNull();
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return ((List)this.getValue()).iterator();
    }

    @Override
    public boolean add(Value<?> value) {
        return ((List)this.getValue()).add(value);
    }

    @Override
    public void add(int n, Value<?> value) {
        ((List)this.getValue()).add(n, value);
    }

    @Override
    public boolean addAll(Collection<? extends Value<?>> collection) {
        return ((List)this.getValue()).addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Value<?>> collection) {
        return ((List)this.getValue()).addAll(n, collection);
    }

    @Override
    public void clear() {
        ((List)this.getValue()).clear();
    }

    @Override
    public boolean contains(Object object) {
        return ((List)this.getValue()).contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return ((List)this.getValue()).containsAll(collection);
    }

    @Override
    public Value<?> get(int n) {
        if (n < 0 || n > ((List)this.value).size() - 1) {
            return NULL;
        }
        return (Value)((List)this.getValue()).get(n);
    }

    @Override
    public int indexOf(Object object) {
        return ((List)this.getValue()).indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.getValue()).isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        return ((List)this.getValue()).lastIndexOf(object);
    }

    @Override
    public ListIterator<Value<?>> listIterator() {
        return ((List)this.getValue()).listIterator();
    }

    @Override
    public ListIterator<Value<?>> listIterator(int n) {
        return ((List)this.getValue()).listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return ((List)this.getValue()).remove(object);
    }

    @Override
    public Value<?> remove(int n) {
        return (Value)((List)this.getValue()).remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return ((List)this.getValue()).removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return ((List)this.getValue()).retainAll(collection);
    }

    @Override
    public Value<?> set(int n, Value<?> value) {
        return ((List)this.getValue()).set(n, value);
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public List<Value<?>> subList(int n, int n2) {
        return ((List)this.getValue()).subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return ((List)this.getValue()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ((List)this.getValue()).toArray(TArray);
    }

    public <T> List<T> rawList() {
        List list = (List)this.getValue();
        ArrayList arrayList = new ArrayList();
        list.forEach(value -> arrayList.add(value.getValue()));
        return arrayList;
    }

    public ValueList cloneValueNode() {
        ValueList valueList = new ValueList(new Object[0]);
        int n = ((List)this.value).size();
        for (int i = 0; i < n; ++i) {
            Value value = (Value)((List)this.value).get(i);
            valueList.add(value.cloneValueNode());
        }
        return valueList;
    }

    @Override
    public <V extends Value<?>> V merge(V v) {
        if (!v.isList()) {
            return v;
        }
        ValueList valueList = v.asList();
        for (int i = 0; i < valueList.size(); ++i) {
            Object object = valueList.get(i);
            if (i < this.size()) {
                this.set(i, (Value<?>)((Value)this.get(i)).merge(object));
                continue;
            }
            this.add((Value<?>)object);
        }
        return (V)this;
    }
}

