/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.definition;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public class SubProcessOutputMappingDefinition
extends CMMNElementDefinition {
    private final String sourceRef = this.parseAttribute("sourceRef", true, new String[0]);
    private final String targetRef = this.parseAttribute("targetRef", true, new String[0]);
    private final ExpressionDefinition transformation = this.parse("transformation", ExpressionDefinition.class, false);
    private ParameterDefinition source;
    private ParameterDefinition target;

    public SubProcessOutputMappingDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.target = this.getProcessDefinition().getOutputParameters().get(this.targetRef);
        if (this.target == null) {
            this.getModelDefinition().addReferenceError("Invalid mapping " + this.getId() + ": target parameter " + this.targetRef + " is missing");
        }
        SubProcessDefinition subProcessDefinition = (SubProcessDefinition)this.getParentElement();
        this.source = subProcessDefinition.getRawOutputParameters().get(this.sourceRef);
        if (this.source == null) {
            this.getModelDefinition().addReferenceError("Invalid mapping in process definition " + ((XMLElementDefinition)subProcessDefinition.getParentElement()).getId() + ": source parameter " + this.sourceRef + " cannot be used; use one of " + subProcessDefinition.getRawOutputParameterNames());
        }
    }

    @Override
    public String getContextDescription() {
        SubProcessDefinition subProcessDefinition = (SubProcessDefinition)this.getParentElement();
        String string = ((XMLElementDefinition)subProcessDefinition.getParentElement()).getId();
        return "The mapping in process with id '" + string + "'";
    }

    public Value<?> transformOutput(ProcessTaskActor processTaskActor, ValueMap valueMap) {
        Value<?> value = valueMap.get(this.sourceRef);
        if (this.transformation != null && !this.transformation.getBody().isEmpty()) {
            value = this.transformation.getEvaluator().evaluateOutputParameterTransformation(processTaskActor, value, this.source, this.target);
        }
        return value;
    }

    public ParameterDefinition getTarget() {
        return this.target;
    }

    public ParameterDefinition getSource() {
        return this.source;
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameMapping);
    }

    public boolean sameMapping(SubProcessOutputMappingDefinition subProcessOutputMappingDefinition) {
        return this.same(this.transformation, subProcessOutputMappingDefinition.transformation) && this.same(this.source, subProcessOutputMappingDefinition.source) && this.same(this.target, subProcessOutputMappingDefinition.target);
    }
}

