/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.CalculationDefinition;
import org.cafienne.processtask.implementation.calculation.Result;
import org.cafienne.processtask.implementation.calculation.definition.expression.CalculationExpressionDefinition;
import org.cafienne.processtask.implementation.calculation.definition.expression.ConditionDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.InputReference;
import org.cafienne.processtask.implementation.calculation.definition.source.SourceDefinition;
import org.cafienne.processtask.implementation.calculation.operation.CalculationStep;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Element;

public class StepDefinition
extends CMMNElementDefinition
implements SourceDefinition {
    private final CalculationExpressionDefinition expression;
    private final List<String> inputs;
    private final List<InputReference> inputReferences = new ArrayList<InputReference>();
    private final String identifier;
    private final ConditionDefinition condition;

    public StepDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        this(element, modelDefinition, cMMNElementDefinition, CalculationExpressionDefinition.class);
    }

    protected StepDefinition(Element element2, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition, Class<? extends CalculationExpressionDefinition> clazz) {
        super(element2, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.inputs = XMLHelper.getChildrenWithTagName(element2, "input").stream().map(element -> XMLHelper.getContent(element, null, "")).filter(string -> !string.isBlank()).collect(Collectors.toList());
        this.parse("input", InputReference.class, this.inputReferences);
        this.identifier = this.parseAttribute("output", true, new String[0]);
        this.expression = this.parse("expression", clazz, true);
        this.condition = this.parse("condition", ConditionDefinition.class, false);
    }

    protected StepDefinition(CalculationDefinition calculationDefinition, String string) {
        super(calculationDefinition.getElement(), calculationDefinition.getModelDefinition(), calculationDefinition, new boolean[0]);
        this.identifier = string;
        this.expression = null;
        this.condition = null;
        this.inputs = new ArrayList<String>();
    }

    public InputReference assertOneInput() {
        if (this.inputReferences.size() != 1) {
            this.getProcessDefinition().addDefinitionError(this.getDescription() + " must have precisely 1 input reference; found " + this.inputs.size() + " inputs");
        }
        return this.inputReferences.get(0);
    }

    @Override
    public boolean hasDependency(StepDefinition stepDefinition) {
        return this.inputReferences.stream().filter(inputReference -> inputReference.getSourceReference().equals(stepDefinition.identifier)).count() > 0L;
    }

    public CalculationStep createInstance(Calculation calculation) {
        return new CalculationStep(calculation, this);
    }

    public ConditionDefinition getCondition() {
        return this.condition;
    }

    public Result getResult(Calculation calculation, CalculationStep calculationStep, Map<InputReference, Value<?>> map) {
        return this.expression.getResult(calculation, calculationStep, map);
    }

    @Override
    public Collection<InputReference> getInputs() {
        return this.inputReferences;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getType() {
        return "Step";
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

