/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.implementation.mail.Attachment;
import org.cafienne.processtask.implementation.mail.CalendarInvite;
import org.cafienne.processtask.implementation.mail.InvalidMailException;
import org.cafienne.processtask.implementation.mail.MailAddress;
import org.cafienne.processtask.implementation.mail.MailDefinition;
import org.cafienne.processtask.implementation.mail.MailPart;
import org.cafienne.processtask.implementation.mail.definition.AddressDefinition;
import org.cafienne.processtask.implementation.mail.definition.AttachmentDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class Mail
extends SubProcess<MailDefinition> {
    private ValueMap input;
    private List<MailAddress> from;
    private List<MailAddress> replyTo;
    private List<MailAddress> toList;
    private List<MailAddress> ccList;
    private List<MailAddress> bccList;
    private String subject;
    private Session mailSession;
    private Transport transport;

    public Mail(ProcessTaskActor processTaskActor, MailDefinition mailDefinition) {
        super(processTaskActor, mailDefinition);
    }

    @Override
    public void reactivate() {
        this.start();
    }

    public String getSubject() {
        return this.subject;
    }

    public List<MailAddress> getFrom() {
        return this.from;
    }

    public List<MailAddress> getReplyTo() {
        return this.replyTo;
    }

    public List<MailAddress> getToList() {
        return this.toList;
    }

    public List<MailAddress> getCcList() {
        return this.ccList;
    }

    public List<MailAddress> getBccList() {
        return this.bccList;
    }

    private InternetAddress[] asArray(List<MailAddress> list) {
        return (InternetAddress[])list.stream().map(MailAddress::getAddress).toArray(InternetAddress[]::new);
    }

    private void connectMailServer() throws MessagingException {
        this.processTaskActor.addDebugInfo(() -> "Connecting to mail server", new Object[0]);
        long l = System.currentTimeMillis();
        Properties properties = ((MailDefinition)this.getDefinition()).getMailProperties();
        final String string = properties.get("authentication.user").toString();
        final String string2 = properties.get("authentication.password").toString();
        this.mailSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string, string2);
            }
        });
        this.transport = this.mailSession.getTransport();
        this.transport.connect();
        long l2 = System.currentTimeMillis();
        this.processTaskActor.addDebugInfo(() -> "Connect to mail server took " + (l2 - l) + " milliseconds", new Object[0]);
    }

    private void disconnectMailServer() throws MessagingException {
        long l = System.currentTimeMillis();
        this.transport.close();
        long l2 = System.currentTimeMillis();
        this.processTaskActor.addDebugInfo(() -> "Disconnecting from mail server took " + (l2 - l) + " milliseconds", new Object[0]);
    }

    @Override
    public void start() {
        this.input = this.processTaskActor.getMappedInputParameters();
        try {
            this.connectMailServer();
            this.from = this.resolveAddress(((MailDefinition)this.getDefinition()).getFrom(), "from");
            this.replyTo = this.resolveAddress(((MailDefinition)this.getDefinition()).getReplyTo(), "replyTo");
            this.toList = this.resolveAddressList(((MailDefinition)this.getDefinition()).getToList(), "to");
            this.ccList = this.resolveAddressList(((MailDefinition)this.getDefinition()).getCcList(), "cc");
            this.bccList = this.resolveAddressList(((MailDefinition)this.getDefinition()).getBccList(), "bcc");
            this.subject = this.resolveSubject();
            MimeMessage mimeMessage = new MimeMessage(this.mailSession);
            try {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.asArray(this.toList));
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.asArray(this.ccList));
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.asArray(this.bccList));
            }
            catch (InvalidMailException invalidMailException) {
                this.raiseFault("Failed to set recipients for mail message", invalidMailException.getCause());
                return;
            }
            if (mimeMessage.getAllRecipients() == null || mimeMessage.getAllRecipients().length == 0) {
                this.raiseFault("Mail message has no recipients", new IllegalArgumentException("Mail message has no recipients"));
                return;
            }
            this.processTaskActor.addDebugInfo(() -> "Subject: " + this.subject, new Object[0]);
            mimeMessage.setSubject(this.subject);
            mimeMessage.addFrom((Address[])this.asArray(this.from));
            mimeMessage.setReplyTo((Address[])this.asArray(this.replyTo));
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)this.resolveBody().asPart());
            List<Attachment> list = this.resolveAttachments();
            this.processTaskActor.addDebugInfo(() -> "Adding " + list.size() + " attachments", new Object[0]);
            list.forEach(arg_0 -> Mail.lambda$start$6((Multipart)mimeMultipart, arg_0));
            List<CalendarInvite> list2 = this.resolveInvites();
            this.processTaskActor.addDebugInfo(() -> "Adding " + list2.size() + " calendar invite(s)", new Object[0]);
            list2.forEach(arg_0 -> Mail.lambda$start$8((Multipart)mimeMultipart, arg_0));
            mimeMessage.setContent((Multipart)mimeMultipart);
            this.processTaskActor.addDebugInfo(() -> "Sending message to mail server", new Object[0]);
            long l = System.currentTimeMillis();
            Address[] addressArray = mimeMessage.getAllRecipients();
            this.transport.sendMessage((Message)mimeMessage, addressArray);
            long l2 = System.currentTimeMillis();
            this.processTaskActor.addDebugInfo(() -> "Completed sending email in " + (l2 - l) + " milliseconds", new Object[0]);
            this.disconnectMailServer();
        }
        catch (AddressException addressException) {
            this.raiseFault("Invalid email address in from and/or replyTo", addressException);
            return;
        }
        catch (MessagingException messagingException) {
            this.raiseFault("Failed to generate email message", messagingException);
            return;
        }
        this.raiseComplete();
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }

    private String resolveSubject() {
        if (((MailDefinition)this.getDefinition()).getSubject() == null) {
            return this.input.has("subject") ? this.input.get("subject").getValue().toString() : "";
        }
        return ((MailDefinition)this.getDefinition()).getSubject().resolve(this.processTaskActor, new String[0]);
    }

    private MailPart resolveBody() throws MessagingException {
        MailPart mailPart = new MailPart(this.processTaskActor, (MailDefinition)this.getDefinition());
        this.processTaskActor.addDebugInfo(() -> "Body: " + mailPart, new Object[0]);
        return mailPart;
    }

    private List<Attachment> resolveAttachments() {
        if (((MailDefinition)this.getDefinition()).getAttachmentList().isEmpty()) {
            return ((List)this.input.withArray("attachments").getValue()).stream().filter(value -> {
                if (!value.isMap()) {
                    this.processTaskActor.addDebugInfo(() -> "Attachment must be a json object with 'content' (base64 coded) and optional 'fileName' and 'mimeType'; found json content of type  " + value.getClass().getSimpleName(), new Object[0]);
                }
                return value.isMap();
            }).map(Value::asMap).map(valueMap -> new Attachment((ValueMap)valueMap, this.processTaskActor)).filter(Attachment::hasContent).collect(Collectors.toList());
        }
        return ((MailDefinition)this.getDefinition()).getAttachmentList().stream().map(attachmentDefinition -> new Attachment((AttachmentDefinition)attachmentDefinition, this.processTaskActor)).filter(Attachment::hasContent).collect(Collectors.toList());
    }

    private List<CalendarInvite> resolveInvites() {
        ValueMap valueMap = this.input.with("invite");
        if (!((Map)valueMap.getValue()).isEmpty()) {
            return List.of(new CalendarInvite(this, valueMap));
        }
        return List.of();
    }

    private List<MailAddress> resolveAddress(AddressDefinition addressDefinition, String string) {
        List<AddressDefinition> list = addressDefinition == null ? List.of() : List.of(addressDefinition);
        return this.resolveAddressList(list, string);
    }

    private List<MailAddress> resolveAddressList(List<AddressDefinition> list, String string) {
        List<MailAddress> list2;
        if (list.isEmpty()) {
            Value<?> value = this.input.get(string);
            ValueList valueList = value.isList() ? value.asList() : (value == Value.NULL ? new ValueList(new Object[0]) : new ValueList(new Object[]{value}));
            list2 = ((List)valueList.getValue()).stream().map(MailAddress::new).collect(Collectors.toList());
        } else {
            list2 = list.stream().map(addressDefinition -> new MailAddress((AddressDefinition)addressDefinition, this.processTaskActor)).collect(Collectors.toList());
        }
        this.processTaskActor.addDebugInfo(() -> "Field " + string + ": '" + list2.stream().map(MailAddress::getAddress).map(InternetAddress::toString).collect(Collectors.joining("; ")) + "'", new Object[0]);
        return list2;
    }

    private static /* synthetic */ void lambda$start$8(Multipart multipart, CalendarInvite calendarInvite) {
        try {
            multipart.addBodyPart(calendarInvite.asPart());
        }
        catch (MessagingException messagingException) {
            throw new InvalidMailException("Cannot add the invite attachment", messagingException);
        }
    }

    private static /* synthetic */ void lambda$start$6(Multipart multipart, Attachment attachment) {
        try {
            multipart.addBodyPart(attachment.getBodyPart());
        }
        catch (MessagingException messagingException) {
            throw new InvalidMailException("Cannot add attachment with file name '" + attachment.getFileName() + "'", messagingException);
        }
    }
}

