/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.report;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.implementation.report.JasperDefinition;
import org.cafienne.processtask.implementation.report.JasperSubReportDefinition;
import org.cafienne.processtask.implementation.report.PDFReport;
import org.cafienne.processtask.implementation.report.ReportDataDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public class PDFReportDefinition
extends SubProcessDefinition {
    static final String PDF_REPORT_DATA = "pdfReportData";
    static final String REPORT_XML_TAG = "reportXml";
    static final String SUBREPORT_XML_TAG = "subReportXml";
    static final String REPORT_DATA_TAG = "reportData";
    private final JasperDefinition mainReportDefinition;
    private final Collection<JasperSubReportDefinition> subReportDefinitions = new ArrayList<JasperSubReportDefinition>();
    private final ReportDataDefinition reportDataDefinition;

    public PDFReportDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.mainReportDefinition = this.parse(REPORT_XML_TAG, JasperDefinition.class, true);
        this.parse(SUBREPORT_XML_TAG, JasperSubReportDefinition.class, this.subReportDefinitions);
        this.reportDataDefinition = this.parse(REPORT_DATA_TAG, ReportDataDefinition.class, false);
    }

    public PDFReport createInstance(ProcessTaskActor processTaskActor) {
        return new PDFReport(processTaskActor, this);
    }

    @Override
    public Set<String> getRawOutputParameterNames() {
        Set<String> set = super.getExceptionParameterNames();
        set.add(PDF_REPORT_DATA);
        return set;
    }

    JasperDefinition getReportDefinition() {
        return this.mainReportDefinition;
    }

    Collection<JasperSubReportDefinition> getSubReportDefinitions() {
        return this.subReportDefinitions;
    }

    InputStream createDataStream(PDFReport pDFReport) {
        if (this.reportDataDefinition == null) {
            return ReportDataDefinition.EMPTY_STREAM;
        }
        return this.reportDataDefinition.createDataStream(pDFReport);
    }

    @Override
    public boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

