/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.instance;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.cmmn.actorapi.command.plan.task.CompleteTask;
import org.cafienne.cmmn.actorapi.command.plan.task.FailTask;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.actorapi.command.ProcessCommand;
import org.cafienne.processtask.actorapi.event.ProcessCompleted;
import org.cafienne.processtask.actorapi.event.ProcessDefinitionMigrated;
import org.cafienne.processtask.actorapi.event.ProcessEvent;
import org.cafienne.processtask.actorapi.event.ProcessFailed;
import org.cafienne.processtask.actorapi.event.ProcessModified;
import org.cafienne.processtask.actorapi.event.ProcessReactivated;
import org.cafienne.processtask.actorapi.event.ProcessResumed;
import org.cafienne.processtask.actorapi.event.ProcessStarted;
import org.cafienne.processtask.actorapi.event.ProcessSuspended;
import org.cafienne.processtask.actorapi.event.ProcessTerminated;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.system.CaseSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTaskActor
extends ModelActor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTaskActor.class);
    private ProcessDefinition definition;
    private String name;
    private String parentActorId;
    private String rootActorId;
    private SubProcess<?> taskImplementation;
    private ValueMap inputParameters;
    private ValueMap outputParameters;

    public ProcessTaskActor(CaseSystem caseSystem) {
        super(caseSystem);
    }

    @Override
    protected boolean supportsCommand(Object object) {
        return object instanceof ProcessCommand;
    }

    @Override
    protected boolean supportsEvent(ModelEvent modelEvent) {
        return modelEvent instanceof ProcessEvent;
    }

    public ProcessDefinition getDefinition() {
        return this.definition;
    }

    private void setDefinition(ProcessDefinition processDefinition) {
        this.definition = processDefinition;
    }

    @Override
    public String getParentActorId() {
        return this.parentActorId;
    }

    @Override
    public String getRootActorId() {
        return this.rootActorId;
    }

    public ValueMap getMappedInputParameters() {
        return this.inputParameters;
    }

    public String getName() {
        return this.name;
    }

    public <S extends SubProcess<?>> S getImplementation() {
        return (S)this.taskImplementation;
    }

    public void updateState(ProcessStarted processStarted) {
        this.setEngineVersion(processStarted.engineVersion);
        this.setDebugMode(processStarted.debugMode);
        this.definition = processStarted.definition;
        this.taskImplementation = this.definition.getImplementation().createInstance(this);
        this.name = processStarted.name;
        this.parentActorId = processStarted.parentActorId;
        this.rootActorId = processStarted.rootActorId;
        this.inputParameters = processStarted.inputParameters;
        if (!this.recoveryRunning()) {
            this.addDebugInfo(() -> "Starting process task " + this.name + " with input: ", this.inputParameters);
            ((SubProcess)this.getImplementation()).start();
        }
    }

    public void updateState(ProcessReactivated processReactivated) {
        this.inputParameters = processReactivated.inputParameters;
        if (!this.recoveryRunning()) {
            this.addDebugInfo(() -> "Reactivating process " + this.getName(), new Object[0]);
            ((SubProcess)this.getImplementation()).resetOutput();
            ((SubProcess)this.getImplementation()).reactivate();
        }
    }

    public void updateState(ProcessSuspended processSuspended) {
        if (!this.recoveryRunning()) {
            this.addDebugInfo(() -> "Suspending process " + this.getName(), new Object[0]);
            ((SubProcess)this.getImplementation()).suspend();
        }
    }

    public void updateState(ProcessResumed processResumed) {
        if (!this.recoveryRunning()) {
            this.addDebugInfo(() -> "Resuming process " + this.getName(), new Object[0]);
            ((SubProcess)this.getImplementation()).resume();
        }
    }

    public void updateState(ProcessTerminated processTerminated) {
        if (!this.recoveryRunning()) {
            this.addDebugInfo(() -> "Terminating process " + this.getName(), new Object[0]);
            ((SubProcess)this.getImplementation()).terminate();
        }
    }

    public void updateState(ProcessCompleted processCompleted) {
        this.outputParameters = processCompleted.output;
        this.addDebugInfo(() -> "Completing process task " + this.name + " of process type " + this.getImplementation().getClass().getName() + " with output:", this.outputParameters);
        if (this.recoveryFinished()) {
            this.informParent(new CompleteTask(this, this.outputParameters), commandFailure -> {
                this.addDebugInfo(() -> "Could not complete process task " + this.getId() + " " + this.name + " in parent, due to:", commandFailure.toJson());
                logger.error("Could not complete process task " + this.getId() + " " + this.name + " in parent, due to:\n" + commandFailure);
            }, modelResponse -> this.addDebugInfo(() -> "Completed process task " + this.getId() + " '" + this.name + "' in parent " + this.parentActorId, new Object[0]));
        }
    }

    public void updateState(ProcessFailed processFailed) {
        this.outputParameters = processFailed.output;
        this.informParent(new FailTask(this, this.outputParameters), commandFailure -> logger.error("Could not complete process task " + this.getId() + " " + this.name + " in parent, due to:\n" + commandFailure), modelResponse -> this.addDebugInfo(() -> "Reporting failure of process task " + this.getId() + " " + this.name + " in parent was accepted", new Object[0]));
    }

    public void updateState(ProcessDefinitionMigrated processDefinitionMigrated) {
        this.addDebugInfo(() -> "====== Migrating ProcessTask[" + this.getId() + "] with name " + this.getDefinition().getName() + " to a new definition with name " + processDefinitionMigrated.getNewDefinition().getName() + "\n", new Object[0]);
        this.setDefinition(processDefinitionMigrated.getNewDefinition());
        ((SubProcess)this.getImplementation()).migrateDefinition(processDefinitionMigrated.getNewDefinition().getImplementation());
        this.addDebugInfo(() -> "====== Completed Migration on ProcessTask[" + this.getId() + "] with name " + this.getDefinition().getName(), new Object[0]);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public void completed(ValueMap valueMap) {
        this.addEvent(new ProcessCompleted(this, valueMap));
    }

    public void failed(String string, ValueMap valueMap) {
        this.addDebugInfo(() -> "Encountered failure in process task '" + this.name + "' of process type " + this.getImplementation().getClass().getName(), new Object[0]);
        this.addDebugInfo(() -> "Error: " + string, new Object[0]);
        this.addDebugInfo(() -> "Output: ", valueMap);
        this.addEvent(new ProcessFailed(this, valueMap));
    }

    public void failed(ValueMap valueMap) {
        this.addDebugInfo(() -> "Reporting failure in process task " + this.name + " of process type " + this.getImplementation().getClass().getName() + " with output: ", valueMap);
        this.addEvent(new ProcessFailed(this, valueMap));
    }

    @Override
    protected void addCommitEvent(IncomingActorMessage incomingActorMessage) {
        this.addEvent(new ProcessModified(this, incomingActorMessage));
    }
}

