/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer;

import akka.dispatch.Futures;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cafienne.actormodel.event.ActorModified;
import org.cafienne.actormodel.response.ActorLastModified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Promise;

public class LastModifiedRegistration {
    private static final Logger logger = LoggerFactory.getLogger(LastModifiedRegistration.class);
    private static final Instant startupMoment = Instant.now();
    private final Map<String, Instant> lastModifiedRegistration = new HashMap<String, Instant>();
    private final Map<String, List<Waiter>> waiters = new HashMap<String, List<Waiter>>();
    public final String name;

    public LastModifiedRegistration(String string) {
        this.name = string;
    }

    public Promise<String> waitFor(ActorLastModified actorLastModified) {
        this.log("Executing query after response for " + actorLastModified);
        Promise promise = Futures.promise();
        Instant instant = this.lastModifiedRegistration.get(actorLastModified.getActorId());
        if (instant == null) {
            if (actorLastModified.getLastModified().isBefore(startupMoment)) {
                promise.success((Object)("That's quite an old timestamp; we're not gonna wait for it; we started at " + startupMoment));
            } else {
                this.log("Adding waiter for actor[" + actorLastModified.getActorId() + "] modified at " + actorLastModified.getLastModified());
                this.addWaiter(new Waiter(actorLastModified, (Promise<String>)promise));
            }
        } else if (instant.isBefore(actorLastModified.getLastModified())) {
            this.log("Adding waiter for entity " + actorLastModified.getActorId() + ", because last known moment is " + instant + ", and we're waiting for " + actorLastModified.getLastModified());
            this.addWaiter(new Waiter(actorLastModified, (Promise<String>)promise));
        } else {
            this.log("Returning because already available");
            promise.success((Object)"Your case last modified arrived already!");
        }
        return promise;
    }

    private void log(String object) {
        object = this.name + " in thread: " + Thread.currentThread().getName() + ": " + (String)object;
        logger.debug((String)object);
    }

    public void handle(ActorModified actorModified) {
        this.handle(actorModified.getActorId(), actorModified.lastModified());
    }

    private void handle(String string, Instant instant) {
        Instant instant2 = this.lastModifiedRegistration.get(string);
        if (instant2 == null || instant2.isBefore(instant)) {
            this.lastModifiedRegistration.put(string, instant);
            this.informWaiters(string, instant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informWaiters(String string, Instant instant) {
        Map<String, List<Waiter>> map = this.waiters;
        synchronized (map) {
            List<Waiter> list = this.waiters.remove(string);
            ArrayList<Waiter> arrayList = new ArrayList<Waiter>();
            if (list == null) {
                return;
            }
            this.log("Found " + instant + "/" + string + " for " + list.size() + " waiters");
            for (Waiter waiter : list) {
                if (instant.isBefore(waiter.moment())) {
                    this.log("-need " + waiter.notBefore.getLastModified() + "/" + waiter.notBefore.getActorId());
                    arrayList.add(waiter);
                    continue;
                }
                waiter.stopWaiting();
            }
            if (!arrayList.isEmpty()) {
                this.waiters.put(string, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWaiter(Waiter waiter) {
        Map<String, List<Waiter>> map = this.waiters;
        synchronized (map) {
            List list = this.waiters.computeIfAbsent(waiter.id(), string -> new ArrayList());
            list.add(waiter);
        }
    }

    class Waiter {
        private final ActorLastModified notBefore;
        private final Promise<String> promise;
        private final long createdAt = System.currentTimeMillis();

        Waiter(ActorLastModified actorLastModified, Promise<String> promise) {
            this.notBefore = actorLastModified;
            this.promise = promise;
        }

        void stopWaiting() {
            LastModifiedRegistration.this.log("Waited " + (System.currentTimeMillis() - this.createdAt) + " milliseconds");
            if (!this.promise.isCompleted()) {
                this.promise.success((Object)"Your case last modified arrived just now");
            } else {
                LastModifiedRegistration.this.log("AFTER STOP WAITING, BUT ALREADY COMPLETED?!");
            }
        }

        public String toString() {
            return "Waiter[" + this.notBefore.toString() + "]";
        }

        String id() {
            return this.notBefore.getActorId();
        }

        Instant moment() {
            return this.notBefore.getLastModified();
        }
    }
}

