/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.team;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamGroup;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamTenantRole;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.actorapi.command.team.GroupRoleMapping;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberEvent;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberRemoved;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupAdded;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupChanged;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.team.CaseTeamMemberKey;
import org.cafienne.querydb.record.CaseTeamGroupRecord;
import org.cafienne.querydb.record.CaseTeamTenantRoleRecord;
import org.cafienne.querydb.record.CaseTeamUserRecord;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011)\u0019!C\u0002{!AA\t\u0001B\u0001B\u0003%a\bC\u0003F\u0001\u0011\u0005a\tC\u0004M\u0001\t\u0007I\u0011B'\t\rq\u0003\u0001\u0015!\u0003O\u0011\u001di\u0006A1A\u0005\n5CaA\u0018\u0001!\u0002\u0013q\u0005bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007K\u0002\u0001\u000b\u0011B1\t\u000f\u0019\u0004!\u0019!C\u0005A\"1q\r\u0001Q\u0001\n\u0005Dq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004o\u0001\u0001\u0006IA\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bBB=\u0001A\u0003%1\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0002\u0019\u0007\u0006\u001cX\rV3b[6+WNY3s!J|'.Z2uS>t'B\u0001\u000e\u001c\u0003\u0011!X-Y7\u000b\u0005qi\u0012!B2bg\u0016\u001c(B\u0001\u0010 \u00031i\u0017\r^3sS\u0006d\u0017N_3s\u0015\t\u0001\u0013%A\u0004rk\u0016\u0014\u0018\u0010\u001a2\u000b\u0005\t\u001a\u0013\u0001C2bM&,gN\\3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003eM\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002i\u0005\u00191m\\7\n\u0005Yz#a\u0003'bufdunZ4j]\u001e\fQ\u0002\u001a\"Ue\u0006t7/Y2uS>t\u0007CA\u001d;\u001b\u0005Y\u0012BA\u001e\u001c\u0005Y\u0019\u0015m]3Ti>\u0014\u0018mZ3Ue\u0006t7/Y2uS>t\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005q\u0004CA C\u001b\u0005\u0001%BA!*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0007\u0002\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u000f.#\"\u0001\u0013&\u0011\u0005%\u0003Q\"A\r\t\u000bq\"\u00019\u0001 \t\u000b]\"\u0001\u0019\u0001\u001d\u0002)9,woQ1tKR+\u0017-\\+tKJ\u0014v\u000e\\3t+\u0005q\u0005cA(U-6\t\u0001K\u0003\u0002R%\u00069Q.\u001e;bE2,'BA**\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003+B\u0013!\u0002T5ti\n+hMZ3s!\t9&,D\u0001Y\u0015\tIv$\u0001\u0004sK\u000e|'\u000fZ\u0005\u00037b\u0013!cQ1tKR+\u0017-\\+tKJ\u0014VmY8sI\u0006)b.Z<DCN,G+Z1n+N,'OU8mKN\u0004\u0013\u0001\u0007:f[>4X\rZ\"bg\u0016$V-Y7Vg\u0016\u0014(k\u001c7fg\u0006I\"/Z7pm\u0016$7)Y:f)\u0016\fW.V:feJ{G.Z:!\u0003iqWm^\"bg\u0016$V-Y7UK:\fg\u000e\u001e*pY\u0016\u0014v\u000e\\3t+\u0005\t\u0007cA(UEB\u0011qkY\u0005\u0003Ib\u0013\u0001dQ1tKR+\u0017-\u001c+f]\u0006tGOU8mKJ+7m\u001c:e\u0003mqWm^\"bg\u0016$V-Y7UK:\fg\u000e\u001e*pY\u0016\u0014v\u000e\\3tA\u0005q\"/Z7pm\u0016$7)Y:f)\u0016\fW\u000eV3oC:$(k\u001c7f%>dWm]\u0001 e\u0016lwN^3e\u0007\u0006\u001cX\rV3b[R+g.\u00198u%>dWMU8mKN\u0004\u0013\u0001\u00078fo\u000e\u000b7/\u001a+fC6<%o\\;q\u001b\u0006\u0004\b/\u001b8hgV\t!\u000eE\u0002P).\u0004\"a\u00167\n\u00055D&aE\"bg\u0016$V-Y7He>,\bOU3d_J$\u0017!\u00078fo\u000e\u000b7/\u001a+fC6<%o\\;q\u001b\u0006\u0004\b/\u001b8hg\u0002\nAC]3n_Z,Gm\u0012:pkBl\u0015\r\u001d9j]\u001e\u001c\u0018!\u0006:f[>4X\rZ$s_V\u0004X*\u00199qS:<7\u000fI\u0001\u000fI\u0016dW\r^3e\u001b\u0016l'-\u001a:t+\u0005\u0019\bcA(um&\u0011Q\u000f\u0015\u0002\u0004'\u0016$\bCA%x\u0013\tA\u0018DA\tDCN,G+Z1n\u001b\u0016l'-\u001a:LKf\fq\u0002Z3mKR,G-T3nE\u0016\u00148\u000fI\u0001\fQ\u0006tG\r\\3Fm\u0016tG\u000f\u0006\u0002}\u007fB\u0011\u0001&`\u0005\u0003}&\u0012A!\u00168ji\"9\u0011\u0011A\nA\u0002\u0005\r\u0011!B3wK:$\b\u0007BA\u0003\u0003;\u0001b!a\u0002\u0002\u0016\u0005eQBAA\u0005\u0015\rQ\u00121\u0002\u0006\u0005\u0003\u0003\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001C1di>\u0014\u0018\r]5\u000b\u0007\u0005M\u0011%\u0001\u0003d[6t\u0017\u0002BA\f\u0003\u0013\u00111cQ1tKR+\u0017-\\'f[\n,'/\u0012<f]R\u0004B!a\u0007\u0002\u001e1\u0001AaCA\u0010\u007f\u0006\u0005\t\u0011!B\u0001\u0003C\u00111a\u0018\u00132#\u0011\t\u0019#!\u000b\u0011\u0007!\n)#C\u0002\u0002(%\u0012qAT8uQ&tw\rE\u0002)\u0003WI1!!\f*\u0005\r\te._\u0001\u0010Q\u0006tG\r\\3Vg\u0016\u0014XI^3oiR)A0a\r\u0002@!9\u0011\u0011\u0001\u000bA\u0002\u0005U\u0002\u0007BA\u001c\u0003w\u0001b!a\u0002\u0002\u0016\u0005e\u0002\u0003BA\u000e\u0003w!A\"!\u0010\u00024\u0005\u0005\t\u0011!B\u0001\u0003C\u00111a\u0018\u00134\u0011\u001d\t\t\u0005\u0006a\u0001\u0003\u0007\nA!^:feB!\u0011QIA'\u001b\t\t9EC\u0002\u001b\u0003\u0013RA!a\u0013\u0002\u000e\u000591m\\7nC:$\u0017\u0002BA(\u0003\u000f\u0012AbQ1tKR+\u0017-\\+tKJ\fQ\u0003[1oI2,G+\u001a8b]R\u0014v\u000e\\3Fm\u0016tG\u000fF\u0003}\u0003+\n\t\u0007C\u0004\u0002\u0002U\u0001\r!a\u00161\t\u0005e\u0013Q\f\t\u0007\u0003\u000f\t)\"a\u0017\u0011\t\u0005m\u0011Q\f\u0003\r\u0003?\n)&!A\u0001\u0002\u000b\u0005\u0011\u0011\u0005\u0002\u0004?\u0012\"\u0004bBA2+\u0001\u0007\u0011QM\u0001\u000fi\u0016\fW\u000eV3oC:$(k\u001c7f!\u0011\t)%a\u001a\n\t\u0005%\u0014q\t\u0002\u0013\u0007\u0006\u001cX\rV3b[R+g.\u00198u%>dW-\u0001\tiC:$G.Z$s_V\u0004XI^3oiR)A0a\u001c\u0002|!9\u0011\u0011\u0001\fA\u0002\u0005E\u0004\u0007BA:\u0003o\u0002b!a\u0002\u0002\u0016\u0005U\u0004\u0003BA\u000e\u0003o\"A\"!\u001f\u0002p\u0005\u0005\t\u0011!B\u0001\u0003C\u00111a\u0018\u00136\u0011\u001d\tiH\u0006a\u0001\u0003\u007f\nQa\u001a:pkB\u0004B!!\u0012\u0002\u0002&!\u00111QA$\u00055\u0019\u0015m]3UK\u0006lwI]8va\u0006i\u0001O]3qCJ,7i\\7nSR$\u0012\u0001 ")
public class CaseTeamMemberProjection
implements LazyLogging {
    private final CaseStorageTransaction dBTransaction;
    private final ExecutionContext executionContext;
    private final ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles;
    private final ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings;
    private final ListBuffer<CaseTeamGroupRecord> removedGroupMappings;
    private final Set<CaseTeamMemberKey> deletedMembers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseTeamMemberProjection caseTeamMemberProjection = this;
        synchronized (caseTeamMemberProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles() {
        return this.newCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles() {
        return this.removedCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles() {
        return this.newCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles() {
        return this.removedCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings() {
        return this.newCaseTeamGroupMappings;
    }

    private ListBuffer<CaseTeamGroupRecord> removedGroupMappings() {
        return this.removedGroupMappings;
    }

    private Set<CaseTeamMemberKey> deletedMembers() {
        return this.deletedMembers;
    }

    public void handleEvent(CaseTeamMemberEvent<?> event) {
        if (event instanceof CaseTeamMemberRemoved) {
            Object member = event.member;
            this.deletedMembers().$plus$eq((Object)new CaseTeamMemberKey(event.getActorId(), member.memberId(), member.memberType()));
            return;
        }
        Object Member2 = event.member;
        if (Member2 instanceof CaseTeamUser) {
            CaseTeamUser caseTeamUser = (CaseTeamUser)Member2;
            this.handleUserEvent(event, caseTeamUser);
            return;
        }
        if (Member2 instanceof CaseTeamTenantRole) {
            CaseTeamTenantRole caseTeamTenantRole = (CaseTeamTenantRole)Member2;
            this.handleTenantRoleEvent(event, caseTeamTenantRole);
            return;
        }
        if (Member2 instanceof CaseTeamGroup) {
            CaseTeamGroup caseTeamGroup = (CaseTeamGroup)Member2;
            this.handleGroupEvent(event, caseTeamGroup);
            return;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Unexpected type of case team member {} while handling event of type ", (Object)Member2.getClass().getSimpleName());
            return;
        }
    }

    public void handleUserEvent(CaseTeamMemberEvent<?> event, CaseTeamUser user) {
        String caseInstanceId = event.getActorId();
        String memberId = user.memberId();
        boolean isOwner = user.isOwner();
        scala.collection.immutable.Set caseRoles = (scala.collection.immutable.Set)user.caseRoles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})));
        scala.collection.immutable.Set<String> removedRoles = user.rolesRemoved();
        String origin = user.origin().toString();
        this.newCaseTeamUserRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
        this.removedCaseTeamUserRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
    }

    public void handleTenantRoleEvent(CaseTeamMemberEvent<?> event, CaseTeamTenantRole teamTenantRole) {
        String caseInstanceId = event.getActorId();
        String memberId = teamTenantRole.memberId();
        boolean isOwner = teamTenantRole.isOwner();
        scala.collection.immutable.Set caseRoles = (scala.collection.immutable.Set)teamTenantRole.caseRoles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})));
        scala.collection.immutable.Set<String> removedRoles = teamTenantRole.rolesRemoved();
        this.newCaseTeamTenantRoleRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> {
            String x$1 = caseInstanceId;
            String x$2 = memberId;
            String x$3 = event$2.tenant;
            String x$4 = caseRole;
            boolean x$5 = isOwner;
            return new CaseTeamTenantRoleRecord(x$1, x$3, x$2, x$4, x$5);
        }));
        this.removedCaseTeamTenantRoleRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> {
            String x$6 = caseInstanceId;
            String x$7 = memberId;
            String x$8 = event$2.tenant;
            String x$9 = caseRole;
            boolean x$10 = isOwner;
            return new CaseTeamTenantRoleRecord(x$6, x$8, x$7, x$9, x$10);
        }));
    }

    public void handleGroupEvent(CaseTeamMemberEvent<?> event, CaseTeamGroup group) {
        CaseTeamMemberEvent<?> caseTeamMemberEvent = event;
        if (caseTeamMemberEvent instanceof CaseTeamGroupAdded) {
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            return;
        }
        if (caseTeamMemberEvent instanceof CaseTeamGroupChanged) {
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            this.removedGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> (scala.collection.immutable.Set)mapping.rolesRemoved().map((Function1 & Serializable)x$2 -> CaseTeamMemberProjection.asRecord$1(mapping, x$2, event, group))));
            this.removedGroupMappings().addAll((IterableOnce)group.removedMappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecords$1(mapping, event, group)));
            return;
        }
    }

    public void prepareCommit() {
        this.removedCaseTeamUserRoles().foreach((Function1 & Serializable)roleRemoved -> {
            this.dBTransaction.delete(roleRemoved);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamUserRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.dBTransaction.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleRemoval -> {
            this.dBTransaction.delete(roleRemoval);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.dBTransaction.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.dBTransaction.delete(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.dBTransaction.upsert(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.deletedMembers().foreach((Function1 & Serializable)key -> {
            this.dBTransaction.deleteCaseTeamMember(key);
            return BoxedUnit.UNIT;
        });
    }

    private static final scala.collection.immutable.Set asRecords$1(GroupRoleMapping mapping, CaseTeamMemberEvent event$3, CaseTeamGroup group$1) {
        return (scala.collection.immutable.Set)mapping.caseRoles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))).map((Function1 & Serializable)x$1 -> CaseTeamMemberProjection.asRecord$1(mapping, x$1, event$3, group$1));
    }

    private static final CaseTeamGroupRecord asRecord$1(GroupRoleMapping mapping, String caseRole, CaseTeamMemberEvent event$3, CaseTeamGroup group$1) {
        String x$1 = event$3.getActorId();
        String x$2 = event$3.tenant;
        String x$3 = group$1.groupId();
        String x$4 = caseRole;
        String x$5 = mapping.groupRole();
        boolean x$6 = mapping.isOwner();
        return new CaseTeamGroupRecord(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public CaseTeamMemberProjection(CaseStorageTransaction dBTransaction, ExecutionContext executionContext) {
        this.dBTransaction = dBTransaction;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.newCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deletedMembers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

