/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.ConsentGroupMembership;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.actormodel.identity.Origin;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember$;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.querydb.query.UserQueries;
import org.cafienne.querydb.query.exception.ConsentGroupMemberSearchFailure;
import org.cafienne.querydb.query.exception.ConsentGroupSearchFailure;
import org.cafienne.querydb.query.exception.TenantSearchFailure;
import org.cafienne.querydb.query.exception.TenantUserSearchFailure;
import org.cafienne.querydb.query.exception.UserSearchFailure;
import org.cafienne.querydb.record.ConsentGroupMemberRecord;
import org.cafienne.querydb.record.ConsentGroupRecord;
import org.cafienne.querydb.record.TenantRecord;
import org.cafienne.querydb.record.UserRoleRecord;
import org.cafienne.querydb.schema.QueryDBSchema;
import org.cafienne.querydb.schema.table.CaseTables;
import org.cafienne.querydb.schema.table.ConsentGroupTables;
import org.cafienne.querydb.schema.table.TenantTables;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.basic.DatabaseConfig;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BaseJoinQuery;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionLift$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;
import slick.migration.api.MigrationSeq;
import slick.sql.SqlAction;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001B\u000b\u0017\u0001}AQA\u0011\u0001\u0005\u0002\rCq!\u0012\u0001C\u0002\u0013\ra\t\u0003\u0004N\u0001\u0001\u0006Ia\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019a\u0006\u0001)A\u0005!\")Q\f\u0001C!=\")Q\u000f\u0001C!m\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002r\u0001!\t%a\u001d\t\rU\u0004A\u0011IA=\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002(\u0002!I!!+\t\u000f\u0005M\b\u0001\"\u0011\u0002v\"9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\u000b\u0001\u0011\u0005#q\u0003\u0002\u0012)\u0016t\u0017M\u001c;Rk\u0016\u0014\u0018.Z:J[Bd'BA\f\u0019\u0003\u0015\tX/\u001a:z\u0015\tI\"$A\u0004rk\u0016\u0014\u0018\u0010\u001a2\u000b\u0005ma\u0012\u0001C2bM&,gN\\3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u0011'UQbt\b\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011AF\u0005\u0003SY\u00111\"V:feF+XM]5fgB\u00111FM\u0007\u0002Y)\u0011QFL\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003_A\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002c\u0005\u00191m\\7\n\u0005Mb#a\u0003'bufdunZ4j]\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000bQ\f'\r\\3\u000b\u0005eB\u0012AB:dQ\u0016l\u0017-\u0003\u0002<m\taA+\u001a8b]R$\u0016M\u00197fgB\u0011Q'P\u0005\u0003}Y\u0012!cQ8og\u0016tGo\u0012:pkB$\u0016M\u00197fgB\u0011Q\u0007Q\u0005\u0003\u0003Z\u0012!bQ1tKR\u000b'\r\\3t\u0003\u0019a\u0014N\\5u}Q\tA\t\u0005\u0002(\u0001\u0005\u0011QmY\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JI\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001'J\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\n!B]8mKN\fV/\u001a:z+\u0005\u0001\u0006cA)W16\t!K\u0003\u0002T)\u00061A.\u001b4uK\u0012T\u0011!V\u0001\u0006g2L7m[\u0005\u0003/J\u0013!\u0002V1cY\u0016\fV/\u001a:z!\tI&,D\u0001\u0001\u0013\tY&HA\u0007Vg\u0016\u0014(k\u001c7f)\u0006\u0014G.Z\u0001\fe>dWm])vKJL\b%A\u0005hKR$VM\\1oiR\u0011q\f\u001b\t\u0004\u0011\u0002\u0014\u0017BA1J\u0005\u00191U\u000f^;sKB\u00111MZ\u0007\u0002I*\u0011Q\rG\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005\u001d$'\u0001\u0004+f]\u0006tGOU3d_J$\u0007\"B5\u0007\u0001\u0004Q\u0017\u0001\u0003;f]\u0006tG/\u00133\u0011\u0005-\u0014hB\u00017q!\ti'%D\u0001o\u0015\tyg$\u0001\u0004=e>|GOP\u0005\u0003c\n\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011OI\u0001\u000eO\u0016$H+\u001a8b]R,6/\u001a:\u0015\u000b]\f\t!a\u0003\u0011\u0007!\u0003\u0007\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006A\u0011\u000eZ3oi&$\u0018P\u0003\u0002~5\u0005Q\u0011m\u0019;pe6|G-\u001a7\n\u0005}T(A\u0003+f]\u0006tG/V:fe\"9\u00111A\u0004A\u0002\u0005\u0015\u0011\u0001B;tKJ\u00042!_A\u0004\u0013\r\tIA\u001f\u0002\r+N,'/\u00133f]RLG/\u001f\u0005\u0007\u0003\u001b9\u0001\u0019\u00016\u0002\rQ,g.\u00198u\u0003=9W\r\u001e)mCR4wN]7Vg\u0016\u0014H\u0003BA\n\u00037\u0001B\u0001\u00131\u0002\u0016A\u0019\u00110a\u0006\n\u0007\u0005e!P\u0001\u0007QY\u0006$hm\u001c:n+N,'\u000f\u0003\u0004\u0002\u001e!\u0001\rA[\u0001\u0007kN,'/\u00133\u0002-\u0011,G/\u001a:nS:,wJ]5hS:|e-V:feN$b!a\t\u0002D\u0005%\u0003\u0003\u0002%a\u0003K\u0001b!a\n\u00022\u0005]b\u0002BA\u0015\u0003[q1!\\A\u0016\u0013\u0005\u0019\u0013bAA\u0018E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\tyC\t\t\u0007C\u0005e\".!\u0010\n\u0007\u0005m\"E\u0001\u0004UkBdWM\r\t\u0004s\u0006}\u0012bAA!u\n1qJ]5hS:Dq!!\u0012\n\u0001\u0004\t9%A\u0003vg\u0016\u00148\u000fE\u0003\u0002(\u0005E\"\u000e\u0003\u0004\u0002\u000e%\u0001\rA[\u0001\u000fO\u0016$H+\u001a8b]R,6/\u001a:t)\u0011\ty%a\u0015\u0011\t!\u0003\u0017\u0011\u000b\t\u0006\u0003O\t\t\u0004\u001f\u0005\u0007\u0003\u0007Q\u0001\u0019\u0001=\u0002%I,\u0017\rZ!mYR+g.\u00198u+N,'o\u001d\u000b\u0005\u0003\u001f\nI\u0006\u0003\u0004\u0002\u0004-\u0001\r\u0001_\u0001\u0011GJ,\u0017\r^3UK:\fg\u000e^+tKJ$R\u0001_A0\u0003OBq!a\u0001\r\u0001\u0004\t\t\u0007E\u0002d\u0003GJ1!!\u001ae\u00059)6/\u001a:S_2,'+Z2pe\u0012Dq!!\u001b\r\u0001\u0004\tY'A\u0003s_2,7\u000f\u0005\u0003l\u0003[R\u0017bAA8i\n\u00191+\u001a;\u0002;\u001d,G\u000fR5tC\ndW\r\u001a+f]\u0006tG/V:fe\u0006\u001b7m\\;oiN$B!a\u0014\u0002v!1\u0011qO\u0007A\u0002a\f!\u0002^3oC:$Xk]3s)\u00159\u00181PA?\u0011\u0019\t9H\u0004a\u0001q\"1\u0011Q\u0004\bA\u0002)\f\u0001cZ3u\u0007>t7/\u001a8u\u000fJ|W\u000f]:\u0015\t\u0005\r\u0015q\u0013\t\u0005\u0011\u0002\f)\t\u0005\u0004\u0002(\u0005E\u0012q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003!\t7\r^8sCBL'bAAI5\u0005a1m\u001c8tK:$xM]8va&!\u0011QSAF\u00051\u0019uN\\:f]R<%o\\;q\u0011\u001d\tIj\u0004a\u0001\u0003\u000f\n\u0001b\u001a:pkBLEm]\u0001\u0010O\u0016$8i\u001c8tK:$xI]8vaR1\u0011qTAQ\u0003G\u0003B\u0001\u00131\u0002\b\"9\u00111\u0001\tA\u0002\u0005\u0015\u0001BBAS!\u0001\u0007!.A\u0004he>,\b/\u00133\u00027\r|gn]3oi\u001e\u0013x.\u001e9NK6\u0014WM]:iSB\fV/\u001a:z)\u0019\tY+!;\u0002lBQ\u0011QVAj\u00037\f\t/a:\u000f\t\u0005=\u0016q\u0019\b\u0005\u0003c\u000bYLD\u0002Z\u0003gKA!!.\u00028\u0006AAMY\"p]\u001aLw-C\u0002\u0002:b\u0012Q\"U;fef$%iU2iK6\f\u0017\u0002BA_\u0003\u007f\u000bq\u0001\u001d:pM&dW-\u0003\u0003\u0002B\u0006\r'A\u0004#bi\u0006\u0014\u0017m]3D_:4\u0017n\u001a\u0006\u0004\u0003\u000b$\u0016!\u00022bg&\u001c\u0017\u0002BAe\u0003\u0017\f1!\u00199j\u0013\u0011\ti-a4\u0003\u0017)#'m\u0019)s_\u001aLG.\u001a\u0006\u0004\u0003#$\u0016\u0001\u00026eE\u000eLA!!6\u0002X\n)\u0011+^3ss&\u0019\u0011\u0011\u001c*\u0003\u000f\u0005c\u0017.Y:fgB\u0019\u0011,!8\n\u0007\u0005}WHA\fD_:\u001cXM\u001c;He>,\b/T3nE\u0016\u0014H+\u00192mKB\u00191-a9\n\u0007\u0005\u0015HM\u0001\rD_:\u001cXM\u001c;He>,\b/T3nE\u0016\u0014(+Z2pe\u0012\u0004B!a\n\u00022!9\u00111A\tA\u0002\u0005\u0015\u0001bBAS#\u0001\u0007\u0011Q\u001e\t\u0006\u0003[\u000byO[\u0005\u0005\u0003c\f9NA\u0002SKB\fQcZ3u\u0007>t7/\u001a8u\u000fJ|W\u000f]'f[\n,'\u000f\u0006\u0005\u0002x\u0006}(\u0011\u0001B\u0002!\u0011A\u0005-!?\u0011\t\u0005%\u00151`\u0005\u0005\u0003{\fYI\u0001\nD_:\u001cXM\u001c;He>,\b/T3nE\u0016\u0014\bbBA\u0002%\u0001\u0007\u0011Q\u0001\u0005\u0007\u0003K\u0013\u0002\u0019\u00016\t\r\u0005u!\u00031\u0001k\u0003M9W\r^\"p]N,g\u000e^$s_V\u0004Xk]3s)\u0019\u0011IA!\u0005\u0003\u0014A!\u0001\n\u0019B\u0006!\rI(QB\u0005\u0004\u0005\u001fQ(\u0001E\"p]N,g\u000e^$s_V\u0004Xk]3s\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000bAa!!*\u0014\u0001\u0004Q\u0017\u0001F4fiR+g.\u00198u\u000fJ|W\u000f]:Vg\u0006<W\r\u0006\u0004\u0003\u001a\t]\"\u0011\b\t\u0005\u0011\u0002\u0014Y\u0002\u0005\u0004l\u0005;Q'\u0011E\u0005\u0004\u0005?!(aA'baB9!1\u0005B\u0017U\nERB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u000f5,H/\u00192mK*\u0019!1\u0006\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00030\t\u0015\"a\u0002%bg\"l\u0015\r\u001d\t\u0006\u0005G\u0011\u0019D[\u0005\u0005\u0005k\u0011)C\u0001\u0006MSN$()\u001e4gKJDa!a\u0001\u0015\u0001\u0004A\bBBA\u0007)\u0001\u0007!\u000e")
public class TenantQueriesImpl
implements UserQueries,
LazyLogging,
TenantTables,
ConsentGroupTables,
CaseTables {
    private final ExecutionContext ec;
    private final TableQuery<TenantTables.UserRoleTable> rolesQuery;
    private DatabaseConfig<JdbcProfile> dbConfig;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public <CT extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<CT, E> QueryHelper(Query<CT, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$(this, query);
    }

    @Override
    public <CTT extends CafienneJDBCConfig.CafienneTenantTable<?>, E> CafienneJDBCConfig.TenantQueryHelper<CTT, E> TenantQueryHelper(Query<CTT, E, Seq> query) {
        return CafienneJDBCConfig.TenantQueryHelper$(this, query);
    }

    @Override
    public MigrationSeq asSqlMigration(SqlAction<?, ?, ?> action) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, action);
    }

    @Override
    public MigrationSeq asSqlMigration(Seq<String> sql) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, sql);
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = QueryDBSchema.dbConfig$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.dbConfig$lzycompute();
        }
        return this.dbConfig;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    @Override
    public JdbcBackend.DatabaseDef db() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.db$lzycompute();
        }
        return this.db;
    }

    private boolean isSQLServer$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    @Override
    public boolean isSQLServer() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.isSQLServer$lzycompute();
        }
        return this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    @Override
    public Dialect<? extends JdbcProfile> dialect() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.dialect$lzycompute();
        }
        return this.dialect;
    }

    private Logger logger$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public TableQuery<TenantTables.UserRoleTable> rolesQuery() {
        return this.rolesQuery;
    }

    @Override
    public Future<TenantRecord> getTenant(String tenantId) {
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.TenantTable(this, (Tag)tag)).filter((Function1 & Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$2 -> x$2.enabled(), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                throw new TenantSearchFailure(tenantId);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                TenantRecord record = (TenantRecord)some.value();
                return record;
            }
            throw new MatchError((Object)option);
        }, this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(UserIdentity user, String tenant) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$3 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$3.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$4 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$4.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            UserRoleRecord userRecord = (UserRoleRecord)records.find((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$5(record))).fold((Function0 & Serializable)() -> {
                throw new TenantUserSearchFailure(tenant, user.id());
            }, (Function1 & Serializable)r -> r);
            Set roles = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$8(record)))).map((Function1 & Serializable)x$5 -> x$5.role_name())).toSet();
            return this.createTenantUser(userRecord, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<PlatformUser> getPlatformUser(String userId) {
        Query tenantUsersQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$6 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$6.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$7.enabled(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query consentGroupsQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$8 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$8.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Future dbRetrieval = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(tenantUsersQuery)).result()).flatMap((Function1 & Serializable)tenantRecords -> this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupsQuery)).result()).map((Function1 & Serializable)groupRecords -> new Tuple2(tenantRecords, groupRecords), this.ec()), this.ec());
        return dbRetrieval.map((Function1 & Serializable)records -> {
            Seq tenantRecords = (Seq)((IterableOps)records._1()).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$9(userId, x$9)));
            Seq groupRecords = (Seq)((IterableOps)records._2()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$10(userId, x$10)));
            Seq tenantUsers = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOnceOps)tenantRecords.map((Function1 & Serializable)x$11 -> x$11.tenant())).toSet().map((Function1 & Serializable)tenant -> {
                Seq userRecords = (Seq)tenantRecords.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$13(tenant, x$12)));
                Set roles = ((IterableOnceOps)((IterableOps)userRecords.filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$14(x$13)))).map((Function1 & Serializable)x$14 -> x$14.role_name())).toSet();
                Option user = userRecords.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$16(x$15)));
                if (user.isEmpty()) {
                    return None$.MODULE$;
                }
                return new Some((Object)this.createTenantUser((UserRoleRecord)user.get(), (Set<String>)roles));
            })).filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.nonEmpty()))).map((Function1 & Serializable)x$17 -> (TenantUser)x$17.get())).toSeq();
            Seq groups = ((IterableOnceOps)((IterableOnceOps)((IterableOps)groupRecords.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$19(x$18)))).map((Function1 & Serializable)x$19 -> x$19.group())).toSet().map((Function1 & Serializable)groupId -> {
                Seq groupInfo = (Seq)groupRecords.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUser$22(groupId, x$20)));
                Set roles = ((IterableOnceOps)groupInfo.map((Function1 & Serializable)x$21 -> x$21.role())).toSet();
                boolean isOwner = groupInfo.exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isOwner()));
                return new ConsentGroupMembership((String)groupId, (Set<String>)roles, isOwner);
            })).toSeq();
            return new PlatformUser(userId, (Seq<TenantUser>)tenantUsers, (Seq<ConsentGroupMembership>)groups);
        }, this.ec());
    }

    @Override
    public Future<Seq<Tuple2<String, Origin>>> determineOriginOfUsers(Seq<String> users, String tenant) {
        Query tenantMembership = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$23 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$23.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$24 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$24.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$25 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$25.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$26 -> x$26.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        Query platformRegistration = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$27 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$27.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$28 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$28.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$29 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$29.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$30 -> x$30.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        BaseJoinQuery query = tenantMembership.joinFull(platformRegistration, OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods((Query)query)).result()).map((Function1 & Serializable)records -> {
            Set tenantUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$12(x$31)))).map((Function1 & Serializable)x$32 -> (String)((Option)x$32._1()).get())).toSet();
            Set platformUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$14(x$33)))).map((Function1 & Serializable)x$34 -> (String)((Option)x$34._2()).get())).toSet();
            return (Seq)users.map((Function1 & Serializable)user -> new Tuple2(user, (Object)TenantQueriesImpl.determineOrigin$1(user, tenantUserIds, platformUserIds)));
        }, this.ec());
    }

    @Override
    public Future<Seq<TenantUser>> getTenantUsers(TenantUser user) {
        return this.readAllTenantUsers(user).map((Function1 & Serializable)p -> (Seq)p.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    private Future<Seq<TenantUser>> readAllTenantUsers(TenantUser user) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$35 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$35.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)records -> {
            Seq userRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$4(record)));
            Seq roleRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$5(record)));
            Seq users = (Seq)userRecords.map((Function1 & Serializable)user -> {
                Set roles = ((IterableOnceOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$7(user, role)))).map((Function1 & Serializable)x$36 -> x$36.role_name())).toSet();
                return this.createTenantUser((UserRoleRecord)user, (Set<String>)roles);
            });
            return users;
        }, this.ec());
    }

    private TenantUser createTenantUser(UserRoleRecord user, Set<String> roles) {
        return new TenantUser(user.userId(), user.tenant(), roles, user.isOwner(), user.name(), user.email(), user.enabled());
    }

    @Override
    public Future<Seq<TenantUser>> getDisabledTenantUserAccounts(TenantUser tenantUser) {
        return this.readAllTenantUsers(tenantUser).map((Function1 & Serializable)p -> (Seq)p.filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(TenantUser tenantUser, String userId) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$37 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$37.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantUser.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$38 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$38.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)roleRecords -> {
            UserRoleRecord user = (UserRoleRecord)roleRecords.find((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$14(role))).getOrElse((Function0 & Serializable)() -> {
                throw new UserSearchFailure(userId);
            });
            Set roles = ((IterableOnceOps)((IterableOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)role.enabled()))).filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$17(role)))).map((Function1 & Serializable)x$39 -> x$39.role_name())).toSet();
            return this.createTenantUser(user, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<Seq<ConsentGroup>> getConsentGroups(Seq<String> groupIds) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$40 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$40.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)groupIds, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag))).on((Function2 & Serializable)(x$41, x$42) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$41.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$42.group(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            Set groups = ((IterableOnceOps)((IterableOps)records.map((Function1 & Serializable)x$43 -> (ConsentGroupRecord)x$43._1())).map((Function1 & Serializable)g -> new Tuple2((Object)g.id(), (Object)g.tenant()))).toSet();
            Seq members = (Seq)((IterableOps)records.map((Function1 & Serializable)x$44 -> (ConsentGroupMemberRecord)x$44._2())).filter((Function1 & Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$9(x$45)));
            Seq roles = (Seq)((IterableOps)records.map((Function1 & Serializable)x$46 -> (ConsentGroupMemberRecord)x$46._2())).filterNot((Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$11(x$47)));
            return ((IterableOnceOps)groups.map((Function1 & Serializable)group -> {
                Seq groupUsers = (Seq)members.filter((Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$13(group, x$48)));
                Seq groupMembers = (Seq)groupUsers.map((Function1 & Serializable)member -> {
                    Seq memberRoles = (Seq)((IterableOps)((IterableOps)roles.filter((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$15(group, x$49)))).filter((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$16(member, x$50)))).map((Function1 & Serializable)x$51 -> x$51.role());
                    return new ConsentGroupMember(member.userId(), (Set<String>)memberRoles.toSet(), member.isOwner());
                });
                return new ConsentGroup((String)group._1(), (String)group._2(), (Seq<ConsentGroupMember>)groupMembers);
            })).toSeq();
        }, this.ec());
    }

    @Override
    public Future<ConsentGroup> getConsentGroup(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$52 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$52.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$53 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$53;
            return groupQuery;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        Future queries = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result()).flatMap((Function1 & Serializable)group -> this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$54 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$54.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result()).map((Function1 & Serializable)members -> new Tuple2(group, members), this.ec()), this.ec());
        return queries.map((Function1 & Serializable)result -> {
            if (((SeqOps)result._1()).isEmpty()) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            ConsentGroupRecord group = (ConsentGroupRecord)((IterableOps)result._1()).head();
            String id = group.id();
            String tenant = group.tenant();
            Seq members = (Seq)result._2();
            Seq users = (Seq)members.filter((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$10(x$55)));
            Seq memberList = (Seq)users.map((Function1 & Serializable)user -> {
                Seq userRoles = (Seq)((IterableOps)((IterableOps)members.filter((Function1 & Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$12(user, x$56)))).filterNot((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$13(x$57)))).map((Function1 & Serializable)x$58 -> x$58.role());
                return ConsentGroupMember$.MODULE$.apply(user.userId(), (Seq<String>)userRoles, user.isOwner());
            });
            return new ConsentGroup(id, tenant, (Seq<ConsentGroupMember>)memberList);
        }, this.ec());
    }

    private Query<ConsentGroupTables.ConsentGroupMemberTable, ConsentGroupMemberRecord, Seq> consentGroupMembershipQuery(UserIdentity user, Rep<String> groupId) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$59 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$59.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(groupId, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$60 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$60.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$61 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$61.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
    }

    @Override
    public Future<ConsentGroupMember> getConsentGroupMember(UserIdentity user, String groupId, String userId) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$62 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$62.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)member -> BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            if (!records.exists((Function1 & Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$5(user, x$63)))) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            Seq groupMemberRecords = (Seq)records.filter((Function1 & Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$6(userId, x$64)));
            Seq userRecords = (Seq)groupMemberRecords.filter((Function1 & Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$7(x$65)));
            if (userRecords.isEmpty()) {
                throw new ConsentGroupMemberSearchFailure(userId);
            }
            Seq roles = (Seq)((IterableOps)groupMemberRecords.filterNot((Function1 & Serializable)x$66 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$8(x$66)))).map((Function1 & Serializable)x$67 -> x$67.role());
            return ConsentGroupMember$.MODULE$.apply(((ConsentGroupMemberRecord)userRecords.head()).userId(), (Seq<String>)roles, ((ConsentGroupMemberRecord)userRecords.head()).isOwner());
        }, this.ec());
    }

    @Override
    public Future<ConsentGroupUser> getConsentGroupUser(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$68 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$68.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$69 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$69;
            return groupQuery;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ConsentGroupRecord group = (ConsentGroupRecord)some.value();
                return new ConsentGroupUser(user.id(), group.id(), group.tenant());
            }
            if (None$.MODULE$.equals(option)) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            throw new MatchError((Object)option);
        }, this.ec());
    }

    @Override
    public Future<Map<String, HashMap<String, ListBuffer<String>>>> getTenantGroupsUsage(TenantUser user, String tenant) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$70 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$70.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)tenantGroups -> TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new CaseTables.CaseInstanceTeamGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$71 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$71.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$bang$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$72 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$72.groupId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tenantGroups.id(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)tenantsUsingGroup -> tenantsUsingGroup, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            HashMap groups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            records.foreach((Function1 & Serializable)record -> {
                HashMap group = (HashMap)groups.getOrElseUpdate((Object)record.groupId(), (Function0 & Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
                ListBuffer tenant = (ListBuffer)group.getOrElseUpdate((Object)record.tenant(), (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                return (ListBuffer)tenant.$plus$eq((Object)record.caseInstanceId());
            });
            return groups.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }, this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$5(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$8(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$9(String userId$1, UserRoleRecord x$9) {
        String string = x$9.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$10(String userId$1, ConsentGroupMemberRecord x$10) {
        String string = x$10.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$13(String tenant$2, UserRoleRecord x$12) {
        String string = x$12.tenant();
        String string2 = tenant$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$14(UserRoleRecord x$13) {
        return x$13.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$16(UserRoleRecord x$15) {
        return x$15.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$19(ConsentGroupMemberRecord x$18) {
        return x$18.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUser$22(String groupId$1, ConsentGroupMemberRecord x$20) {
        String string = x$20.group();
        String string2 = groupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$12(Tuple2 x$31) {
        return ((Option)x$31._1()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$14(Tuple2 x$33) {
        return ((Option)x$33._2()).isDefined();
    }

    private static final Origin determineOrigin$1(String userId, Set tenantUserIds$1, Set platformUserIds$1) {
        if (tenantUserIds$1.contains((Object)userId)) {
            return Origin.Tenant;
        }
        if (platformUserIds$1.contains((Object)userId)) {
            return Origin.Platform;
        }
        return Origin.IDP;
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$4(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$5(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$7(UserRoleRecord user$3, UserRoleRecord role) {
        String string = role.userId();
        String string2 = user$3.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$14(UserRoleRecord role) {
        return role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$17(UserRoleRecord role) {
        return !role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$9(ConsentGroupMemberRecord x$45) {
        return x$45.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$11(ConsentGroupMemberRecord x$47) {
        return x$47.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$13(Tuple2 group$1, ConsentGroupMemberRecord x$48) {
        String string = x$48.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$15(Tuple2 group$1, ConsentGroupMemberRecord x$49) {
        String string = x$49.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$16(ConsentGroupMemberRecord member$1, ConsentGroupMemberRecord x$50) {
        String string = x$50.userId();
        String string2 = member$1.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$10(ConsentGroupMemberRecord x$55) {
        return x$55.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$12(ConsentGroupMemberRecord user$5, ConsentGroupMemberRecord x$56) {
        String string = x$56.userId();
        String string2 = user$5.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$13(ConsentGroupMemberRecord x$57) {
        return x$57.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$5(UserIdentity user$7, ConsentGroupMemberRecord x$63) {
        String string = x$63.userId();
        String string2 = user$7.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$6(String userId$3, ConsentGroupMemberRecord x$64) {
        String string = x$64.userId();
        String string2 = userId$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$7(ConsentGroupMemberRecord x$65) {
        return x$65.role().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$8(ConsentGroupMemberRecord x$66) {
        return x$66.role().isEmpty();
    }

    public TenantQueriesImpl() {
        UserQueries.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        CafienneJDBCConfig.$init$(this);
        QueryDBSchema.$init$(this);
        TenantTables.$init$(this);
        ConsentGroupTables.$init$(this);
        CaseTables.$init$(this);
        this.ec = this.db().ioExecutionContext();
        this.rolesQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag));
    }
}

