/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage;

import akka.Done;
import akka.Done$;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorContextProvider;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.annotation.InternalApi;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.EventEnvelope$;
import akka.persistence.query.Offset$;
import akka.persistence.query.scaladsl.CurrentEventsByTagQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.StorageActorSupervisor;
import org.cafienne.storage.actormodel.event.StorageRequestReceived;
import org.cafienne.storage.actormodel.message.StorageActionCompleted;
import org.cafienne.storage.actormodel.message.StorageActionStarted;
import org.cafienne.storage.actormodel.message.StorageCommand;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.actormodel.message.StorageEvent$;
import org.cafienne.storage.archival.command.ArchiveActorData$;
import org.cafienne.storage.archival.event.ArchivalStarted;
import org.cafienne.storage.deletion.command.RemoveActorData$;
import org.cafienne.storage.deletion.event.RemovalStarted;
import org.cafienne.storage.restore.command.RestoreActorData$;
import org.cafienne.storage.restore.event.RestoreStarted;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0007\u000f\u0001UA\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!)Q\t\u0001C\u0001\r\"9\u0011\t\u0001b\u0001\n\u0003R\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I1\u0001)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u0015A\u0006\u0001\"\u0003Z\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\t\u00112\u000b^8sC\u001e,7i\\8sI&t\u0017\r^8s\u0015\ty\u0001#A\u0004ti>\u0014\u0018mZ3\u000b\u0005E\u0011\u0012\u0001C2bM&,gN\\3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\f\u001dI)\u0012\u0004CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)\u0011m\u0019;pe*\t\u0011%\u0001\u0003bW.\f\u0017BA\u0012\u001f\u0005\u0015\t5\r^8s!\t)\u0003&D\u0001'\u0015\t9c\"\u0001\u0006bGR|'/\\8eK2L!!\u000b\u0014\u0003-M#xN]1hK\u0006\u001bGo\u001c:TkB,'O^5t_J\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t\r\f(o\u001d\u0006\u0003_A\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u00022Y\t\u0019\"+Z1e\u0015>,(O\\1m!J|g/\u001b3feB\u00111GO\u0007\u0002i)\u0011QGN\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003oa\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002s\u0005\u00191m\\7\n\u0005m\"$a\u0003'bufdunZ4j]\u001e\f!bY1tKNK8\u000f^3n+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\u0011\u0003\u0019\u0019\u0018p\u001d;f[&\u00111\t\u0011\u0002\u000b\u0007\u0006\u001cXmU=ti\u0016l\u0017aC2bg\u0016\u001c\u0016p\u001d;f[\u0002\na\u0001P5oSRtDCA$J!\tA\u0005!D\u0001\u000f\u0011\u0015a4\u00011\u0001?+\u0005Y\u0005CA\u000fM\u0013\tieDA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0003K\u000e,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)b\t!bY8oGV\u0014(/\u001a8u\u0013\t16K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\u0011\u001d,G/Q2u_J$\"AW/\u0011\u0005uY\u0016B\u0001/\u001f\u0005!\t5\r^8s%\u00164\u0007\"\u00020\t\u0001\u0004y\u0016aB2p[6\fg\u000e\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u001a\nq!\\3tg\u0006<W-\u0003\u0002eC\nq1\u000b^8sC\u001e,7i\\7nC:$\u0017!B:uCJ$H#A4\u0011\u0005]A\u0017BA5\u0019\u0005\u0011)f.\u001b;\u0002\u0013I,hn\u0015;sK\u0006lG#\u00017\u0011\u0007Ikw.\u0003\u0002o'\n1a)\u001e;ve\u0016\u0004\"\u0001]9\u000e\u0003\u0001J!A\u001d\u0011\u0003\t\u0011{g.Z\u0001\u0012G>t7/^7f\u001b>$W\r\\#wK:$HC\u00017v\u0011\u001518\u00021\u0001x\u0003!)gN^3m_B,\u0007C\u0001=~\u001b\u0005I(B\u0001>|\u0003\u0015\tX/\u001a:z\u0015\ta\b%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001@z\u00055)e/\u001a8u\u000b:4X\r\\8qK\u00069!/Z2fSZ,WCAA\u0002!\u0011\t)!a\u0002\u000e\u0003\u0001I1!!\u0003#\u0005\u001d\u0011VmY3jm\u0016\u0004")
public class StorageCoordinator
implements StorageActorSupervisor,
ReadJournalProvider {
    private final CaseSystem caseSystem;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private String configuredJournal;
    private String readJournalSetting;
    private Map<String, ActorRef> childActors;
    private transient Logger logger;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public ActorSystem actorSystem() {
        return ReadJournalProvider.actorSystem$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    @Override
    public ActorRef getActorRef(ActorMetadata metadata, Props props) {
        return StorageActorSupervisor.getActorRef$((StorageActorSupervisor)this, metadata, props);
    }

    @Override
    public ActorRef getActorRef(String actorId, Props props) {
        return StorageActorSupervisor.getActorRef$((StorageActorSupervisor)this, actorId, props);
    }

    @Override
    public void removeActorRef(Terminated message) {
        StorageActorSupervisor.removeActorRef$(this, message);
    }

    @Override
    public void terminateModelActor(ActorMetadata metadata, Function0<BoxedUnit> followUpAction) {
        StorageActorSupervisor.terminateModelActor$(this, metadata, followUpAction);
    }

    @Override
    public void terminateModelActor$default$2() {
        StorageActorSupervisor.terminateModelActor$default$2$(this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    private String configuredJournal$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.configuredJournal$lzycompute();
        }
        return this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.readJournalSetting$lzycompute();
        }
        return this.readJournalSetting;
    }

    @Override
    public Map<String, ActorRef> childActors() {
        return this.childActors;
    }

    @Override
    public void org$cafienne$storage$actormodel$StorageActorSupervisor$_setter_$childActors_$eq(Map<String, ActorRef> x$1) {
        this.childActors = x$1;
    }

    private Logger logger$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ActorRef org$cafienne$storage$StorageCoordinator$$getActor(StorageCommand command) {
        return this.getActorRef("root_" + command.metadata().actorId(), Props$.MODULE$.apply(command.RootStorageActorClass(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.caseSystem(), command.metadata()})));
    }

    public void start() {
        this.runStream().onComplete((Function1 & Serializable)x0$1 -> {
            StorageCoordinator.$anonfun$start$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Future<Done> runStream() {
        Materializer mat = Materializer$.MODULE$.apply((ClassicActorContextProvider)this.context());
        return (Future)((Source)((CurrentEventsByTagQuery)this.journal()).currentEventsByTag(StorageEvent$.MODULE$.TAG(), Offset$.MODULE$.noOffset()).mapAsync(1, (Function1 & Serializable)envelope -> this.consumeModelEvent((EventEnvelope)envelope))).runWith((Graph)Sink$.MODULE$.ignore(), mat);
    }

    public Future<Done> consumeModelEvent(EventEnvelope envelope) {
        block1: {
            EventEnvelope eventEnvelope;
            block5: {
                Option option;
                block0: {
                    StorageActionStarted storageActionStarted;
                    block4: {
                        StorageActionStarted storageActionStarted2;
                        block3: {
                            block2: {
                                Object event;
                                Option option2;
                                eventEnvelope = envelope;
                                if (eventEnvelope == null || (option2 = EventEnvelope$.MODULE$.unapply(eventEnvelope)).isEmpty() || !((event = ((Tuple4)option2.get())._4()) instanceof StorageActionStarted)) break block0;
                                storageActionStarted2 = (StorageActionStarted)event;
                                if (!storageActionStarted2.metadata().isRoot()) break block1;
                                storageActionStarted = storageActionStarted2;
                                if (!(storageActionStarted instanceof RemovalStarted)) break block2;
                                this.restart$1((Function1)RemoveActorData$.MODULE$, storageActionStarted2);
                                break block1;
                            }
                            if (!(storageActionStarted instanceof ArchivalStarted)) break block3;
                            this.restart$1((Function1)ArchiveActorData$.MODULE$, storageActionStarted2);
                            break block1;
                        }
                        if (!(storageActionStarted instanceof RestoreStarted)) break block4;
                        this.restart$1((Function1)RestoreActorData$.MODULE$, storageActionStarted2);
                        break block1;
                    }
                    if (!this.logger().underlying().isWarnEnabled()) break block1;
                    this.logger().underlying().warn("Cannot recover a storage process, because of unrecognized initiation event of type {}", (Object)storageActionStarted.getClass().getName());
                    break block1;
                }
                if (eventEnvelope == null || (option = EventEnvelope$.MODULE$.unapply(eventEnvelope)).isEmpty() || !(((Tuple4)option.get())._4() instanceof StorageEvent)) break block5;
                break block1;
            }
            if (!this.logger().underlying().isErrorEnabled()) break block1;
            this.logger().underlying().error("Encountered unexpected storage tag matching event of type {}", (Object)eventEnvelope.getClass().getName());
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageCoordinator $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StorageCommand) {
                    BoxedUnit boxedUnit;
                    StorageCommand storageCommand = (StorageCommand)A1;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Received {}", (Object)storageCommand);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    ActorRef originalSender = this.$outer.sender();
                    this.$outer.terminateModelActor(storageCommand.metadata(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if ($this.$outer.logger().underlying().isDebugEnabled()) {
                            if ($this.$outer.logger().underlying().isDebugEnabled()) {
                                $this.$outer.logger().underlying().debug("Actor {} terminated, triggering follow up: {}", new Object[]{storageCommand.metadata().actorId(), storageCommand});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        $this.$outer.org$cafienne$storage$StorageCoordinator$$getActor(storageCommand).tell((Object)storageCommand, originalSender);
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof StorageRequestReceived) {
                    StorageRequestReceived storageRequestReceived = (StorageRequestReceived)A1;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Started storage request on {}", (Object)storageRequestReceived.metadata());
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof StorageActionCompleted) {
                    StorageActionCompleted storageActionCompleted = (StorageActionCompleted)A1;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Completed storage action for {}", (Object)storageActionCompleted.metadata());
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof Terminated) {
                    Terminated terminated = (Terminated)A1;
                    this.$outer.removeActorRef(terminated);
                    return (B1)BoxedUnit.UNIT;
                }
                if (this.$outer.logger().underlying().isWarnEnabled()) {
                    this.$outer.logger().underlying().warn("StorageCoordinator received an unknown message of type {}", (Object)A1.getClass().getName());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof StorageCommand) {
                    return true;
                }
                if (object instanceof StorageRequestReceived) {
                    return true;
                }
                if (object instanceof StorageActionCompleted) {
                    return true;
                }
                if (object instanceof Terminated) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.cafienne.storage.StorageCoordinator$$anonfun$receive$1 org.cafienne.storage.actormodel.message.StorageCommand akka.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$start$1(StorageCoordinator $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Completed re-activating Storage Deletion Actors");
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error($this.getClass().getSimpleName() + " bumped into an issue that it cannot recover from.", ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HealthMonitor$.MODULE$.storageService().hasFailed(ex);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final void restart$1(Function1 commandMaker, StorageActionStarted x6$1) {
        BoxedUnit boxedUnit;
        StorageCommand command = (StorageCommand)commandMaker.apply((Object)x6$1.metadata());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Recovering storage process '{}' on actor {}", new Object[]{command.getClass().getSimpleName(), x6$1.metadata()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.org$cafienne$storage$StorageCoordinator$$getActor(command).tell((Object)command, this.self());
    }

    public StorageCoordinator(CaseSystem caseSystem) {
        BoxedUnit boxedUnit;
        this.caseSystem = caseSystem;
        Actor.$init$((Actor)this);
        LazyLogging.$init$((LazyLogging)this);
        StorageActorSupervisor.$init$(this);
        ReadJournalProvider.$init$(this);
        this.system = caseSystem.system();
        this.ec = caseSystem.system().dispatcher();
        if (Cafienne$.MODULE$.config().engine().storage().recoveryDisabled()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("WARNING: Storage Coordination Service does not recover any existing unfinished storage processes; set 'engine.storage-service.auto-start = true' to enable recovery ");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Launching Storage Coordination Service");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.start();
            boxedUnit = BoxedUnit.UNIT;
        }
        Statics.releaseFence();
    }
}

