/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage.archival.state;

import akka.Done;
import akka.actor.ActorRef;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.event.ChildrenReceived;
import org.cafienne.storage.actormodel.event.QueryDataCleared;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.actormodel.state.QueryDBState;
import org.cafienne.storage.archival.ActorDataArchiver;
import org.cafienne.storage.archival.Archive;
import org.cafienne.storage.archival.ModelEventSerializer$;
import org.cafienne.storage.archival.event.ArchivalStarted;
import org.cafienne.storage.archival.event.ArchivalStarted$;
import org.cafienne.storage.archival.event.ArchiveCreated;
import org.cafienne.storage.archival.event.ArchiveCreated$;
import org.cafienne.storage.archival.event.ArchiveReceived;
import org.cafienne.storage.archival.event.QueryDataArchived;
import org.cafienne.storage.archival.event.QueryDataArchived$;
import org.cafienne.storage.archival.event.cmmn.ModelActorArchived;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Y3q!\u0004\b\u0011\u0002\u0007\u0005\u0011\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004-\u0001\t\u0007i\u0011I\u0017\t\u000bI\u0002A\u0011I\u001a\t\u000bq\u0002A\u0011A\u001f\t\u000b\u0005\u0003A\u0011A\u001f\t\u000b\t\u0003A\u0011A\u001f\t\u000b\r\u0003A\u0011\t\u0015\t\u000b\u0011\u0003A\u0011\t\u0015\t\u000b\u0015\u0003A\u0011\u0001\u0015\t\u000b\u0019\u0003A\u0011A$\t\u000b5\u0003A\u0011A$\t\u000b9\u0003a\u0011A(\u0003\u001b\u0005\u00138\r[5wC2\u001cF/\u0019;f\u0015\ty\u0001#A\u0003ti\u0006$XM\u0003\u0002\u0012%\u0005A\u0011M]2iSZ\fGN\u0003\u0002\u0014)\u000591\u000f^8sC\u001e,'BA\u000b\u0017\u0003!\u0019\u0017MZ5f]:,'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0015j\u0011A\t\u0006\u0003\u001f\rR!\u0001\n\n\u0002\u0015\u0005\u001cGo\u001c:n_\u0012,G.\u0003\u0002'E\ta\u0011+^3ss\u0012\u00135\u000b^1uK\u00061A%\u001b8ji\u0012\"\u0012!\u000b\t\u00037)J!a\u000b\u000f\u0003\tUs\u0017\u000e^\u0001\u0006C\u000e$xN]\u000b\u0002]A\u0011q\u0006M\u0007\u0002!%\u0011\u0011\u0007\u0005\u0002\u0012\u0003\u000e$xN\u001d#bi\u0006\f%o\u00195jm\u0016\u0014\u0018A\u00055b]\u0012dWm\u0015;pe\u0006<W-\u0012<f]R$\"!\u000b\u001b\t\u000bU\u001a\u0001\u0019\u0001\u001c\u0002\u000b\u00154XM\u001c;\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u001a\u0013aB7fgN\fw-Z\u0005\u0003wa\u0012Ab\u0015;pe\u0006<W-\u0012<f]R\f\u0011\"[:De\u0016\fG/\u001a3\u0016\u0003y\u0002\"aG \n\u0005\u0001c\"a\u0002\"p_2,\u0017M\\\u0001\u0016a\u0006\u0014XM\u001c;SK\u000e,\u0017N^3e\u0003J\u001c\u0007.\u001b<f\u0003%I7o\u00117fCJ,G-A\nti\u0006\u0014Ho\u0015;pe\u0006<W\r\u0015:pG\u0016\u001c8/\u0001\fd_:$\u0018N\\;f'R|'/Y4f!J|7-Z:t\u0003I\u0019\u0007.Z2l\u0003J\u001c\u0007.\u001b<j]\u001e$uN\\3\u0002%\r\u0014X-\u0019;f\u0003J\u001c\u0007.\u001b<f\u000bZ,g\u000e^\u000b\u0002\u0011B\u0011\u0011jS\u0007\u0002\u0015*\u0011Q\u0007E\u0005\u0003\u0019*\u0013a\"\u0011:dQ&4Xm\u0011:fCR,G-A\u0004be\u000eD\u0017N^3\u00029\r\u0014X-\u0019;f\u001b>$W\r\\!di>\u00148\u000b^8sC\u001e,WI^3oiV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002T\u0015\u0006!1-\\7o\u0013\t)&K\u0001\nN_\u0012,G.Q2u_J\f%o\u00195jm\u0016$\u0007")
public interface ArchivalState
extends QueryDBState {
    @Override
    public ActorDataArchiver actor();

    public static /* synthetic */ void handleStorageEvent$(ArchivalState $this, StorageEvent event) {
        $this.handleStorageEvent(event);
    }

    @Override
    default public void handleStorageEvent(StorageEvent event) {
        StorageEvent storageEvent = event;
        if (storageEvent instanceof ArchivalStarted) {
            ArchivalStarted archivalStarted = (ArchivalStarted)storageEvent;
            this.printLogMessage("Starting archival for " + archivalStarted.metadata());
            this.continueStorageProcess();
            return;
        }
        if (storageEvent instanceof ChildrenReceived) {
            this.printLogMessage("Stored children information");
            this.continueStorageProcess();
            return;
        }
        if (storageEvent instanceof QueryDataCleared) {
            this.printLogMessage("QueryDB has been archived");
            this.continueStorageProcess();
            return;
        }
        if (storageEvent instanceof ArchiveCreated) {
            ArchiveCreated archiveCreated = (ArchiveCreated)storageEvent;
            this.actor().afterArchiveCreated(archiveCreated);
            return;
        }
        if (storageEvent instanceof ArchiveReceived) {
            this.actor().afterArchiveExported();
            return;
        }
        if (storageEvent instanceof ModelActorArchived) {
            this.actor().completeStorageProcess();
            return;
        }
        this.reportUnknownEvent(event);
    }

    public static /* synthetic */ boolean isCreated$(ArchivalState $this) {
        return $this.isCreated();
    }

    default public boolean isCreated() {
        return this.events().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isCreated$1(x$1)));
    }

    public static /* synthetic */ boolean parentReceivedArchive$(ArchivalState $this) {
        return $this.parentReceivedArchive();
    }

    default public boolean parentReceivedArchive() {
        return this.events().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$parentReceivedArchive$1(x$2)));
    }

    public static /* synthetic */ boolean isCleared$(ArchivalState $this) {
        return $this.isCleared();
    }

    default public boolean isCleared() {
        return this.events().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isCleared$1(x$3)));
    }

    public static /* synthetic */ void startStorageProcess$(ArchivalState $this) {
        $this.startStorageProcess();
    }

    @Override
    default public void startStorageProcess() {
        this.findCascadingChildren().map((Function1 & Serializable)children -> {
            ArchivalState.$anonfun$startStorageProcess$1(this, children);
            return BoxedUnit.UNIT;
        }, this.dispatcher());
    }

    public static /* synthetic */ void continueStorageProcess$(ArchivalState $this) {
        $this.continueStorageProcess();
    }

    @Override
    default public void continueStorageProcess() {
        BoxedUnit boxedUnit;
        if (!this.parentReceivedChildrenInformation()) {
            this.printLogMessage("Initiating storage process");
            this.startStorageProcess();
            boxedUnit = BoxedUnit.UNIT;
        } else if (!this.queryDataCleared()) {
            this.printLogMessage("Archiving query data");
            boxedUnit = this.clearQueryData().map((Function1 & Serializable)x$4 -> {
                ArchivalState.$anonfun$continueStorageProcess$1(this, x$4);
                return BoxedUnit.UNIT;
            }, this.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkArchivingDone();
    }

    public static /* synthetic */ void checkArchivingDone$(ArchivalState $this) {
        $this.checkArchivingDone();
    }

    default public void checkArchivingDone() {
        this.printLogMessage("Running completion check: [queryDataCleared=" + this.queryDataCleared() + ";]");
        if (this.queryDataCleared()) {
            if (!this.isCreated()) {
                this.actor().createArchive();
                return;
            }
            return;
        }
    }

    public static /* synthetic */ ArchiveCreated createArchiveEvent$(ArchivalState $this) {
        return $this.createArchiveEvent();
    }

    default public ArchiveCreated createArchiveEvent() {
        this.printLogMessage("Starting final step to delete ourselves from event journal");
        ValueList list = new ValueList(new Object[0]);
        ((IterableOnceOps)((IterableOps)this.originalModelActorEvents().zipWithIndex()).map((Function1 & Serializable)element -> ArchivalState.serializeEventToJson$1(element))).foreach((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)list.add(e)));
        Archive archive = new Archive(this.metadata(), list, (Seq<Archive>)((Seq)Nil$.MODULE$));
        return new ArchiveCreated(this.metadata(), archive, ArchiveCreated$.MODULE$.apply$default$3());
    }

    public static /* synthetic */ ArchiveCreated archive$(ArchivalState $this) {
        return $this.archive();
    }

    default public ArchiveCreated archive() {
        return (ArchiveCreated)this.events().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$archive$1(x$5))).get();
    }

    public ModelActorArchived createModelActorStorageEvent();

    public static /* synthetic */ boolean $anonfun$isCreated$1(ModelEvent x$1) {
        return x$1 instanceof ArchiveCreated;
    }

    public static /* synthetic */ boolean $anonfun$parentReceivedArchive$1(ModelEvent x$2) {
        return x$2 instanceof ArchiveReceived;
    }

    public static /* synthetic */ boolean $anonfun$isCleared$1(ModelEvent x$3) {
        return x$3 instanceof ModelActorArchived;
    }

    public static /* synthetic */ void $anonfun$startStorageProcess$1(ArchivalState $this, Seq children) {
        $this.printLogMessage("Found " + children.length() + " children: " + children.mkString("\n--- ", "\n--- ", ""));
        $this.informOwner(new ArchivalStarted($this.metadata(), (Seq<ActorMetadata>)children, ArchivalStarted$.MODULE$.apply$default$3()));
    }

    public static /* synthetic */ void $anonfun$continueStorageProcess$1(ArchivalState $this, Done x$4) {
        QueryDataArchived x$1 = new QueryDataArchived($this.metadata(), QueryDataArchived$.MODULE$.apply$default$2());
        ActorRef x$2 = $this.actor().self().$bang$default$2((Object)x$1);
        $this.actor().self().$bang((Object)x$1, x$2);
    }

    private static ValueMap serializeEventToJson$1(Tuple2 element) {
        return ModelEventSerializer$.MODULE$.serializeEventToJson((ModelEvent)element._1(), element._2$mcI$sp() + 1);
    }

    public static /* synthetic */ boolean $anonfun$archive$1(ModelEvent x$5) {
        return x$5 instanceof ArchiveCreated;
    }

    public static void $init$(ArchivalState $this) {
    }
}

