/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.system.health;

import java.io.Serializable;
import java.util.LinkedHashSet;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.system.health.HealthMeasurePoint;
import scala.Function1;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class HealthMonitor$ {
    public static final HealthMonitor$ MODULE$ = new HealthMonitor$();
    private static final Set<HealthMeasurePoint> measures = CollectionConverters$.MODULE$.SetHasAsScala(new LinkedHashSet()).asScala();
    private static final HealthMeasurePoint queryDB = MODULE$.addMeasure("query-db", MODULE$.addMeasure$default$2());
    private static final HealthMeasurePoint idp = MODULE$.addMeasure("idp", MODULE$.addMeasure$default$2());
    private static final HealthMeasurePoint writeJournal = MODULE$.addMeasure("write-journal", false);
    private static final HealthMeasurePoint readJournal = MODULE$.addMeasure("read-journal", MODULE$.addMeasure$default$2());
    private static final HealthMeasurePoint timerService = MODULE$.addMeasure("timer-service", false);
    private static final HealthMeasurePoint storageService = MODULE$.addMeasure("storage-service", false);

    private Set<HealthMeasurePoint> measures() {
        return measures;
    }

    public HealthMeasurePoint queryDB() {
        return queryDB;
    }

    public HealthMeasurePoint idp() {
        return idp;
    }

    public HealthMeasurePoint writeJournal() {
        return writeJournal;
    }

    public HealthMeasurePoint readJournal() {
        return readJournal;
    }

    public HealthMeasurePoint timerService() {
        return timerService;
    }

    public HealthMeasurePoint storageService() {
        return storageService;
    }

    private String description() {
        return "Health indication of the Case Engine is currently " + this.health();
    }

    private String health() {
        if (this.ok()) {
            return "OK";
        }
        return "NOK";
    }

    public boolean ok() {
        return this.measures().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HealthMonitor$.$anonfun$ok$1(p))).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HealthMonitor$.$anonfun$ok$2(x$1)));
    }

    public ValueMap report() {
        ValueMap json = new ValueMap("Status", this.health(), "Description", this.description());
        ValueList points = json.withArray("measure-points");
        this.measures().foreach((Function1 & Serializable)measure -> BoxesRunTime.boxToBoolean((boolean)points.add(new ValueMap(measure.key(), measure.asJSON()))));
        return json;
    }

    public HealthMeasurePoint addMeasure(String key, boolean isCritical) {
        HealthMeasurePoint measure = new HealthMeasurePoint(key, isCritical);
        this.measures().$plus$eq((Object)measure);
        return measure;
    }

    public boolean addMeasure$default$2() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$ok$1(HealthMeasurePoint p) {
        return p.isCritical() && p.unhealthy();
    }

    public static final /* synthetic */ boolean $anonfun$ok$2(HealthMeasurePoint x$1) {
        return false;
    }

    private HealthMonitor$() {
    }
}

