/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.Offset;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerCleared;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.ModelEventFilter;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.infrastructure.cqrs.TaggedEventSource;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.health.HealthMonitor$;
import org.cafienne.timerservice.TimerService;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005E4A!\u0004\b\u0001+!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u001dy\u0003A1A\u0005\u0002ABaa\u000e\u0001!\u0002\u0013\t\u0004b\u0002\u001b\u0001\u0005\u0004%\t\u0005\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\t\u000b\t\u0003A\u0011I\"\t\u000fI\u0003!\u0019!C!'\"1q\f\u0001Q\u0001\nQCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u001c\u0001\u0005\u00025\u0014a\u0002V5nKJ,e/\u001a8u'&t7N\u0003\u0002\u0010!\u0005aA/[7feN,'O^5dK*\u0011\u0011CE\u0001\tG\u00064\u0017.\u001a8oK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011\u0019\u0017O]:\u000b\u0005\u0005\u0002\u0012AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u0003Gy\u0011\u0011\u0003V1hO\u0016$WI^3oiN{WO]2f\u00031!\u0018.\\3s'\u0016\u0014h/[2f+\u00051\u0003CA\u0014)\u001b\u0005q\u0011BA\u0015\u000f\u00051!\u0016.\\3s'\u0016\u0014h/[2f\u00035!\u0018.\\3s'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\"!\f\u0018\u0011\u0005\u001d\u0002\u0001\"\u0002\u0013\u0004\u0001\u00041\u0013AC2bg\u0016\u001c\u0016p\u001d;f[V\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025!\u000511/_:uK6L!AN\u001a\u0003\u0015\r\u000b7/Z*zgR,W.A\u0006dCN,7+_:uK6\u0004S#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!B1di>\u0014(\"\u0001 \u0002\t\u0005\\7.Y\u0005\u0003\u0001n\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013!C4fi>3gm]3u+\u0005!\u0005cA#I\u00156\taI\u0003\u0002H1\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%3%A\u0002$viV\u0014X\r\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006)\u0011/^3ss*\u0011q*P\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002R\u0019\n1qJ\u001a4tKR\f1\u0001^1h+\u0005!\u0006CA+]\u001d\t1&\f\u0005\u0002X15\t\u0001L\u0003\u0002Z)\u00051AH]8pizJ!a\u0017\r\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037b\tA\u0001^1hA\u0005\t2m\u001c8tk6,Wj\u001c3fY\u00163XM\u001c;\u0015\u0005\t<\u0007cA#IGB\u0011A-Z\u0007\u0002{%\u0011a-\u0010\u0002\u0005\t>tW\rC\u0003i\u0017\u0001\u0007\u0011.\u0001\u0005f]Z,Gn\u001c9f!\ti\".\u0003\u0002l=\t\u0011Rj\u001c3fY\u00163XM\u001c;F]Z,Gn\u001c9f\u0003\u0015\u0019H/\u0019:u)\u0005q\u0007CA\fp\u0013\t\u0001\bD\u0001\u0003V]&$\b")
public class TimerEventSink
implements TaggedEventSource {
    private final TimerService timerService;
    private final CaseSystem caseSystem;
    private final ActorSystem system;
    private final String tag;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Source<EventEnvelope, NotUsed> query(Offset offset) {
        return TaggedEventSource.query$(this, offset);
    }

    @Override
    public Source<ModelEventEnvelope, NotUsed> taggedEvents() {
        return TaggedEventSource.taggedEvents$(this);
    }

    @Override
    public Source<EventEnvelope, NotUsed> restartableTaggedEventSourceFromLastKnownOffset() {
        return TaggedEventSource.restartableTaggedEventSourceFromLastKnownOffset$(this);
    }

    @Override
    public EventEnvelope reportHealth(EventEnvelope envelope) {
        return TaggedEventSource.reportHealth$(this, envelope);
    }

    @Override
    public boolean validateModelEvents(EventEnvelope element) {
        return ModelEventFilter.validateModelEvents$(this, element);
    }

    @Override
    public ActorSystem actorSystem() {
        return ReadJournalProvider.actorSystem$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    private String configuredJournal$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.configuredJournal$lzycompute();
        }
        return this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.readJournalSetting$lzycompute();
        }
        return this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Future<Offset> getOffset() {
        return this.timerService().storage.getOffset();
    }

    @Override
    public String tag() {
        return this.tag;
    }

    public Future<Done> consumeModelEvent(ModelEventEnvelope envelope) {
        BoxedUnit boxedUnit;
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof TimerSet) {
            BoxedUnit boxedUnit2;
            TimerSet timerSet = (TimerSet)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {} (triggering at {})", new Object[]{timerSet.getClass().getSimpleName(), timerSet.getTimerId(), timerSet.getActorId(), timerSet.getTargetMoment()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return this.timerService().monitor.addTimer(timerSet, envelope.offset());
        }
        if (modelEvent instanceof TimerCleared) {
            BoxedUnit boxedUnit3;
            TimerCleared timerCleared = (TimerCleared)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {}", new Object[]{timerCleared.getClass().getSimpleName(), timerCleared.getTimerId(), timerCleared.getActorId()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return this.timerService().monitor.removeTimer(timerCleared.getTimerId(), (Option<Offset>)new Some((Object)envelope.offset()));
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Timer Service received an unexpected event of type {}", (Object)modelEvent.getClass().getName());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public void start() {
        ((Future)((Source)this.taggedEvents().mapAsync(1, (Function1 & Serializable)envelope -> this.consumeModelEvent((ModelEventEnvelope)envelope))).runWith((Graph)Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.actorSystem()))).onComplete((Function1 & Serializable)x0$1 -> {
            TimerEventSink.$anonfun$start$2(this, x0$1);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static final /* synthetic */ void $anonfun$start$2(TimerEventSink $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("{} bumped into an issue that it cannot recover from: {}", new Object[]{$this.getClass().getSimpleName(), ex.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HealthMonitor$.MODULE$.readJournal().hasFailed(ex);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public TimerEventSink(TimerService timerService) {
        this.timerService = timerService;
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        ModelEventFilter.$init$(this);
        TaggedEventSource.$init$(this);
        this.caseSystem = timerService.caseSystem;
        this.system = this.caseSystem().system();
        this.tag = "cafienne:timer";
    }
}

