/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.Done;
import akka.Done$;
import akka.actor.Scheduler;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.system.health.HealthMonitor$;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.TimerJob;
import org.cafienne.timerservice.TimerService;
import org.cafienne.timerservice.TimerStorageReader;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\t\u0013\u0001eA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005Y!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00131\u0004BB'\u0001A\u0003%q\u0007C\u0004O\u0001\t\u0007I1A(\t\rY\u0003\u0001\u0015!\u0003Q\u0011\u001d9\u0006A1A\u0005\u0002aCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%\ta\u0019\u0005\u0007O\u0002\u0001\u000b\u0011\u00023\t\u000b!\u0004A\u0011A5\t\u000b5\u0004A\u0011\u00018\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u001f\u0001\u0011\u0005\u0011q\b\u0002\r)&lWM]'p]&$xN\u001d\u0006\u0003'Q\tA\u0002^5nKJ\u001cXM\u001d<jG\u0016T!!\u0006\f\u0002\u0011\r\fg-[3o]\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"Q5\t!E\u0003\u0002$I\u0005a1oY1mC2|wmZ5oO*\u0011QEJ\u0001\tif\u0004Xm]1gK*\tq%A\u0002d_6L!!\u000b\u0012\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\ri&lWM]*feZL7-Z\u000b\u0002YA\u0011QFL\u0007\u0002%%\u0011qF\u0005\u0002\r)&lWM]*feZL7-Z\u0001\u000ei&lWM]*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0019D\u0007\u0005\u0002.\u0001!)!f\u0001a\u0001Y\u0005a\u0011m\u0019;jm\u0016$\u0016.\\3sgV\tq\u0007\u0005\u00039{}RU\"A\u001d\u000b\u0005iZ\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003yq\t!bY8mY\u0016\u001cG/[8o\u0013\tq\u0014HA\u0002NCB\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"\u001d\u001b\u0005\u0019%B\u0001#\u0019\u0003\u0019a$o\\8u}%\u0011a\tH\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G9A\u0011QfS\u0005\u0003\u0019J\u0011\u0001\u0002V5nKJTuNY\u0001\u000eC\u000e$\u0018N^3US6,'o\u001d\u0011\u0002\u0015\u0011L7\u000f]1uG\",'/F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F$\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018a\u00033jgB\fGo\u00195fe\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003y\u000bA!Y6lC&\u0011\u0001m\u0017\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0019\u0011X-\u00193feV\tA\r\u0005\u0002.K&\u0011aM\u0005\u0002\u0013)&lWM]*u_J\fw-\u001a*fC\u0012,'/A\u0004sK\u0006$WM\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003)\u0004\"aG6\n\u00051d\"\u0001B+oSR\f1B]3n_Z,G+[7feR\u0019qN\u001e=\u0011\u0007E\u0003(/\u0003\u0002r%\n1a)\u001e;ve\u0016\u0004\"a\u001d;\u000e\u0003uK!!^/\u0003\t\u0011{g.\u001a\u0005\u0006o6\u0001\raP\u0001\bi&lWM]%e\u0011\u0015IX\u00021\u0001{\u0003\u0019ygMZ:fiB\u00191d_?\n\u0005qd\"AB(qi&|g\u000eE\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0003rk\u0016\u0014\u0018PC\u0002\u0002\u0006u\u000b1\u0002]3sg&\u001cH/\u001a8dK&\u0019\u0011\u0011B@\u0003\r=3gm]3u\u0003)\u0011XO\\*u_J\fw-\u001a\u000b\u0004_\u0006=\u0001\u0002CA\t\u001d\u0011\u0005\r!a\u0005\u0002\u0011\u0019,hn\u0019;j_:\u0004BaGA\u000b_&\u0019\u0011q\u0003\u000f\u0003\u0011q\u0012\u0017P\\1nKz\n\u0001\"\u00193e)&lWM\u001d\u000b\u0006_\u0006u\u00111\b\u0005\b\u0003?y\u0001\u0019AA\u0011\u0003\u0015)g/\u001a8u!\u0011\t\u0019#a\u000e\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tQ\"\u001a<f]Rd\u0017n\u001d;f]\u0016\u0014(\u0002BA\u0016\u0003[\tA\u0001\u001d7b]*!\u0011qDA\u0018\u0015\u0011\t\t$a\r\u0002\u0011\u0005\u001cGo\u001c:ba&T1!!\u000e\u0015\u0003\u0011\u0019W.\u001c8\n\t\u0005e\u0012Q\u0005\u0002\t)&lWM]*fi\")\u0011p\u0004a\u0001{\u0006i1o\u00195fIVdW\rV5nKJ$2A[A!\u0011\u001d\t\u0019\u0005\u0005a\u0001\u0003\u000b\nQ\u0001^5nKJ\u00042!LA$\u0013\r\tIE\u0005\u0002\u0006)&lWM\u001d")
public class TimerMonitor
implements LazyLogging {
    private final TimerService timerService;
    private final Map<String, TimerJob> activeTimers;
    private final ExecutionContext dispatcher;
    private final Scheduler scheduler;
    private final TimerStorageReader reader;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TimerMonitor timerMonitor = this;
        synchronized (timerMonitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    private Map<String, TimerJob> activeTimers() {
        return this.activeTimers;
    }

    public ExecutionContext dispatcher() {
        return this.dispatcher;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public TimerStorageReader reader() {
        return this.reader;
    }

    public void start() {
        this.reader().loadNextWindow();
        FiniteDuration interval = Cafienne$.MODULE$.config().engine().timerService().interval();
        this.scheduler().scheduleAtFixedRate(interval, interval, (Runnable)this.reader(), this.dispatcher());
    }

    public Future<Done> removeTimer(String timerId, Option<Offset> offset) {
        this.activeTimers().remove((Object)timerId).map((Function1 & Serializable)schedule -> BoxesRunTime.boxToBoolean((boolean)schedule.cancel()));
        return this.runStorage((Function0<Future<Done>>)(Function0 & Serializable)() -> $this.timerService().storage.removeTimer(timerId, offset));
    }

    /*
     * WARNING - void declaration
     */
    public Future<Done> runStorage(Function0<Future<Done>> function) {
        Future future;
        try {
            void var2_2;
            Future result = (Future)function.apply();
            HealthMonitor$.MODULE$.timerService().isOK();
            future = var2_2;
        }
        catch (Throwable t) {
            HealthMonitor$.MODULE$.timerService().hasFailed(t);
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    public Future<Done> addTimer(TimerSet event, Offset offset) {
        Timer job;
        block0: {
            job = new Timer(event.getCaseInstanceId(), event.getTimerId(), event.getTargetMoment(), event.getUser().id());
            if (!this.reader().fitsActiveWindow(job)) break block0;
            this.scheduleTimer(job);
        }
        return this.runStorage((Function0<Future<Done>>)(Function0 & Serializable)() -> $this.timerService().storage.storeTimer(job, (Option<Offset>)new Some((Object)offset)));
    }

    public void scheduleTimer(Timer timer) {
        this.activeTimers().getOrElseUpdate((Object)timer.timerId(), (Function0 & Serializable)() -> new TimerJob(this.timerService(), timer, this.scheduler()));
    }

    public TimerMonitor(TimerService timerService) {
        this.timerService = timerService;
        LazyLogging.$init$((LazyLogging)this);
        this.activeTimers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dispatcher = timerService.caseSystem.system().dispatcher();
        this.scheduler = timerService.caseSystem.system().scheduler();
        this.reader = new TimerStorageReader(this);
    }
}

