/*
 * Decompiled with CFR 0.152.
 */
package slick.migration.api.org.cafienne.infrastructure.jdbc.sqlserver;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import slick.ast.FieldSymbol;
import slick.jdbc.SQLServerProfile;
import slick.migration.api.AstHelpers;
import slick.migration.api.Dialect;
import slick.model.ForeignKeyAction;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u000e\u001d\u00015BQ!\u0011\u0001\u0005\u0002\tCQ!\u0012\u0001\u0005\n\u0019CQA\u0017\u0001\u0005BmCQA\u001d\u0001\u0005BMDQa\u001f\u0001\u0005BqDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a%\u0001\t\u0003\n)\nC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\t)\r\u0001C!\u0003\u000fDq!a3\u0001\t\u0003\ni\rC\u0004\u0002L\u0002!\t%a6\t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\"9\u0011q\u001d\u0001\u0005B\u0005%\bbBAx\u0001\u0011\u0005\u0013\u0011\u001f\u0005\b\u0003o\u0004A\u0011IA}\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007\u0011\u0001cU)M'\u0016\u0014h/\u001a:ES\u0006dWm\u0019;\u000b\u0005uq\u0012!C:rYN,'O^3s\u0015\ty\u0002%\u0001\u0003kI\n\u001c'BA\u0011#\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016T!a\t\u0013\u0002\u0011\r\fg-[3o]\u0016T!!\n\u0014\u0002\u0007=\u0014xM\u0003\u0002(Q\u0005\u0019\u0011\r]5\u000b\u0005%R\u0013!C7jOJ\fG/[8o\u0015\u0005Y\u0013!B:mS\u000e\\7\u0001A\n\u0004\u00019:\u0004cA\u00181e5\ta%\u0003\u00022M\t9A)[1mK\u000e$\bCA\u001a6\u001b\u0005!$BA\u0010+\u0013\t1DG\u0001\tT#2\u001bVM\u001d<feB\u0013xNZ5mKB\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003yu\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002}\u0005\u00191m\\7\n\u0005\u0001K$a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#A\"\u0011\u0005\u0011\u0003Q\"\u0001\u000f\u0002\u00071|w\r\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u0015q%\u00011\u0001P\u0003\ri7o\u001a\t\u0003!^s!!U+\u0011\u0005IKU\"A*\u000b\u0005Qc\u0013A\u0002\u001fs_>$h(\u0003\u0002W\u0013\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1\u0016*A\u0004bkR|\u0017J\\2\u0015\u0005q\u001b\u0007CA/c\u001b\u0005q&BA0a\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\fAA[1wC&\u0011\u0001L\u0018\u0005\u0006I\u000e\u0001\r!Z\u0001\u0003G&\u0004\"AZ8\u000f\u0005\u001dlgB\u00015m\u001d\tI7N\u0004\u0002SU&\t1&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003]\u001a\n!\"Q:u\u0011\u0016d\u0007/\u001a:t\u0013\t\u0001\u0018O\u0001\u0006D_2,XN\\%oM>T!A\u001c\u0014\u0002\u0013\u0005$GmQ8mk6tGcA(us\")Q\u000f\u0002a\u0001m\u0006)A/\u00192mKB\u0011am^\u0005\u0003qF\u0014\u0011\u0002V1cY\u0016LeNZ8\t\u000bi$\u0001\u0019A3\u0002\r\r|G.^7o\u0003e\tG\rZ\"pYVlgnV5uQ&s\u0017\u000e^5bYZ\u000bG.^3\u0015\u000fu\fi!a\u0004\u0002\u0012A!a0a\u0002P\u001d\ry\u00181\u0001\b\u0004%\u0006\u0005\u0011\"\u0001&\n\u0007\u0005\u0015\u0011*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00111\u0002\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0006%CQ!^\u0003A\u0002YDQA_\u0003A\u0002\u0015Da!a\u0005\u0006\u0001\u0004y\u0015A\u0003:boN\u000bH.\u0012=qe\u0006\u0011\u0012\r\u001c;fe\u000e{G.^7o\t\u00164\u0017-\u001e7u)\u0015y\u0015\u0011DA\u000e\u0011\u0015)h\u00011\u0001w\u0011\u0015Qh\u00011\u0001f\u0003%\u0019w\u000e\\;n]N\u000bH\u000eF\u0003P\u0003C\t\u0019\u0003C\u0003e\u000f\u0001\u0007Q\rC\u0004\u0002&\u001d\u0001\r!a\n\u0002\u00119,w\u000fV1cY\u0016\u00042\u0001SA\u0015\u0013\r\tY#\u0013\u0002\b\u0005>|G.Z1o\u0003)\u0019w\u000e\\;n]RK\b/\u001a\u000b\u0004\u001f\u0006E\u0002\"\u00023\t\u0001\u0004)\u0017\u0001E2sK\u0006$XMR8sK&<gnS3z)=y\u0015qGA\u001e\u0003\u007f\t)&!\u0017\u0002^\u00055\u0004BBA\u001d\u0013\u0001\u0007a/A\u0006t_V\u00148-\u001a+bE2,\u0007BBA\u001f\u0013\u0001\u0007q*\u0001\u0003oC6,\u0007bBA!\u0013\u0001\u0007\u00111I\u0001\u000eg>,(oY3D_2,XN\\:\u0011\u000by\f)%!\u0013\n\t\u0005\u001d\u00131\u0002\u0002\u0004'\u0016\f\b\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=#&A\u0002bgRLA!a\u0015\u0002N\tYa)[3mINKXNY8m\u0011\u0019\t9&\u0003a\u0001m\u0006YA/\u0019:hKR$\u0016M\u00197f\u0011\u001d\tY&\u0003a\u0001\u0003\u0007\nQ\u0002^1sO\u0016$8i\u001c7v[:\u001c\bbBA0\u0013\u0001\u0007\u0011\u0011M\u0001\t_:,\u0006\u000fZ1uKB!\u00111MA5\u001b\t\t)GC\u0002\u0002h)\nQ!\\8eK2LA!a\u001b\u0002f\t\u0001bi\u001c:fS\u001et7*Z=BGRLwN\u001c\u0005\b\u0003_J\u0001\u0019AA1\u0003!yg\u000eR3mKR,\u0017aC2sK\u0006$X-\u00138eKb$2aTA;\u0011\u001d\t9H\u0003a\u0001\u0003s\nQ!\u001b8eKb\u00042AZA>\u0013\r\ti(\u001d\u0002\n\u0013:$W\r_%oM>\f1b\u0019:fCR,G+\u00192mKR)Q0a!\u0002\u0006\")Qo\u0003a\u0001m\"9\u0011qQ\u0006A\u0002\u0005%\u0015aB2pYVlgn\u001d\t\u0005}\u0006\u0015S-\u0001\u0006ee>\u00048i\u001c7v[:$R!`AH\u0003#CQ!\u001e\u0007A\u0002YDQA\u001f\u0007A\u0002=\u000ba\u0002\u001a:pa\u000e{gn\u001d;sC&tG\u000fF\u0003P\u0003/\u000bI\nC\u0003v\u001b\u0001\u0007a\u000f\u0003\u0004\u0002>5\u0001\raT\u0001\nIJ|\u0007\u000fV1cY\u0016$2aTAP\u0011\u0015)h\u00021\u0001w\u0003\u001dqw\u000e\u001e(vY2$2\u0001XAS\u0011\u0015!w\u00021\u0001f\u0003)\u0001(/[7bef\\U-\u001f\u000b\u0006\u001f\u0006-\u0016Q\u0016\u0005\u0006IB\u0001\r!\u001a\u0005\b\u0003K\u0001\u0002\u0019AA\u0014\u0003-\u0011XM\\1nK&sG-\u001a=\u0015\u000bu\f\u0019,a.\t\u000f\u0005U\u0016\u00031\u0001\u0002z\u0005\u0019q\u000e\u001c3\t\r\u0005e\u0016\u00031\u0001P\u0003\u001dqWm\u001e(b[\u0016\f1B]3oC6,G+\u00192mKR)q*a0\u0002B\")QO\u0005a\u0001m\"1\u00111\u0019\nA\u0002=\u000b!\u0001^8\u0002\u0013\u0011\u0014x\u000e]%oI\u0016DHc\u0001/\u0002J\"9\u0011qO\nA\u0002\u0005e\u0014\u0001\u0004:f]\u0006lWmQ8mk6tGcB(\u0002P\u0006E\u0017Q\u001b\u0005\u0006kR\u0001\rA\u001e\u0005\u0007\u0003'$\u0002\u0019A3\u0002\t\u0019\u0014x.\u001c\u0005\u0007\u0003\u0007$\u0002\u0019A(\u0015\u000fq\u000bI.a7\u0002^\")Q/\u0006a\u0001m\"1\u00111[\u000bA\u0002=Ca!a1\u0016\u0001\u0004y\u0015AF1mi\u0016\u00148i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=\u0015\u000b=\u000b\u0019/!:\t\u000bU4\u0002\u0019\u0001<\t\u000bi4\u0002\u0019A3\u0002\u001f\u0005dG/\u001a:D_2,XN\u001c+za\u0016$R!`Av\u0003[DQ!^\fA\u0002YDQA_\fA\u0002\u0015\fa\u0002\u001a:pa\u001a{'/Z5h].+\u0017\u0010F\u0003P\u0003g\f)\u0010C\u0003v1\u0001\u0007a\u000f\u0003\u0004\u0002>a\u0001\raT\u0001\u0011GJ,\u0017\r^3Qe&l\u0017M]=LKf$raTA~\u0003{\fy\u0010C\u0003v3\u0001\u0007a\u000f\u0003\u0004\u0002>e\u0001\ra\u0014\u0005\b\u0003\u000fK\u0002\u0019AA\"\u00039!'o\u001c9Qe&l\u0017M]=LKf$Ra\u0014B\u0003\u0005\u000fAQ!\u001e\u000eA\u0002YDa!!\u0010\u001b\u0001\u0004y\u0005")
public class SQLServerDialect
extends Dialect<SQLServerProfile>
implements LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        SQLServerDialect sQLServerDialect = this;
        synchronized (sQLServerDialect) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private void log(String msg) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(msg);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String autoInc(AstHelpers.ColumnInfo ci) {
        if (ci.autoInc()) {
            return " AUTO_INCREMENT";
        }
        return "";
    }

    public String addColumn(AstHelpers.TableInfo table, AstHelpers.ColumnInfo column) {
        String string;
        String string2 = (String)column.default().map((Function1 & Serializable)v -> "DEFAULT " + v).getOrElse((Function0 & Serializable)() -> "");
        this.log("addColumn default: '" + string2 + "'");
        boolean bl = column.notNull();
        if (!bl) {
            string = "";
        } else if (bl) {
            string = "NOT NULL";
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        String notNull = string;
        String statement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" alter table \"" + table.tableName() + "\" add \"" + column.name() + "\" " + column.sqlType() + " " + notNull + " " + string2 + "; "));
        this.log("addColumn: " + statement);
        return statement;
    }

    public List<String> addColumnWithInitialValue(AstHelpers.TableInfo table, AstHelpers.ColumnInfo column, String rawSqlExpr) {
        List statement = super.addColumnWithInitialValue(table, column, rawSqlExpr);
        this.log("addColumnWithInitialValue [" + table.tableName() + "." + column.name() + "]: " + statement);
        return statement;
    }

    public String alterColumnDefault(AstHelpers.TableInfo table, AstHelpers.ColumnInfo column) {
        this.log("alterColumnDefault [" + table.tableName() + "." + column.name() + "]: returning empty string");
        return "";
    }

    public String columnSql(AstHelpers.ColumnInfo ci, boolean newTable) {
        String statement = super.columnSql(ci, newTable);
        this.log("\tcolumnSql (newTable=" + newTable + "): " + statement);
        return statement;
    }

    public String columnType(AstHelpers.ColumnInfo ci) {
        String statement = super.columnType(ci);
        if (statement.startsWith("VARCHAR")) {
            return "N" + statement;
        }
        return statement;
    }

    public String createForeignKey(AstHelpers.TableInfo sourceTable, String name, Seq<FieldSymbol> sourceColumns, AstHelpers.TableInfo targetTable, Seq<FieldSymbol> targetColumns, ForeignKeyAction onUpdate, ForeignKeyAction onDelete) {
        String statement = super.createForeignKey(sourceTable, name, sourceColumns, targetTable, targetColumns, onUpdate, onDelete);
        this.log("createForeignKey: " + statement);
        return statement;
    }

    public String createIndex(AstHelpers.IndexInfo index) {
        String statement = super.createIndex(index);
        this.log("createIndex: " + statement);
        return statement;
    }

    public List<String> createTable(AstHelpers.TableInfo table, Seq<AstHelpers.ColumnInfo> columns) {
        List statement = super.createTable(table, columns);
        return statement;
    }

    public List<String> dropColumn(AstHelpers.TableInfo table, String column) {
        List statement = super.dropColumn(table, column);
        this.log("dropColumn: " + statement);
        return statement;
    }

    public String dropConstraint(AstHelpers.TableInfo table, String name) {
        String statement = super.dropConstraint(table, name);
        this.log("dropConstraint: " + statement);
        return statement;
    }

    public String dropTable(AstHelpers.TableInfo table) {
        String statement = super.dropTable(table);
        this.log("dropTable: " + statement);
        return statement;
    }

    public String notNull(AstHelpers.ColumnInfo ci) {
        String statement = super.notNull(ci);
        this.log("notNull for " + ci.name() + ": " + statement);
        return statement;
    }

    public String primaryKey(AstHelpers.ColumnInfo ci, boolean newTable) {
        String statement = super.primaryKey(ci, newTable);
        this.log("primaryKey: " + statement);
        return statement;
    }

    public List<String> renameIndex(AstHelpers.IndexInfo old, String newName) {
        this.log("renameIndex");
        List statement = super.renameIndex(old, newName);
        return statement;
    }

    public String renameTable(AstHelpers.TableInfo table, String to) {
        return "\"sp_rename \"" + this.quoteTableName(table) + "\", @newname " + this.quoteIdentifier(to);
    }

    public String dropIndex(AstHelpers.IndexInfo index) {
        String statement = "drop index " + this.quoteIdentifier(index.name()) + " on " + this.quoteTableName(this.tableInfo(index.table()));
        this.log("dropIndex:" + statement);
        return statement;
    }

    public String renameColumn(AstHelpers.TableInfo table, AstHelpers.ColumnInfo from, String to) {
        this.log("renameColumn2[" + table.tableName() + "]: from " + from + " to " + to);
        return super.renameColumn(table, from, to);
    }

    public String renameColumn(AstHelpers.TableInfo table, String from, String to) {
        String statement = "sp_rename \"" + table.tableName() + "." + from + "\", " + this.quoteIdentifier(to) + " ";
        this.log("renameColumn[" + table.tableName() + "]:" + statement);
        return statement;
    }

    public String alterColumnNullability(AstHelpers.TableInfo table, AstHelpers.ColumnInfo column) {
        String statement = super.alterColumnNullability(table, column);
        this.log("alterColumnNullability[" + table.tableName() + "]: " + statement);
        return statement;
    }

    public List<String> alterColumnType(AstHelpers.TableInfo table, AstHelpers.ColumnInfo column) {
        List statement = super.alterColumnType(table, column);
        this.log("alterColumnType[" + table.tableName() + "]: " + statement);
        return statement;
    }

    public String dropForeignKey(AstHelpers.TableInfo table, String name) {
        String statement = super.dropForeignKey(table, name);
        this.log("dropForeignKey: " + statement);
        return statement;
    }

    public String createPrimaryKey(AstHelpers.TableInfo table, String name, Seq<FieldSymbol> columns) {
        String statement = super.createPrimaryKey(table, name, columns);
        this.log("createPrimaryKey[" + table.tableName() + "]: " + statement);
        return statement;
    }

    public String dropPrimaryKey(AstHelpers.TableInfo table, String name) {
        String statement = super.dropPrimaryKey(table, name);
        this.log("dropPrimaryKey[" + table.tableName() + "]: " + statement);
        return statement;
    }

    public SQLServerDialect() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

