/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.identity;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.akka.actor.CaseSystem$;
import org.cafienne.akka.actor.command.exception.AuthorizationException;
import org.cafienne.akka.actor.command.response.ActorLastModified;
import org.cafienne.akka.actor.identity.PlatformUser;
import org.cafienne.akka.actor.identity.TenantUser;
import org.cafienne.cmmn.repository.file.SimpleLRUCache;
import org.cafienne.identity.IdentityProvider;
import org.cafienne.service.api.projection.query.UserQueries;
import org.cafienne.service.api.tenant.TenantReader$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0006\r\u0001MA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tk\u0001\u0011)\u0019!C\u0002m!AQ\b\u0001B\u0001B\u0003%q\u0007C\u0003?\u0001\u0011\u0005q\bC\u0004E\u0001\t\u0007I\u0011B#\t\r\u0011\u0004\u0001\u0015!\u0003G\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015\t\b\u0001\"\u0003s\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015Q\b\u0001\"\u0011|\u00055IE-\u001a8uSRL8)Y2iK*\u0011QBD\u0001\tS\u0012,g\u000e^5us*\u0011q\u0002E\u0001\tG\u00064\u0017.\u001a8oK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001)iq\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\t\u0001\u0012\nZ3oi&$\u0018\u0010\u0015:pm&$WM\u001d\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nAb]2bY\u0006dwnZ4j]\u001eT!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014!\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0017U\u001cXM])vKJLWm\u001d\t\u0003UMj\u0011a\u000b\u0006\u0003Y5\nQ!];fefT!AL\u0018\u0002\u0015A\u0014xN[3di&|gN\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0005Ir\u0011aB:feZL7-Z\u0005\u0003i-\u00121\"V:feF+XM]5fg\u0006\u0011QmY\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!HF\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001f:\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\na\u0001P5oSRtDC\u0001!D)\t\t%\t\u0005\u0002\u001c\u0001!)Q\u0007\u0002a\u0002o!)\u0001\u0006\u0002a\u0001S\u0005)1-Y2iKV\ta\t\u0005\u0003H\u001dB[V\"\u0001%\u000b\u0005%S\u0015\u0001\u00024jY\u0016T!a\u0013'\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002N\u001d\u0005!1-\\7o\u0013\ty\u0005J\u0001\bTS6\u0004H.\u001a'S+\u000e\u000b7\r[3\u0011\u0005ECfB\u0001*W!\t\u0019f#D\u0001U\u0015\t)&#\u0001\u0004=e>|GOP\u0005\u0003/Z\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qK\u0006\t\u00039\nl\u0011!\u0018\u0006\u0003\u001byS!a\u00181\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005t\u0011\u0001B1lW\u0006L!aY/\u0003\u0019Ac\u0017\r\u001e4pe6,6/\u001a:\u0002\r\r\f7\r[3!\u0003\u001d9W\r^+tKJ$2a\u001a6m!\rA\u0004nW\u0005\u0003Sf\u0012aAR;ukJ,\u0007\"B6\b\u0001\u0004\u0001\u0016AB;tKJLE\rC\u0003n\u000f\u0001\u0007a.A\u0002uY6\u00042!F8Q\u0013\t\u0001hC\u0001\u0004PaRLwN\\\u0001\u0011Kb,7-\u001e;f+N,'/U;fef$\"aZ:\t\u000b-D\u0001\u0019\u0001)\u0002\u000b\rdW-\u0019:\u0015\u0005YL\bCA\u000bx\u0013\tAhC\u0001\u0003V]&$\b\"B6\n\u0001\u0004\u0001\u0016\u0001C4fiV\u001bXM]:\u0015\u000bq\f\u0019\"!\u0007\u0011\u0007aBW\u0010E\u0003\u007f\u0003\u000f\tiAD\u0002\u0000\u0003\u0007q1aUA\u0001\u0013\u00059\u0012bAA\u0003-\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0005\u0003\u0017\u00111aU3r\u0015\r\t)A\u0006\t\u00049\u0006=\u0011bAA\t;\nQA+\u001a8b]R,6/\u001a:\t\u000f\u0005U!\u00021\u0001\u0002\u0018\u00059Qo]3s\u0013\u0012\u001c\b\u0003\u0002@\u0002\bACa!a\u0007\u000b\u0001\u0004\u0001\u0016A\u0002;f]\u0006tG\u000f")
public class IdentityCache
implements IdentityProvider,
LazyLogging {
    private final UserQueries userQueries;
    private final ExecutionContext ec;
    private final SimpleLRUCache<String, PlatformUser> cache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        IdentityCache identityCache = this;
        synchronized (identityCache) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private SimpleLRUCache<String, PlatformUser> cache() {
        return this.cache;
    }

    @Override
    public Future<PlatformUser> getUser(String userId, Option<String> tlm) {
        Future future;
        Option<String> option = tlm;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            future = TenantReader$.MODULE$.lastModifiedRegistration().waitFor(new ActorLastModified(s)).future().flatMap((Function1 & Serializable & scala.Serializable)p -> this.executeUserQuery(userId).map((Function1 & Serializable & scala.Serializable)u -> (PlatformUser)new Tuple2(p, u)._2(), this.ec()), this.ec());
        } else if (None$.MODULE$.equals(option)) {
            future = this.executeUserQuery(userId);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Future<PlatformUser> executeUserQuery(String userId) {
        Future future;
        PlatformUser platformUser = (PlatformUser)this.cache().get((Object)userId);
        if (platformUser != null) {
            PlatformUser platformUser2 = platformUser;
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> platformUser2, this.ec());
        } else if (platformUser == null) {
            future = this.userQueries.getPlatformUser(userId).map((Function1 & Serializable & scala.Serializable)u -> {
                if (u.users().isEmpty() && !u.isPlatformOwner()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(65).append("User ").append(userId).append(" has a valid token, but is not registered in the case system").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new AuthorizationException(new StringBuilder(42).append("User ").append(userId).append(" is not registered in the case system").toString());
                }
                this.cache().put((Object)userId, u);
                return u;
            }, this.ec());
        } else {
            throw new MatchError((Object)platformUser);
        }
        return future;
    }

    @Override
    public void clear(String userId) {
        this.cache().remove((Object)userId);
    }

    @Override
    public Future<Seq<TenantUser>> getUsers(Seq<String> userIds, String tenant) {
        return this.userQueries.getSelectedTenantUsers(tenant, userIds);
    }

    public IdentityCache(UserQueries userQueries, ExecutionContext ec) {
        this.userQueries = userQueries;
        this.ec = ec;
        IdentityProvider.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.cache = new SimpleLRUCache(CaseSystem$.MODULE$.config().api().security().identityCacheSize());
    }
}

