/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.akka.http.authentication;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.cafienne.akka.actor.CaseSystem$;
import org.cafienne.infrastructure.akka.http.authentication.CannotReachIDPException;
import org.cafienne.infrastructure.akka.http.authentication.InvalidIssuerException;
import org.cafienne.infrastructure.akka.http.authentication.MissingClaimsException;
import org.cafienne.infrastructure.akka.http.authentication.MissingTokenException$;
import org.cafienne.infrastructure.akka.http.authentication.ServiceUserContext;
import org.cafienne.infrastructure.akka.http.authentication.TokenSubject;
import org.cafienne.infrastructure.akka.http.authentication.TokenVerificationException;
import org.cafienne.infrastructure.akka.http.authentication.TokenVerificationException$;
import org.cafienne.infrastructure.akka.http.authentication.TokenVerifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001D\u0007\u00015!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\"\u0002-\u0001\t\u0003I\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011B1\t\u000f%\u0004!\u0019!C\u0001U\"1q\u000e\u0001Q\u0001\n-Dq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\u0006m\u0002!\te\u001e\u0002\u0011\u0015^$Hk\\6f]Z+'/\u001b4jKJT!AD\b\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011\u0001#E\u0001\u0005QR$\bO\u0003\u0002\u0013'\u0005!\u0011m[6b\u0015\t!R#\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\u000b\u0005Y9\u0012\u0001C2bM&,gN\\3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000e\"QA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u00042AI\u0012&\u001b\u0005i\u0011B\u0001\u0013\u000e\u00055!vn[3o-\u0016\u0014\u0018NZ5feB\u0011!EJ\u0005\u0003O5\u0011!cU3sm&\u001cW-V:fe\u000e{g\u000e^3yiB\u0011\u0011\u0006M\u0007\u0002U)\u00111\u0006L\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[9\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002_\u0005\u00191m\\7\n\u0005ER#a\u0003'bufdunZ4j]\u001e\f\u0011b[3z'>,(oY3\u0011\u0007Qjt(D\u00016\u0015\t1t'\u0001\u0004t_V\u00148-\u001a\u0006\u0003qe\n1A[<l\u0015\tQ4(\u0001\u0003k_N,'B\u0001\u001f/\u0003!q\u0017.\u001c2vg\u0012\u001c\u0018B\u0001 6\u0005%QukS*pkJ\u001cW\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cs\u0005!\u0001O]8d\u0013\t!\u0015IA\bTK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u0003\u0019I7o];feB\u0011qI\u0014\b\u0003\u00112\u0003\"!S\u000f\u000e\u0003)S!aS\r\u0002\rq\u0012xn\u001c;?\u0013\tiU$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u001e\u0003\t)7\r\u0005\u0002T-6\tAK\u0003\u0002V;\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005]#&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019!,\u00180\u0015\u0005mc\u0006C\u0001\u0012\u0001\u0011\u0015\tF\u0001q\u0001S\u0011\u0015\u0011D\u00011\u00014\u0011\u0015)E\u00011\u0001G\u00031Qw\u000f\u001e)s_\u000e,7o]8s+\u0005\t\u0007c\u00012g\u007f5\t1M\u0003\u0002CI*\u0011QmO\u0001\u0004U^$\u0018BA4d\u0005a\u0019uN\u001c4jOV\u0014\u0018M\u00197f\u0015^#\u0006K]8dKN\u001cxN]\u0001\u000eU^$\bK]8dKN\u001cxN\u001d\u0011\u0002\u001d\u0015D\b/Z2uK\u0012TukU!mOV\t1\u000e\u0005\u0002m[6\t\u0011(\u0003\u0002os\ta!jV*BY\u001e|'/\u001b;i[\u0006yQ\r\u001f9fGR,GMS,T\u00032<\u0007%A\u0006lKf\u001cV\r\\3di>\u0014X#\u0001:\u0011\u0007\u0001\u001bx(\u0003\u0002u\u0003\nq!jV*LKf\u001cV\r\\3di>\u0014\u0018\u0001D6fsN+G.Z2u_J\u0004\u0013a\u0003<fe&4\u0017\u0010V8lK:$\"\u0001_>\u0011\u0007MKX%\u0003\u0002{)\n1a)\u001e;ve\u0016DQ\u0001`\u0006A\u0002\u0019\u000bQ\u0001^8lK:\u0004")
public class JwtTokenVerifier
implements TokenVerifier<ServiceUserContext>,
LazyLogging {
    private final ExecutionContext ec;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private final JWSAlgorithm expectedJWSAlg;
    private final JWSKeySelector<SecurityContext> keySelector;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        JwtTokenVerifier jwtTokenVerifier = this;
        synchronized (jwtTokenVerifier) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ConfigurableJWTProcessor<SecurityContext> jwtProcessor() {
        return this.jwtProcessor;
    }

    public JWSAlgorithm expectedJWSAlg() {
        return this.expectedJWSAlg;
    }

    public JWSKeySelector<SecurityContext> keySelector() {
        return this.keySelector;
    }

    @Override
    public Future<ServiceUserContext> verifyToken(String token) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ServiceUserContext serviceUserContext;
            None$ claimsSet = None$.MODULE$;
            if (token.isEmpty()) {
                throw MissingTokenException$.MODULE$;
            }
            try {
                SecurityContext ctx = null;
                claimsSet = new Some((Object)this.jwtProcessor().process(token, ctx));
                serviceUserContext = (ServiceUserContext)claimsSet.fold((Function0 & Serializable & scala.Serializable)() -> {
                    throw new TokenVerificationException(new StringBuilder(30).append("Unable to create claimSet for ").append(token).toString());
                }, (Function1 & Serializable & scala.Serializable)cS -> {
                    CaseSystem$.MODULE$.health().idp().isOK();
                    return new ServiceUserContext(new TokenSubject(cS.getSubject()), (List<String>)((List)Option$.MODULE$.apply((Object)cS.getStringListClaim("groups")).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)groups -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(groups).asScala()).toList())));
                });
            }
            catch (RemoteKeySourceException rp) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failure in contacting IDP. Check IDP configuration settings of the case engine.", (Throwable)rp);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                CannotReachIDPException failure = new CannotReachIDPException("Cannot reach the IDP to validate credentials", rp);
                CaseSystem$.MODULE$.health().idp().hasFailed((Throwable)failure);
                throw failure;
            }
            catch (Throwable other) {
                CaseSystem$.MODULE$.health().idp().isOK();
                Throwable throwable = other;
                if (throwable instanceof BadJWTException) {
                    BadJWTException badJWTException = (BadJWTException)throwable;
                    String exceptionMessage = badJWTException.getMessage();
                    String missingClaimsMsg = "JWT missing required claims";
                    String invalidIssuerMsg = "JWT \"iss\" claim doesn't match expected value: ";
                    String jwtAudienceRejected = "JWT audience rejected";
                    String badJson = "Payload of JWS object is not a valid JSON object";
                    if (badJWTException.getCause() instanceof ParseException) {
                        throw new TokenVerificationException(new StringBuilder(21).append("Token parse failure: ").append(badJWTException.getCause().getLocalizedMessage()).toString());
                    }
                    if (exceptionMessage.contains(missingClaimsMsg)) {
                        throw new MissingClaimsException(exceptionMessage.replace(missingClaimsMsg, "JWT token misses claims"));
                    }
                    if (exceptionMessage.contains(invalidIssuerMsg)) {
                        String invalidIssuer = exceptionMessage.replace(invalidIssuerMsg, "");
                        throw new InvalidIssuerException(new StringBuilder(52).append("JWT token has invalid issuer '").append(invalidIssuer).append("'. Issuers supported: ").append(CaseSystem$.MODULE$.config().OIDC().issuer()).toString());
                    }
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(15).append("Invalid token: ").append(badJWTException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof BadJOSEException) {
                    BoxedUnit boxedUnit;
                    BadJOSEException badJOSEException = (BadJOSEException)throwable;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Encountered JWT issues", (Throwable)badJOSEException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(26).append("Token cannot be verified: ").append(badJOSEException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof ParseException) {
                    ParseException parseException = (ParseException)throwable;
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(21).append("Token parse failure: ").append(parseException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof Exception) {
                    BoxedUnit boxedUnit;
                    Exception exception = (Exception)throwable;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Unexpected or unforeseen exception during token verification; throwing it further", (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new TokenVerificationException(new StringBuilder(35).append("Token verification failure of type ").append(exception.getClass().getSimpleName()).toString(), exception);
                }
                throw new MatchError((Object)throwable);
            }
            return serviceUserContext;
        }, this.ec);
    }

    public JwtTokenVerifier(JWKSource<SecurityContext> keySource, String issuer, ExecutionContext ec) {
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.expectedJWSAlg = JWSAlgorithm.RS256;
        this.keySelector = new JWSVerificationKeySelector(this.expectedJWSAlg(), keySource);
        this.jwtProcessor().setJWSKeySelector(this.keySelector());
        this.jwtProcessor().setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer).build(), new HashSet<Object>(Arrays.asList((Object[])new String[]{"sub", "exp"}))));
    }
}

