/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RouteResult$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Flow;
import akka.util.Timeout;
import java.io.Serializable;
import org.cafienne.akka.actor.CaseSystem$;
import org.cafienne.cmmn.akka.BuildInfo$;
import org.cafienne.identity.IdentityCache;
import org.cafienne.infrastructure.akka.http.route.CaseServiceRoute;
import org.cafienne.infrastructure.jdbc.JDBCBasedOffsetStorageProvider;
import org.cafienne.service.Main$delayedInit$body;
import org.cafienne.service.api.SwaggerHttpServiceRoute;
import org.cafienne.service.api.cases.route.CasesRoutes;
import org.cafienne.service.api.debug.DebugRoute;
import org.cafienne.service.api.platform.BootstrapPlatformConfiguration$;
import org.cafienne.service.api.platform.CaseEngineHealthRoute;
import org.cafienne.service.api.platform.PlatformRoutes;
import org.cafienne.service.api.projection.cases.CaseProjectionsWriter;
import org.cafienne.service.api.projection.query.CaseQueriesImpl;
import org.cafienne.service.api.projection.query.TaskQueriesImpl;
import org.cafienne.service.api.projection.query.TenantQueriesImpl;
import org.cafienne.service.api.projection.slick.SlickRecordsPersistence;
import org.cafienne.service.api.projection.tenant.TenantProjectionsWriter;
import org.cafienne.service.api.repository.RepositoryRoute;
import org.cafienne.service.api.tasks.TaskRoutes;
import org.cafienne.service.api.tenant.route.TenantRoutes;
import org.cafienne.service.db.querydb.QueryDB$;
import org.h2.tools.Server;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Main$
implements App {
    public static Main$ MODULE$;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new Main$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void stop(Throwable t) {
        t.printStackTrace();
        System.exit(-1);
    }

    public Timeout httpRoutesTimeout() {
        return new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(15)).seconds());
    }

    public Timeout caseSystemTimeout() {
        return new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
    }

    public void startup() {
        CaseSystem$.MODULE$.start(CaseSystem$.MODULE$.start$default$1());
        Timeout timeout = this.httpRoutesTimeout();
        ActorSystem system = CaseSystem$.MODULE$.system();
        ExecutionContextExecutor ec = system.dispatcher();
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)"Shutting down the case service");
            Await$.MODULE$.result((Awaitable)system.terminate(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds());
        });
        BootstrapPlatformConfiguration$.MODULE$.run();
        TaskQueriesImpl taskQueries = new TaskQueriesImpl();
        CaseQueriesImpl caseQueries = new CaseQueriesImpl();
        TenantQueriesImpl userQueries = new TenantQueriesImpl();
        SlickRecordsPersistence updater = new SlickRecordsPersistence();
        JDBCBasedOffsetStorageProvider offsetStorage = new JDBCBasedOffsetStorageProvider();
        IdentityCache userCache = new IdentityCache(userQueries, (ExecutionContext)ec);
        new CaseProjectionsWriter(updater, offsetStorage, system).start();
        new TenantProjectionsWriter(userQueries, updater, offsetStorage, system, userCache).start();
        this.checkH2InDebugMode(system);
        Seq caseServiceRoutes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CaseServiceRoute[]{new CaseEngineHealthRoute(), new CasesRoutes(caseQueries, userCache), new TaskRoutes(taskQueries, userCache), new TenantRoutes(userQueries, userCache), new PlatformRoutes(userCache), new RepositoryRoute(userCache), new DebugRoute(userCache, system)}));
        Seq apiClasses = (Seq)caseServiceRoutes.flatMap((Function1 & Serializable & scala.Serializable)route -> route.apiClasses(), Seq$.MODULE$.canBuildFrom());
        Function1 apiRoutes = Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[0].route()).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[1].route())).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[2].route())).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[3].route())).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[4].route())).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[5].route())).$tilde(((CaseServiceRoute[])caseServiceRoutes.toArray(ClassTag$.MODULE$.apply(CaseServiceRoute.class)))[6].route())).$tilde(new SwaggerHttpServiceRoute(apiClasses.toSet()).route());
        String apiHost = CaseSystem$.MODULE$.config().api().bindHost();
        int apiPort = CaseSystem$.MODULE$.config().api().bindPort();
        HttpExt qual$1 = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        Flow x$1 = RouteResult$.MODULE$.routeToFlow(apiRoutes, (ClassicActorSystemProvider)system);
        String x$2 = apiHost;
        int x$3 = apiPort;
        ConnectionContext x$4 = qual$1.bindAndHandle$default$4();
        ServerSettings x$5 = qual$1.bindAndHandle$default$5();
        LoggingAdapter x$6 = qual$1.bindAndHandle$default$6();
        Future httpServer = qual$1.bindAndHandle(x$1, x$2, x$3, x$4, x$5, x$6, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system));
        httpServer.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Main$.$anonfun$startup$3(system, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ec);
    }

    private void checkH2InDebugMode(ActorSystem system) {
        block0: {
            if (!CaseSystem$.MODULE$.config().queryDB().debug()) break block0;
            String port = "8082";
            system.log().warning(new StringBuilder(31).append("Starting H2 Web Client on port ").append(port).toString());
            Server.createWebServer((String[])new String[]{"-web", "-webAllowOthers", "-webPort", port}).start();
        }
    }

    public static final /* synthetic */ void $anonfun$startup$3(ActorSystem system$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Http.ServerBinding answer = (Http.ServerBinding)success.value();
            system$1.log().info(new StringBuilder(17).append("service is done: ").append(answer).toString());
            system$1.log().info(new StringBuilder(10).append("Running [").append(BuildInfo$.MODULE$).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable msg = failure.exception();
            system$1.log().error(new StringBuilder(16).append("service failed: ").append(msg).toString());
            System.exit(-1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public final void delayedEndpoint$org$cafienne$service$Main$1() {
        try {
            QueryDB$.MODULE$.verifyConnectivity();
            this.startup();
        }
        catch (Throwable t) {
            this.stop(t);
        }
    }

    private Main$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new Main$delayedInit$body(this));
    }
}

