/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.api.platform;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.cafienne.akka.actor.CaseSystem$;
import org.cafienne.akka.actor.command.response.CommandFailure;
import org.cafienne.akka.actor.command.response.ModelResponse;
import org.cafienne.akka.actor.identity.PlatformUser;
import org.cafienne.service.Main$;
import org.cafienne.service.api.platform.BootstrapFailure;
import org.cafienne.service.api.platform.BootstrapFailure$;
import org.cafienne.tenant.akka.command.TenantUserInformation;
import org.cafienne.tenant.akka.command.platform.CreateTenant;
import org.cafienne.tenant.akka.command.response.TenantResponse;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BootstrapPlatformConfiguration$
implements LazyLogging {
    public static BootstrapPlatformConfiguration$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new BootstrapPlatformConfiguration$();
    }

    private Logger logger$lzycompute() {
        BootstrapPlatformConfiguration$ bootstrapPlatformConfiguration$ = this;
        synchronized (bootstrapPlatformConfiguration$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void run() {
        try {
            this.findConfigFile().map((Function1 & Serializable & scala.Serializable)configFile -> MODULE$.parseConfigFile((File)configFile)).map((Function1 & Serializable & scala.Serializable)bootstrapTenant -> MODULE$.sendCommand((CreateTenant)bootstrapTenant));
        }
        catch (BootstrapFailure b) {
            throw b;
        }
        catch (Throwable t) {
            throw new BootstrapFailure("Unexpected error while reading bootstrap configuration", t);
        }
    }

    private Option<File> findConfigFile() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Checking presence of bootstrap configuration for the case system");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String bootstrapTenantConfFileName = CaseSystem$.MODULE$.config().platform().bootstrapFile();
        if (!bootstrapTenantConfFileName.isBlank()) {
            BoxedUnit boxedUnit3;
            File configFile = new File(bootstrapTenantConfFileName);
            if (!configFile.exists()) {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(54).append("Sleeping a bit, becuase file ").append(bootstrapTenantConfFileName).append(" seems to not (yet) exist").toString());
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                Thread.sleep(1000L);
                if (!configFile.exists()) {
                    throw new BootstrapFailure(new StringBuilder(75).append("The configured bootstrap tenant file cannot be found at '").append(configFile.getAbsolutePath()).append("' (conf value: '").append(bootstrapTenantConfFileName).append("')").toString(), BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(47).append("Sleeping a bit helped, becuase file ").append(bootstrapTenantConfFileName).append(" now exists").toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return new Some((Object)configFile);
        }
        String defaultTenant = CaseSystem$.MODULE$.config().platform().defaultTenant();
        if (defaultTenant.isBlank()) {
            BoxedUnit boxedUnit5;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Default tenant is empty and bootstrap-file is not filled. Skipping bootstrap attempts");
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        File confFile = new File(new StringBuilder(5).append(defaultTenant).append(".conf").toString());
        if (confFile.exists()) {
            return new Some((Object)confFile);
        }
        File jsonFile = new File(new StringBuilder(5).append(defaultTenant).append(".json").toString());
        if (jsonFile.exists()) {
            return new Some((Object)jsonFile);
        }
        File ymlFile = new File(new StringBuilder(4).append(defaultTenant).append(".yml").toString());
        if (ymlFile.exists()) {
            return new Some((Object)ymlFile);
        }
        File yamlFile = new File(new StringBuilder(5).append(defaultTenant).append(".yaml").toString());
        if (yamlFile.exists()) {
            return new Some((Object)yamlFile);
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Skipping bootstrap tenant configuration for '{}', because a file '{}', '{}', '{}' or '{}' cannot be found", new Object[]{defaultTenant, confFile, jsonFile, ymlFile, yamlFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    private CreateTenant parseConfigFile(File configFile) {
        CreateTenant createTenant;
        BoxedUnit boxedUnit;
        String defaultTenant = CaseSystem$.MODULE$.config().platform().defaultTenant();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Bootstrapping tenant '{}' from file {}", (Object[])new String[]{defaultTenant, configFile.getAbsolutePath()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Config tenantConfig = ConfigFactory.parseFile((File)configFile);
        try {
            String tenantName = tenantConfig.getString("name");
            if (!tenantConfig.hasPath("owners")) {
                throw new BootstrapFailure("Bootstrap file should contain a list of owners, with at least one owner for the tenant", BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
            }
            Buffer ownerIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tenantConfig.getStringList("owners")).asScala();
            if (ownerIds.isEmpty()) {
                throw new BootstrapFailure("Bootstrap file should contain a list of owners, with at least one owner for the tenant", BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
            }
            Seq users = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tenantConfig.getConfigList("users")).asScala()).map((Function1 & Serializable & scala.Serializable)user -> {
                String userId = user.getString("id");
                Seq<String> roles = MODULE$.readStringList((Config)user, "roles", MODULE$.readStringList$default$3());
                String name = MODULE$.readStringOr((Config)user, "name", "");
                String email = MODULE$.readStringOr((Config)user, "email", "");
                boolean isOwner = ownerIds.contains((Object)userId);
                return new TenantUserInformation(userId, (Option)new Some(roles), (Option)new Some((Object)name), (Option)new Some((Object)email), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)isOwner)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }, Buffer$.MODULE$.canBuildFrom());
            Buffer undefinedOwners = (Buffer)ownerIds.filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)BootstrapPlatformConfiguration$.$anonfun$parseConfigFile$2(users, id)));
            if (!undefinedOwners.isEmpty()) {
                throw new BootstrapFailure(new StringBuilder(80).append("All bootstrap tenant owners must be defined as user. Following users not found: ").append(undefinedOwners).toString(), BootstrapFailure$.MODULE$.$lessinit$greater$default$2());
            }
            PlatformUser aPlatformOwner = new PlatformUser((String)CaseSystem$.MODULE$.config().platform().platformOwners().get(0), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            createTenant = new CreateTenant(aPlatformOwner, tenantName, tenantName, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(users).asJava());
        }
        catch (ConfigException c) {
            throw new BootstrapFailure(new StringBuilder(28).append("Bootstrap file ").append(configFile.getAbsolutePath()).append(" is invalid: ").append(c.getMessage()).toString(), c);
        }
        return createTenant;
    }

    private String readStringOr(Config config, String path, String defaultValue) {
        return config.hasPath(path) ? config.getString(path) : defaultValue;
    }

    private Seq<String> readStringList(Config config, String path, Seq<String> defaultValue) {
        return config.hasPath(path) ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList(path)).asScala() : defaultValue;
    }

    private Seq<String> readStringList$default$3() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private Future<BoxedUnit> sendCommand(CreateTenant bootstrapTenant) {
        Timeout timeout = Main$.MODULE$.caseSystemTimeout();
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.global();
        ActorRef qual$1 = package$.MODULE$.ask(CaseSystem$.MODULE$.router());
        CreateTenant x$1 = bootstrapTenant;
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$1, x$2, x$3).map((Function1 & Serializable & scala.Serializable)response -> {
            BootstrapPlatformConfiguration$.$anonfun$sendCommand$1(bootstrapTenant, response);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ec);
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigFile$2(Seq users$1, String id) {
        return !((SeqLike)users$1.map((Function1 & Serializable & scala.Serializable)u -> u.id(), Seq$.MODULE$.canBuildFrom())).contains((Object)id);
    }

    public static final /* synthetic */ void $anonfun$sendCommand$1(CreateTenant bootstrapTenant$1, Object response) {
        Object object = response;
        if (object instanceof CommandFailure) {
            BoxedUnit boxedUnit;
            CommandFailure commandFailure = (CommandFailure)object;
            if (commandFailure.exception().getMessage().toLowerCase().contains("already exists")) {
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Bootstrap tenant '{}' already exists; ignoring bootstrap info", new Object[]{bootstrapTenant$1.name});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn(new StringBuilder(64).append("Bootstrap tenant '").append(bootstrapTenant$1.name).append("' creation failed with an unexpected exception").toString(), new Object[]{commandFailure});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof TenantResponse) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Completed creation of bootstrap tenant '{}'", new Object[]{bootstrapTenant$1.name});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (object instanceof ModelResponse) {
            BoxedUnit boxedUnit;
            ModelResponse modelResponse = (ModelResponse)object;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(57).append("Unexpected response during creation of bootstrap tenant: ").append(modelResponse).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                throw throwable;
            }
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(65).append("Unexpected response during creation of bootstrap tenant, of type ").append(object.getClass().getName()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        }
    }

    private BootstrapPlatformConfiguration$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

