/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.api.projection.cases;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import org.cafienne.akka.actor.event.TransactionEvent;
import org.cafienne.akka.actor.identity.TenantUser;
import org.cafienne.akka.actor.serialization.json.JSONReader;
import org.cafienne.akka.actor.serialization.json.ValueMap;
import org.cafienne.cmmn.akka.event.CaseDefinitionApplied;
import org.cafienne.cmmn.akka.event.CaseEvent;
import org.cafienne.cmmn.akka.event.CaseModified;
import org.cafienne.cmmn.akka.event.file.BusinessIdentifierCleared;
import org.cafienne.cmmn.akka.event.file.BusinessIdentifierEvent;
import org.cafienne.cmmn.akka.event.file.BusinessIdentifierSet;
import org.cafienne.cmmn.akka.event.file.CaseFileEvent;
import org.cafienne.cmmn.akka.event.plan.PlanItemCreated;
import org.cafienne.cmmn.akka.event.plan.PlanItemEvent;
import org.cafienne.cmmn.akka.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.akka.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.akka.event.plan.RequiredRuleEvaluated;
import org.cafienne.cmmn.akka.event.team.CaseOwnerAdded;
import org.cafienne.cmmn.akka.event.team.CaseOwnerRemoved;
import org.cafienne.cmmn.akka.event.team.CaseTeamEvent;
import org.cafienne.cmmn.akka.event.team.CaseTeamMemberEvent;
import org.cafienne.cmmn.akka.event.team.DeprecatedCaseTeamEvent;
import org.cafienne.cmmn.akka.event.team.TeamMemberAdded;
import org.cafienne.cmmn.akka.event.team.TeamRoleCleared;
import org.cafienne.cmmn.akka.event.team.TeamRoleFilled;
import org.cafienne.humantask.akka.event.HumanTaskActivated;
import org.cafienne.humantask.akka.event.HumanTaskAssigned;
import org.cafienne.humantask.akka.event.HumanTaskCompleted;
import org.cafienne.humantask.akka.event.HumanTaskCreated;
import org.cafienne.humantask.akka.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.akka.event.HumanTaskEvent;
import org.cafienne.humantask.akka.event.HumanTaskInputSaved;
import org.cafienne.humantask.akka.event.HumanTaskOutputSaved;
import org.cafienne.humantask.akka.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.akka.event.HumanTaskTerminated;
import org.cafienne.humantask.akka.event.HumanTaskTransitioned;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.service.api.projection.RecordsPersistence;
import org.cafienne.service.api.projection.cases.CaseFileEventBuffer;
import org.cafienne.service.api.projection.cases.CaseFileMerger$;
import org.cafienne.service.api.projection.cases.CaseIdentifierMerger$;
import org.cafienne.service.api.projection.cases.CaseInstanceMerger$;
import org.cafienne.service.api.projection.cases.CaseInstanceRoleMerger$;
import org.cafienne.service.api.projection.cases.PlanItemHistoryMerger$;
import org.cafienne.service.api.projection.cases.PlanItemMerger$;
import org.cafienne.service.api.projection.cases.TaskMerger$;
import org.cafienne.service.api.projection.record.CaseBusinessIdentifierRecord;
import org.cafienne.service.api.projection.record.CaseDefinitionRecord;
import org.cafienne.service.api.projection.record.CaseFileRecord;
import org.cafienne.service.api.projection.record.CaseRecord;
import org.cafienne.service.api.projection.record.CaseRoleRecord;
import org.cafienne.service.api.projection.record.CaseTeamMemberRecord;
import org.cafienne.service.api.projection.record.PlanItemHistoryRecord;
import org.cafienne.service.api.projection.record.PlanItemRecord;
import org.cafienne.service.api.projection.record.TaskRecord;
import org.cafienne.service.api.projection.record.TaskRecord$;
import org.cafienne.service.api.projection.slick.SlickTransaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001\u0002\u00180\u0001qB\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tS\u0002\u0011\t\u0011)A\u0005=\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011b\u0001q\u0011!9\bA!A!\u0002\u0013\t\b\"\u0002=\u0001\t\u0003I\b\"CA\u0002\u0001\t\u0007I\u0011AA\u0003\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005\u001d\u0001\"CA\u0013\u0001\t\u0007I\u0011AA\u0014\u0011!\t)\u0004\u0001Q\u0001\n\u0005%\u0002\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005m\u0002\"CA#\u0001\t\u0007I\u0011AA$\u0011!\ti\u0006\u0001Q\u0001\n\u0005%\u0003\"CA0\u0001\t\u0007I\u0011AA1\u0011!\ty\u0007\u0001Q\u0001\n\u0005\r\u0004\"CA9\u0001\t\u0007I\u0011AA:\u0011!\ti\b\u0001Q\u0001\n\u0005U\u0004\"CA@\u0001\u0001\u0007I\u0011AAA\u0011%\ty\t\u0001a\u0001\n\u0003\t\t\n\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0015BAB\u0011%\ty\n\u0001a\u0001\n\u0003\t\t\u000bC\u0005\u0002*\u0002\u0001\r\u0011\"\u0001\u0002,\"A\u0011q\u0016\u0001!B\u0013\t\u0019\u000bC\u0005\u00022\u0002\u0001\r\u0011\"\u0001\u00024\"I\u0011Q\u001a\u0001A\u0002\u0013\u0005\u0011q\u001a\u0005\t\u0003'\u0004\u0001\u0015)\u0003\u00026\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007bBAw\u0001\u0011%\u0011q\u001e\u0005\b\u0003s\u0004A\u0011BA~\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001bAqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0005\u0003<\u0001\u0011\r\u0011\"\u0003\u0003>!A!Q\t\u0001!\u0002\u0013\u0011y\u0004C\u0004\u0003H\u0001!IA!\u0013\t\u000f\tM\u0003\u0001\"\u0003\u0003V!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqAa'\u0001\t\u0003\u0011i\nC\u0004\u0003(\u0002!\tA!+\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002Bk\u0001\u0011\u0005#q\u001b\u0002\u0010\u0007\u0006\u001cX\r\u0016:b]N\f7\r^5p]*\u0011\u0001'M\u0001\u0006G\u0006\u001cXm\u001d\u0006\u0003eM\n!\u0002\u001d:pU\u0016\u001cG/[8o\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000fM,'O^5dK*\u0011\u0001(O\u0001\tG\u00064\u0017.\u001a8oK*\t!(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001{\r\u001b\u0006C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g\rE\u0002E\u000f&k\u0011!\u0012\u0006\u0003\rF\nQa\u001d7jG.L!\u0001S#\u0003!Mc\u0017nY6Ue\u0006t7/Y2uS>t\u0007C\u0001&R\u001b\u0005Y%B\u0001'N\u0003\u0015)g/\u001a8u\u0015\tqu*\u0001\u0003bW.\f'B\u0001)8\u0003\u0011\u0019W.\u001c8\n\u0005I[%!C\"bg\u0016,e/\u001a8u!\t!6,D\u0001V\u0015\t1v+\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002Y3\u0006AA/\u001f9fg\u00064WMC\u0001[\u0003\r\u0019w.\\\u0005\u00039V\u00131\u0002T1{s2{wmZ5oO\u0006q1-Y:f\u0013:\u001cH/\u00198dK&#\u0007CA0g\u001d\t\u0001G\r\u0005\u0002b\u007f5\t!M\u0003\u0002dw\u00051AH]8pizJ!!Z \u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K~\na\u0001^3oC:$\u0018a\u00039feNL7\u000f^3oG\u0016\u0004\"\u0001\\7\u000e\u0003EJ!A\\\u0019\u0003%I+7m\u001c:egB+'o]5ti\u0016t7-Z\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i~\n!bY8oGV\u0014(/\u001a8u\u0013\t18O\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)\u0015Qhp`A\u0001)\tYX\u0010\u0005\u0002}\u00015\tq\u0006C\u0003p\r\u0001\u000f\u0011\u000fC\u0003^\r\u0001\u0007a\fC\u0003j\r\u0001\u0007a\fC\u0003k\r\u0001\u00071.A\u0005qY\u0006t\u0017\n^3ngV\u0011\u0011q\u0001\t\b\u0003\u0013\t\u0019BXA\f\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#y\u0014AC2pY2,7\r^5p]&!\u0011QCA\u0006\u0005\u001dA\u0015m\u001d5NCB\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\t\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0002\"\u0005m!A\u0004)mC:LE/Z7SK\u000e|'\u000fZ\u0001\u000ba2\fg.\u0013;f[N\u0004\u0013\u0001\u00059mC:LE/Z7t\u0011&\u001cHo\u001c:z+\t\tI\u0003\u0005\u0004\u0002\n\u0005-\u0012qF\u0005\u0005\u0003[\tYA\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u00033\t\t$\u0003\u0003\u00024\u0005m!!\u0006)mC:LE/Z7ISN$xN]=SK\u000e|'\u000fZ\u0001\u0012a2\fg.\u0013;f[ND\u0015n\u001d;pef\u0004\u0013!E2bg\u0016Len\u001d;b]\u000e,'k\u001c7fgV\u0011\u00111\b\t\b\u0003\u0013\t\u0019BXA\u001f!\u0011\tI\"a\u0010\n\t\u0005\u0005\u00131\u0004\u0002\u000f\u0007\u0006\u001cXMU8mKJ+7m\u001c:e\u0003I\u0019\u0017m]3J]N$\u0018M\\2f%>dWm\u001d\u0011\u0002/\r\f7/Z%ogR\fgnY3UK\u0006lW*Z7cKJ\u001cXCAA%!!\tI!a\u0005\u0002L\u0005]\u0003\u0003\u0003 \u0002Nys\u0016\u0011\u000b0\n\u0007\u0005=sH\u0001\u0004UkBdW\r\u000e\t\u0004}\u0005M\u0013bAA+\u007f\t9!i\\8mK\u0006t\u0007\u0003BA\r\u00033JA!a\u0017\u0002\u001c\t!2)Y:f)\u0016\fW.T3nE\u0016\u0014(+Z2pe\u0012\f\u0001dY1tK&s7\u000f^1oG\u0016$V-Y7NK6\u0014WM]:!\u0003M\u0011Wo]5oKN\u001c\u0018\nZ3oi&4\u0017.\u001a:t+\t\t\u0019\u0007\u0005\u0004\u0002\n\u0005\u0015\u0014\u0011N\u0005\u0005\u0003O\nYAA\u0002TKR\u0004B!!\u0007\u0002l%!\u0011QNA\u000e\u0005q\u0019\u0015m]3CkNLg.Z:t\u0013\u0012,g\u000e^5gS\u0016\u0014(+Z2pe\u0012\fACY;tS:,7o]%eK:$\u0018NZ5feN\u0004\u0013!\u0002;bg.\u001cXCAA;!\u001d\tI!a\u0005_\u0003o\u0002B!!\u0007\u0002z%!\u00111PA\u000e\u0005)!\u0016m]6SK\u000e|'\u000fZ\u0001\u0007i\u0006\u001c8n\u001d\u0011\u0002\u0019\r\f7/Z%ogR\fgnY3\u0016\u0005\u0005\r\u0005#\u0002 \u0002\u0006\u0006%\u0015bAAD\u007f\t1q\n\u001d;j_:\u0004B!!\u0007\u0002\f&!\u0011QRA\u000e\u0005)\u0019\u0015m]3SK\u000e|'\u000fZ\u0001\u0011G\u0006\u001cX-\u00138ti\u0006t7-Z0%KF$B!a%\u0002\u001aB\u0019a(!&\n\u0007\u0005]uH\u0001\u0003V]&$\b\"CAN)\u0005\u0005\t\u0019AAB\u0003\rAH%M\u0001\u000eG\u0006\u001cX-\u00138ti\u0006t7-\u001a\u0011\u0002\u001d\r\f7/\u001a#fM&t\u0017\u000e^5p]V\u0011\u00111\u0015\t\u0005\u00033\t)+\u0003\u0003\u0002(\u0006m!\u0001F\"bg\u0016$UMZ5oSRLwN\u001c*fG>\u0014H-\u0001\ndCN,G)\u001a4j]&$\u0018n\u001c8`I\u0015\fH\u0003BAJ\u0003[C\u0011\"a'\u0018\u0003\u0003\u0005\r!a)\u0002\u001f\r\f7/\u001a#fM&t\u0017\u000e^5p]\u0002\n\u0001bY1tK\u001aKG.Z\u000b\u0003\u0003k\u0003RAPAC\u0003o\u0003B!!/\u0002J6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003kg>t'\u0002BAa\u0003\u0007\fQb]3sS\u0006d\u0017N_1uS>t'\u0002BAc\u0003\u000f\fQ!Y2u_JT!AT\u001c\n\t\u0005-\u00171\u0018\u0002\t-\u0006dW/Z'ba\u0006a1-Y:f\r&dWm\u0018\u0013fcR!\u00111SAi\u0011%\tYJGA\u0001\u0002\u0004\t),A\u0005dCN,g)\u001b7fA\u0005Y\u0001.\u00198eY\u0016,e/\u001a8u)\u0011\tI.!;\u0011\u000bI\fY.a8\n\u0007\u0005u7O\u0001\u0004GkR,(/\u001a\t\u0005\u0003C\f)/\u0004\u0002\u0002d*\ta*\u0003\u0003\u0002h\u0006\r(\u0001\u0002#p]\u0016Da!a;\u001d\u0001\u0004I\u0015aA3wi\u0006\u00112M]3bi\u0016\u001c\u0015m]3J]N$\u0018M\\2f)\u0011\tI.!=\t\r1k\u0002\u0019AAz!\rQ\u0015Q_\u0005\u0004\u0003o\\%!F\"bg\u0016$UMZ5oSRLwN\\!qa2LW\rZ\u0001\u0014Q\u0006tG\r\\3QY\u0006t\u0017\n^3n\u000bZ,g\u000e\u001e\u000b\u0005\u00033\fi\u0010\u0003\u0004M=\u0001\u0007\u0011q \t\u0005\u0005\u0003\u00119!\u0004\u0002\u0003\u0004)\u0019!QA&\u0002\tAd\u0017M\\\u0005\u0005\u0005\u0013\u0011\u0019AA\u0007QY\u0006t\u0017\n^3n\u000bZ,g\u000e^\u0001\fO\u0016$\b\u000b\\1o\u0013R,W\u000e\u0006\u0005\u0003\u0010\tM!Q\u0003B\r!\u0015\u0011\u00181\u001cB\t!\u0015q\u0014QQA\f\u0011\u0015iv\u00041\u0001_\u0011\u0019\u00119b\ba\u0001=\u0006Q\u0001\u000f\\1o\u0013R,W.\u00133\t\u000f\tmq\u00041\u0001\u0003\u001e\u0005!Qo]3s!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0003\u0007\f\u0001\"\u001b3f]RLG/_\u0005\u0005\u0005O\u0011\tC\u0001\u0006UK:\fg\u000e^+tKJ\fQ\u0004[1oI2,')^:j]\u0016\u001c8/\u00133f]RLg-[3s\u000bZ,g\u000e\u001e\u000b\u0005\u00033\u0014i\u0003\u0003\u0004MA\u0001\u0007!q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!QG&\u0002\t\u0019LG.Z\u0005\u0005\u0005s\u0011\u0019DA\fCkNLg.Z:t\u0013\u0012,g\u000e^5gS\u0016\u0014XI^3oi\u00061\"-\u001e4gKJ,GmQ1tK\u001aKG.Z#wK:$8/\u0006\u0002\u0003@A\u0019AP!\u0011\n\u0007\t\rsFA\nDCN,g)\u001b7f\u000bZ,g\u000e\u001e\"vM\u001a,'/A\fck\u001a4WM]3e\u0007\u0006\u001cXMR5mK\u00163XM\u001c;tA\u0005\u0019\u0002.\u00198eY\u0016\u001c\u0015m]3GS2,WI^3oiR!\u0011\u0011\u001cB&\u0011\u0019a5\u00051\u0001\u0003NA!!\u0011\u0007B(\u0013\u0011\u0011\tFa\r\u0003\u001b\r\u000b7/\u001a$jY\u0016,e/\u001a8u\u0003-9W\r^\"bg\u00164\u0015\u000e\\3\u0015\r\t]#\u0011\fB.!\u0015\u0011\u00181\\A\\\u0011\u0015iF\u00051\u0001_\u0011\u001d\u0011Y\u0002\na\u0001\u0005;\t1\u0003[1oI2,7)Y:f)\u0016\fW.\u0012<f]R$B!!7\u0003b!1A*\na\u0001\u0005G\u0002BA!\u001a\u0003l5\u0011!q\r\u0006\u0004\u0005SZ\u0015\u0001\u0002;fC6LAA!\u001c\u0003h\ti1)Y:f)\u0016\fW.\u0012<f]R\f!#\u001e9eCR,7)Y:f\u0013:\u001cH/\u00198dKR!\u0011\u0011\u001cB:\u0011\u0019ae\u00051\u0001\u0003vA\u0019!Ja\u001e\n\u0007\te4J\u0001\u0007DCN,Wj\u001c3jM&,G-A\bhKR\u001c\u0015m]3J]N$\u0018M\\2f)\u0019\u0011yH!!\u0003\u0004B)!/a7\u0002\u0004\")Ql\na\u0001=\"9!1D\u0014A\u0002\tu\u0011AC2sK\u0006$X\rV1tWR!\u0011\u0011\u001cBE\u0011\u001d\tY\u000f\u000ba\u0001\u0005\u0017\u0003BA!$\u0003\u00186\u0011!q\u0012\u0006\u0004\u0019\nE%b\u0001(\u0003\u0014*\u0019!QS\u001c\u0002\u0013!,X.\u00198uCN\\\u0017\u0002\u0002BM\u0005\u001f\u0013!\u0003S;nC:$\u0016m]6BGRLg/\u0019;fI\u0006!B-\u001a9sK\u000e\fG/\u001a3De\u0016\fG/\u001a+bg.$B!!7\u0003 \"9\u00111^\u0015A\u0002\t\u0005\u0006\u0003\u0002BG\u0005GKAA!*\u0003\u0010\n\u0001\u0002*^7b]R\u000b7o[\"sK\u0006$X\rZ\u0001\u0015Q\u0006tG\r\\3Ik6\fg\u000eV1tW\u00163XM\u001c;\u0015\t\t-&1\u0017\t\u0006e\u0006m'Q\u0016\b\u0005\u0003C\u0014y+\u0003\u0003\u00032\u0006\r\u0018\u0001\u0002#p]\u0016Da\u0001\u0014\u0016A\u0002\tU\u0006\u0003\u0002BG\u0005oKAA!/\u0003\u0010\nq\u0001*^7b]R\u000b7o[#wK:$\u0018!\u00034fi\u000eDG+Y:l)\u0011\u0011yLa1\u0011\u000bI\fYN!1\u0011\u000by\n))a\u001e\t\r\t\u00157\u00061\u0001_\u0003\u0019!\u0018m]6JI\u0006qq-\u001a;OK^\u001c\u0015m]3GS2,G\u0003\u0002Bf\u0005#\u0004B!!\u0007\u0003N&!!qZA\u000e\u00059\u0019\u0015m]3GS2,'+Z2pe\u0012DqAa5-\u0001\u0004\t9,\u0001\ndCN,g)\u001b7f\u0013:\u0004&o\\4sKN\u001c\u0018AB2p[6LG\u000f\u0006\u0005\u0002Z\ne'Q\u001cBx\u0011\u0019\u0011Y.\fa\u0001=\u0006QqN\u001a4tKRt\u0015-\\3\t\u000f\t}W\u00061\u0001\u0003b\u00061qN\u001a4tKR\u0004BAa9\u0003l6\u0011!Q\u001d\u0006\u0005\u0005O\u0014I/A\u0003rk\u0016\u0014\u0018PC\u0002k\u0003GLAA!<\u0003f\n1qJ\u001a4tKRDqA!=.\u0001\u0004\u0011\u00190\u0001\u0007dCN,Wj\u001c3jM&,G\r\r\u0003\u0003v\u000e\r\u0001C\u0002B|\u0005w\u0014y0\u0004\u0002\u0003z*\u0019A*a1\n\t\tu(\u0011 \u0002\u0011)J\fgn]1di&|g.\u0012<f]R\u0004Ba!\u0001\u0004\u00041\u0001A\u0001DB\u0003\u0005_\f\t\u0011!A\u0003\u0002\r\u001d!aA0%cE!1\u0011BB\b!\rq41B\u0005\u0004\u0007\u001by$a\u0002(pi\"Lgn\u001a\t\u0004}\rE\u0011bAB\n\u007f\t\u0019\u0011I\\=")
public class CaseTransaction
implements SlickTransaction<CaseEvent>,
LazyLogging {
    private final String caseInstanceId;
    private final String tenant;
    private final RecordsPersistence persistence;
    private final ExecutionContext executionContext;
    private final HashMap<String, PlanItemRecord> planItems;
    private final Buffer<PlanItemHistoryRecord> planItemsHistory;
    private final HashMap<String, CaseRoleRecord> caseInstanceRoles;
    private final HashMap<Tuple4<String, String, Object, String>, CaseTeamMemberRecord> caseInstanceTeamMembers;
    private final Set<CaseBusinessIdentifierRecord> businessIdentifiers;
    private final HashMap<String, TaskRecord> tasks;
    private Option<CaseRecord> caseInstance;
    private CaseDefinitionRecord caseDefinition;
    private Option<ValueMap> caseFile;
    private final CaseFileEventBuffer bufferedCaseFileEvents;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseTransaction caseTransaction = this;
        synchronized (caseTransaction) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public HashMap<String, PlanItemRecord> planItems() {
        return this.planItems;
    }

    public Buffer<PlanItemHistoryRecord> planItemsHistory() {
        return this.planItemsHistory;
    }

    public HashMap<String, CaseRoleRecord> caseInstanceRoles() {
        return this.caseInstanceRoles;
    }

    public HashMap<Tuple4<String, String, Object, String>, CaseTeamMemberRecord> caseInstanceTeamMembers() {
        return this.caseInstanceTeamMembers;
    }

    public Set<CaseBusinessIdentifierRecord> businessIdentifiers() {
        return this.businessIdentifiers;
    }

    public HashMap<String, TaskRecord> tasks() {
        return this.tasks;
    }

    public Option<CaseRecord> caseInstance() {
        return this.caseInstance;
    }

    public void caseInstance_$eq(Option<CaseRecord> x$1) {
        this.caseInstance = x$1;
    }

    public CaseDefinitionRecord caseDefinition() {
        return this.caseDefinition;
    }

    public void caseDefinition_$eq(CaseDefinitionRecord x$1) {
        this.caseDefinition = x$1;
    }

    public Option<ValueMap> caseFile() {
        return this.caseFile;
    }

    public void caseFile_$eq(Option<ValueMap> x$1) {
        this.caseFile = x$1;
    }

    @Override
    public Future<Done> handleEvent(CaseEvent evt) {
        Future<Done> future;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(32).append("Handling event of type ").append(evt.getClass().getSimpleName()).append(" in case ").append(this.caseInstanceId).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        CaseEvent caseEvent = evt;
        if (caseEvent instanceof CaseDefinitionApplied) {
            CaseDefinitionApplied caseDefinitionApplied = (CaseDefinitionApplied)caseEvent;
            future = this.createCaseInstance(caseDefinitionApplied);
        } else if (caseEvent instanceof PlanItemEvent) {
            PlanItemEvent planItemEvent = (PlanItemEvent)caseEvent;
            future = this.handlePlanItemEvent(planItemEvent);
        } else if (caseEvent instanceof CaseFileEvent) {
            CaseFileEvent caseFileEvent = (CaseFileEvent)caseEvent;
            future = this.handleCaseFileEvent(caseFileEvent);
        } else if (caseEvent instanceof CaseTeamEvent) {
            CaseTeamEvent caseTeamEvent = (CaseTeamEvent)caseEvent;
            future = this.handleCaseTeamEvent(caseTeamEvent);
        } else if (caseEvent instanceof HumanTaskCreated) {
            HumanTaskCreated humanTaskCreated = (HumanTaskCreated)caseEvent;
            future = this.deprecatedCreateTask(humanTaskCreated);
        } else if (caseEvent instanceof HumanTaskActivated) {
            HumanTaskActivated humanTaskActivated = (HumanTaskActivated)caseEvent;
            future = this.createTask(humanTaskActivated);
        } else if (caseEvent instanceof HumanTaskEvent) {
            HumanTaskEvent humanTaskEvent = (HumanTaskEvent)caseEvent;
            future = this.handleHumanTaskEvent(humanTaskEvent);
        } else if (caseEvent instanceof CaseModified) {
            CaseModified caseModified = (CaseModified)caseEvent;
            future = this.updateCaseInstance(caseModified);
        } else if (caseEvent instanceof BusinessIdentifierEvent) {
            BusinessIdentifierEvent businessIdentifierEvent = (BusinessIdentifierEvent)caseEvent;
            future = this.handleBusinessIdentifierEvent(businessIdentifierEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> createCaseInstance(CaseDefinitionApplied event) {
        this.caseInstance_$eq((Option<CaseRecord>)new Some((Object)CaseInstanceMerger$.MODULE$.merge(event)));
        this.caseDefinition_$eq(new CaseDefinitionRecord(event.getActorId(), event.getCaseName(), event.getDefinition().documentation.text, event.getDefinition().getId(), event.getDefinition().getDefinitionsDocument().getSource(), event.tenant, event.createdOn, event.createdBy));
        this.caseFile_$eq((Option<ValueMap>)new Some((Object)new ValueMap()));
        CaseInstanceRoleMerger$.MODULE$.merge(event).map((Function1 & Serializable & scala.Serializable)role -> this.caseInstanceRoles().put((Object)role.roleName(), role), Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handlePlanItemEvent(PlanItemEvent event) {
        Future future;
        this.planItemsHistory().$plus$eq((Object)PlanItemHistoryMerger$.MODULE$.mapEventToHistory(event));
        PlanItemEvent planItemEvent = event;
        if (planItemEvent instanceof PlanItemCreated) {
            PlanItemCreated planItemCreated = (PlanItemCreated)planItemEvent;
            PlanItemRecord planItem = PlanItemMerger$.MODULE$.merge(planItemCreated);
            this.planItems().put((Object)planItem.id(), (Object)planItem);
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        } else if (planItemEvent != null) {
            PlanItemEvent planItemEvent2 = planItemEvent;
            future = this.getPlanItem(event.getCaseInstanceId(), event.getPlanItemId(), event.getUser()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Done$ done$;
                Option option = x0$1;
                if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    PlanItemRecord planItem = (PlanItemRecord)some.value();
                    PlanItemEvent planItemEvent = planItemEvent2;
                    if (planItemEvent instanceof PlanItemTransitioned) {
                        PlanItemTransitioned planItemTransitioned = (PlanItemTransitioned)planItemEvent;
                        option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemTransitioned, planItem));
                    } else if (planItemEvent instanceof RepetitionRuleEvaluated) {
                        RepetitionRuleEvaluated repetitionRuleEvaluated = (RepetitionRuleEvaluated)planItemEvent;
                        option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(repetitionRuleEvaluated, planItem));
                    } else if (planItemEvent instanceof RequiredRuleEvaluated) {
                        RequiredRuleEvaluated requiredRuleEvaluated = (RequiredRuleEvaluated)planItemEvent;
                        option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(requiredRuleEvaluated, planItem));
                    } else {
                        throw new MatchError((Object)planItemEvent);
                    }
                    done$ = Done$.MODULE$;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(53).append("Expected PlanItem ").append(event.getPlanItemId()).append(" in ").append(event.getCaseInstanceId()).append(", but not found in the database").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    done$ = Done$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return done$;
            }, this.executionContext());
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(105).append("Apparently we have a new type of PlanItemEvent that is not being handled by this Projection. The type is ").append(planItemEvent.getClass().getName()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Option<PlanItemRecord>> getPlanItem(String caseInstanceId, String planItemId, TenantUser user) {
        Future future;
        Option option = this.planItems().get((Object)planItemId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            PlanItemRecord value = (PlanItemRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved planitem caseinstanceid={} id={} from current transaction cache", (Object[])new String[]{caseInstanceId, planItemId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)new Some((Object)value));
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(34).append("Retrieving planitem ").append(planItemId).append(" from database").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getPlanItem(planItemId);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<Done> handleBusinessIdentifierEvent(BusinessIdentifierEvent event) {
        boolean bl;
        BusinessIdentifierEvent businessIdentifierEvent = event;
        if (businessIdentifierEvent instanceof BusinessIdentifierSet) {
            BusinessIdentifierSet businessIdentifierSet = (BusinessIdentifierSet)businessIdentifierEvent;
            bl = this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierSet));
        } else if (businessIdentifierEvent instanceof BusinessIdentifierCleared) {
            BusinessIdentifierCleared businessIdentifierCleared = (BusinessIdentifierCleared)businessIdentifierEvent;
            bl = this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierCleared));
        } else {
            throw new MatchError((Object)businessIdentifierEvent);
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private CaseFileEventBuffer bufferedCaseFileEvents() {
        return this.bufferedCaseFileEvents;
    }

    private Future<Done> handleCaseFileEvent(CaseFileEvent event) {
        this.bufferedCaseFileEvents().addEvent(event);
        return this.getCaseFile(event.getCaseInstanceId(), event.getUser()).map((Function1 & Serializable & scala.Serializable)data -> {
            this.caseFile_$eq((Option<ValueMap>)new Some(data));
            return Done$.MODULE$;
        }, this.executionContext());
    }

    private Future<ValueMap> getCaseFile(String caseInstanceId, TenantUser user) {
        Future future;
        Option<ValueMap> option = this.caseFile();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ValueMap value = (ValueMap)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved casefile caseinstanceid={} from current transaction cache", new Object[]{caseInstanceId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieving casefile caseInstanceId={} from database", new Object[]{caseInstanceId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getCaseFile(caseInstanceId).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ValueMap valueMap;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CaseFileRecord casefile = (CaseFileRecord)some.value();
                    valueMap = (ValueMap)JSONReader.parse((String)casefile.data());
                } else if (None$.MODULE$.equals(option)) {
                    valueMap = new ValueMap();
                } else {
                    throw new MatchError((Object)option);
                }
                return valueMap;
            }, this.executionContext());
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Future<Done> handleCaseTeamEvent(CaseTeamEvent event) {
        Object object;
        CaseTeamEvent caseTeamEvent = event;
        if (caseTeamEvent instanceof DeprecatedCaseTeamEvent) {
            DeprecatedCaseTeamEvent deprecatedCaseTeamEvent = (DeprecatedCaseTeamEvent)caseTeamEvent;
            Set roles = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(deprecatedCaseTeamEvent.getRoles()).asScala()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})));
            boolean enabled = deprecatedCaseTeamEvent instanceof TeamMemberAdded;
            object = roles.map((Function1 & Serializable & scala.Serializable)role -> {
                Tuple4 key = new Tuple4((Object)deprecatedCaseTeamEvent.getActorId(), (Object)deprecatedCaseTeamEvent.getUserId(), (Object)BoxesRunTime.boxToBoolean((boolean)true), role);
                CaseTeamMemberRecord record = new CaseTeamMemberRecord(deprecatedCaseTeamEvent.getActorId(), $this.tenant, deprecatedCaseTeamEvent.getUserId(), (String)role, true, enabled, enabled);
                return this.caseInstanceTeamMembers().put((Object)key, (Object)record);
            }, Set$.MODULE$.canBuildFrom());
        } else if (caseTeamEvent instanceof CaseTeamMemberEvent) {
            Option option;
            CaseTeamMemberEvent caseTeamMemberEvent = (CaseTeamMemberEvent)caseTeamEvent;
            Tuple4 key = new Tuple4((Object)caseTeamMemberEvent.getActorId(), (Object)caseTeamMemberEvent.memberId, (Object)BoxesRunTime.boxToBoolean((boolean)caseTeamMemberEvent.isTenantUser), (Object)caseTeamMemberEvent.roleName());
            CaseTeamMemberRecord member = (CaseTeamMemberRecord)this.caseInstanceTeamMembers().getOrElseUpdate((Object)key, (Function0 & Serializable & scala.Serializable)() -> {
                String x$1 = caseTeamMemberEvent.getActorId();
                String x$2 = $this.tenant;
                String x$3 = caseTeamMemberEvent.roleName();
                boolean x$4 = x3$2.isTenantUser;
                String x$5 = x3$2.memberId;
                boolean x$6 = false;
                boolean x$7 = true;
                return new CaseTeamMemberRecord(x$1, x$2, x$5, x$3, x$4, x$6, x$7);
            });
            CaseTeamMemberEvent caseTeamMemberEvent2 = caseTeamMemberEvent;
            if (caseTeamMemberEvent2 instanceof TeamRoleFilled) {
                boolean x$8 = true;
                String x$9 = member.copy$default$1();
                String x$10 = member.copy$default$2();
                String x$11 = member.copy$default$3();
                String x$12 = member.copy$default$4();
                boolean x$13 = member.copy$default$5();
                boolean x$14 = member.copy$default$6();
                option = this.caseInstanceTeamMembers().put((Object)key, (Object)member.copy(x$9, x$10, x$11, x$12, x$13, x$14, x$8));
            } else if (caseTeamMemberEvent2 instanceof TeamRoleCleared) {
                boolean x$15 = false;
                String x$16 = member.copy$default$1();
                String x$17 = member.copy$default$2();
                String x$18 = member.copy$default$3();
                String x$19 = member.copy$default$4();
                boolean x$20 = member.copy$default$5();
                boolean x$21 = member.copy$default$6();
                option = this.caseInstanceTeamMembers().put((Object)key, (Object)member.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$15));
            } else if (caseTeamMemberEvent2 instanceof CaseOwnerAdded) {
                boolean x$22 = true;
                String x$23 = member.copy$default$1();
                String x$24 = member.copy$default$2();
                String x$25 = member.copy$default$3();
                String x$26 = member.copy$default$4();
                boolean x$27 = member.copy$default$5();
                boolean x$28 = member.copy$default$7();
                option = this.caseInstanceTeamMembers().put((Object)key, (Object)member.copy(x$23, x$24, x$25, x$26, x$27, x$22, x$28));
            } else if (caseTeamMemberEvent2 instanceof CaseOwnerRemoved) {
                boolean x$29 = false;
                String x$30 = member.copy$default$1();
                String x$31 = member.copy$default$2();
                String x$32 = member.copy$default$3();
                String x$33 = member.copy$default$4();
                boolean x$34 = member.copy$default$5();
                boolean x$35 = member.copy$default$7();
                option = this.caseInstanceTeamMembers().put((Object)key, (Object)member.copy(x$30, x$31, x$32, x$33, x$34, x$29, x$35));
            } else {
                throw new MatchError((Object)caseTeamMemberEvent2);
            }
            object = option;
        } else {
            throw new MatchError((Object)caseTeamEvent);
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> updateCaseInstance(CaseModified event) {
        return this.getCaseInstance(event.getCaseInstanceId(), event.getUser()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Done$ done$;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                CaseRecord value = (CaseRecord)some.value();
                this.caseInstance_$eq((Option<CaseRecord>)new Some((Object)CaseInstanceMerger$.MODULE$.merge(event, value)));
                done$ = Done$.MODULE$;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(51).append("Expected CaseInstance ").append(event.getCaseInstanceId()).append(" but not found. CM Event:\n\n").append(event.toString()).append("\n\n").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                done$ = Done$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            return done$;
        }, this.executionContext());
    }

    private Future<Option<CaseRecord>> getCaseInstance(String caseInstanceId, TenantUser user) {
        Future future;
        Option<CaseRecord> option = this.caseInstance();
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieving caseinstance caseInstanceId={} from database", new Object[]{caseInstanceId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getCaseInstance(caseInstanceId);
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CaseRecord value = (CaseRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved caseinstance caseinstanceid={} from current transaction cache", new Object[]{caseInstanceId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)new Some((Object)value));
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public Future<Done> createTask(HumanTaskActivated evt) {
        TaskRecord taskRecord;
        Option option = this.tasks().get((Object)evt.taskId);
        if (None$.MODULE$.equals(option)) {
            String x$1 = evt.taskId;
            String x$2 = evt.getActorId();
            String x$3 = evt.tenant;
            String x$4 = evt.getTaskName();
            Instant x$5 = evt.getCreatedOn();
            String x$6 = evt.getCreatedBy();
            Instant x$7 = evt.getCreatedOn();
            String x$8 = evt.getCreatedBy();
            String x$9 = evt.getPerformer();
            String x$10 = evt.getCurrentState().name();
            String x$11 = evt.getTaskModel().toString();
            String x$12 = TaskRecord$.MODULE$.apply$default$7();
            String x$13 = TaskRecord$.MODULE$.apply$default$8();
            Option<Instant> x$14 = TaskRecord$.MODULE$.apply$default$9();
            String x$15 = TaskRecord$.MODULE$.apply$default$14();
            String x$16 = TaskRecord$.MODULE$.apply$default$15();
            taskRecord = new TaskRecord(x$1, x$2, x$3, x$4, x$10, x$9, x$12, x$13, x$14, x$5, x$6, x$7, x$8, x$15, x$16, x$11);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            String x$17 = evt.getPerformer();
            String x$18 = evt.getTaskModel().toString();
            String x$19 = evt.getCurrentState().name();
            String x$20 = task.copy$default$1();
            String x$21 = task.copy$default$2();
            String x$22 = task.copy$default$3();
            String x$23 = task.copy$default$4();
            String x$24 = task.copy$default$7();
            String x$25 = task.copy$default$8();
            Option<Instant> x$26 = task.copy$default$9();
            Instant x$27 = task.copy$default$10();
            String x$28 = task.copy$default$11();
            Instant x$29 = task.copy$default$12();
            String x$30 = task.copy$default$13();
            String x$31 = task.copy$default$14();
            String x$32 = task.copy$default$15();
            taskRecord = task.copy(x$20, x$21, x$22, x$23, x$19, x$17, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$18);
        } else {
            throw new MatchError((Object)option);
        }
        TaskRecord updatedTask = taskRecord;
        this.tasks().put((Object)evt.taskId, (Object)updatedTask);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public Future<Done> deprecatedCreateTask(HumanTaskCreated evt) {
        String x$1 = evt.taskId;
        String x$2 = evt.getActorId();
        String x$3 = evt.tenant;
        String x$4 = evt.getTaskName();
        Instant x$5 = evt.getCreatedOn();
        String x$6 = evt.getCreatedBy();
        Instant x$7 = evt.getCreatedOn();
        String x$8 = evt.getCreatedBy();
        String x$9 = TaskRecord$.MODULE$.apply$default$5();
        String x$10 = TaskRecord$.MODULE$.apply$default$6();
        String x$11 = TaskRecord$.MODULE$.apply$default$7();
        String x$12 = TaskRecord$.MODULE$.apply$default$8();
        Option<Instant> x$13 = TaskRecord$.MODULE$.apply$default$9();
        String x$14 = TaskRecord$.MODULE$.apply$default$14();
        String x$15 = TaskRecord$.MODULE$.apply$default$15();
        String x$16 = TaskRecord$.MODULE$.apply$default$16();
        this.tasks().put((Object)evt.taskId, (Object)new TaskRecord(x$1, x$2, x$3, x$4, x$9, x$10, x$11, x$12, x$13, x$5, x$6, x$7, x$8, x$14, x$15, x$16));
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public Future<Done$> handleHumanTaskEvent(HumanTaskEvent event) {
        Future future;
        HumanTaskEvent humanTaskEvent = event;
        if (humanTaskEvent instanceof HumanTaskInputSaved) {
            HumanTaskInputSaved humanTaskInputSaved = (HumanTaskInputSaved)humanTaskEvent;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable & scala.Serializable)t -> t.map((Function1 & Serializable & scala.Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskInputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent instanceof HumanTaskOutputSaved) {
            HumanTaskOutputSaved humanTaskOutputSaved = (HumanTaskOutputSaved)humanTaskEvent;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable & scala.Serializable)t -> t.map((Function1 & Serializable & scala.Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOutputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent instanceof HumanTaskOwnerChanged) {
            HumanTaskOwnerChanged humanTaskOwnerChanged = (HumanTaskOwnerChanged)humanTaskEvent;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable & scala.Serializable)t -> t.map((Function1 & Serializable & scala.Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOwnerChanged, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent instanceof HumanTaskDueDateFilled) {
            HumanTaskDueDateFilled humanTaskDueDateFilled = (HumanTaskDueDateFilled)humanTaskEvent;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable & scala.Serializable)t -> t.map((Function1 & Serializable & scala.Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskDueDateFilled, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent instanceof HumanTaskTransitioned) {
            HumanTaskTransitioned humanTaskTransitioned = (HumanTaskTransitioned)humanTaskEvent;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable & scala.Serializable)task -> task.map((Function1 & Serializable & scala.Serializable)t -> {
                TaskRecord taskRecord;
                TaskRecord copy = TaskMerger$.MODULE$.apply(humanTaskTransitioned, (TaskRecord)t);
                HumanTaskTransitioned humanTaskTransitioned = humanTaskTransitioned;
                if (humanTaskTransitioned instanceof HumanTaskAssigned) {
                    HumanTaskAssigned humanTaskAssigned = (HumanTaskAssigned)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskAssigned, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskActivated) {
                    HumanTaskActivated humanTaskActivated = (HumanTaskActivated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskActivated, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskCompleted) {
                    HumanTaskCompleted humanTaskCompleted = (HumanTaskCompleted)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskCompleted, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskTerminated) {
                    HumanTaskTerminated humanTaskTerminated = (HumanTaskTerminated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskTerminated, copy);
                } else {
                    System.err.println(new StringBuilder(51).append("We missed out on HumanTaskTransition event of type ").append(humanTaskTransitioned.getClass().getName()).toString());
                    taskRecord = copy;
                }
                return taskRecord;
            }), this.executionContext());
        } else {
            throw new MatchError((Object)humanTaskEvent);
        }
        Future fTask = future;
        return fTask.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskRecord task = (TaskRecord)some.value();
                boxedUnit = this.tasks().put((Object)task.id(), (Object)task);
            } else {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(104).append("Could not find task with id ").append(event$3.taskId).append(" in the current database. This may lead to problems. Ignoring event of type ").append(event.getClass().getName()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        }, this.executionContext()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Future$.MODULE$.successful((Object)Done$.MODULE$), this.executionContext());
    }

    private Future<Option<TaskRecord>> fetchTask(String taskId) {
        Future future;
        Option option = this.tasks().get((Object)taskId);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(30).append("Retrieving task ").append(taskId).append(" from database").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getTask(taskId);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            future = Future$.MODULE$.successful((Object)new Some((Object)task));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private CaseFileRecord getNewCaseFile(ValueMap caseFileInProgress) {
        this.bufferedCaseFileEvents().events().forEach(event -> CaseFileMerger$.MODULE$.merge((CaseFileEvent)event, caseFileInProgress));
        return new CaseFileRecord(this.caseInstanceId, this.tenant, caseFileInProgress.toString());
    }

    @Override
    public Future<Done> commit(String offsetName, Offset offset, TransactionEvent<?> caseModified) {
        ObjectRef records = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.empty()));
        this.caseInstance().foreach((Function1 & Serializable & scala.Serializable)instance -> ((ListBuffer)records$1.elem).$plus$eq(instance));
        ((ListBuffer)records.elem).$plus$eq((Object)this.caseDefinition());
        this.caseFile().foreach((Function1 & Serializable & scala.Serializable)caseFile -> ((ListBuffer)records$1.elem).$plus$eq((Object)this.getNewCaseFile((ValueMap)caseFile)));
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.planItems().values().map((Function1 & Serializable & scala.Serializable)item -> PlanItemMerger$.MODULE$.merge(caseModified, (PlanItemRecord)item), Iterable$.MODULE$.canBuildFrom()));
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.planItemsHistory().map((Function1 & Serializable & scala.Serializable)item -> PlanItemHistoryMerger$.MODULE$.merge(caseModified, (PlanItemHistoryRecord)item), Buffer$.MODULE$.canBuildFrom()));
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.caseInstanceRoles().values());
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.caseInstanceTeamMembers().values());
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.businessIdentifiers().toSeq());
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.tasks().values().map((Function1 & Serializable & scala.Serializable)current -> TaskMerger$.MODULE$.apply(caseModified, (TaskRecord)current), Iterable$.MODULE$.canBuildFrom()));
        ((ListBuffer)records.elem).$plus$eq((Object)OffsetRecord$.MODULE$.apply(offsetName, offset));
        return this.persistence.bulkUpdate((Seq<Object>)((Seq)((ListBuffer)records.elem).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)CaseTransaction.$anonfun$commit$6(r)))));
    }

    public static final /* synthetic */ boolean $anonfun$commit$6(Object r) {
        return r != null;
    }

    public CaseTransaction(String caseInstanceId, String tenant, RecordsPersistence persistence, ExecutionContext executionContext) {
        this.caseInstanceId = caseInstanceId;
        this.tenant = tenant;
        this.persistence = persistence;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.planItems = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.planItemsHistory = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.caseInstanceRoles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.caseInstanceTeamMembers = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.businessIdentifiers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tasks = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.caseInstance = None$.MODULE$;
        this.caseDefinition = null;
        this.caseFile = None$.MODULE$;
        this.bufferedCaseFileEvents = new CaseFileEventBuffer();
    }
}

