/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.api.projection.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.cafienne.akka.actor.identity.PlatformUser;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.infrastructure.jdbc.query.Area;
import org.cafienne.infrastructure.jdbc.query.Sort;
import org.cafienne.service.api.projection.CaseSearchFailure;
import org.cafienne.service.api.projection.TaskSearchFailure;
import org.cafienne.service.api.projection.query.BaseQueryImpl;
import org.cafienne.service.api.projection.query.BaseQueryImpl$FieldFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$JoinedNotFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$NoFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$NotFieldFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$NotValueFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$OrFilter$;
import org.cafienne.service.api.projection.query.BaseQueryImpl$ValueFilter$;
import org.cafienne.service.api.projection.query.TaskCount;
import org.cafienne.service.api.projection.query.TaskFilter;
import org.cafienne.service.api.projection.query.TaskQueries;
import org.cafienne.service.api.projection.record.CaseBusinessIdentifierRecord;
import org.cafienne.service.api.projection.record.CaseTeamMemberRecord;
import org.cafienne.service.api.projection.record.TaskRecord;
import org.cafienne.service.api.projection.record.UserRoleRecord;
import org.cafienne.service.api.projection.table.CaseTables;
import org.cafienne.service.api.projection.table.TaskTables;
import org.cafienne.service.api.projection.table.TenantTables;
import org.cafienne.service.db.querydb.QueryDBSchema;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.ast.TypedType$;
import slick.basic.DatabaseConfig;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionColumnExtensionMethods;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\b\u0010\u0001qAQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013\u0005a\u0006\u0003\u0004@\u0001\u0001\u0006Ia\f\u0005\u0006\u0001\u0002!\t%\u0011\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0002\u0010)\u0006\u001c8.U;fe&,7/S7qY*\u0011\u0001#E\u0001\u0006cV,'/\u001f\u0006\u0003%M\t!\u0002\u001d:pU\u0016\u001cG/[8o\u0015\t!R#A\u0002ba&T!AF\f\u0002\u000fM,'O^5dK*\u0011\u0001$G\u0001\tG\u00064\u0017.\u001a8oK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001;\r:\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%K5\tq\"\u0003\u0002'\u001f\tYA+Y:l#V,'/[3t!\t!\u0003&\u0003\u0002*\u001f\ti!)Y:f#V,'/_%na2\fa\u0001P5oSRtD#\u0001\u0017\u0011\u0005\u0011\u0002\u0011A\u0003;bg.\u001c\u0018+^3ssV\tq\u0006E\u00021k]j\u0011!\r\u0006\u0003eM\na\u0001\\5gi\u0016$'\"\u0001\u001b\u0002\u000bMd\u0017nY6\n\u0005Y\n$A\u0003+bE2,\u0017+^3ssB\u0011\u0001(O\u0007\u0002\u0001%\u0011!h\u000f\u0002\n)\u0006\u001c8\u000eV1cY\u0016L!\u0001P\u001f\u0003\u0015Q\u000b7o\u001b+bE2,7O\u0003\u0002?#\u0005)A/\u00192mK\u0006YA/Y:lgF+XM]=!\u0003\u001d9W\r\u001e+bg.$2A\u0011(\\!\r\u0019e\tS\u0007\u0002\t*\u0011QiH\u0001\u000bG>t7-\u001e:sK:$\u0018BA$E\u0005\u00191U\u000f^;sKB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*E\u0001\u0007e\u0016\u001cwN\u001d3\n\u00055S%A\u0003+bg.\u0014VmY8sI\")q\n\u0002a\u0001!\u00061A/Y:l\u0013\u0012\u0004\"!\u0015-\u000f\u0005I3\u0006CA* \u001b\u0005!&BA+\u001c\u0003\u0019a$o\\8u}%\u0011qkH\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002X?!)A\f\u0002a\u0001;\u0006!Qo]3s!\tqV-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005jI\u0016tG/\u001b;z\u0015\t\u00117-A\u0003bGR|'O\u0003\u0002e/\u0005!\u0011m[6b\u0013\t1wL\u0001\u0007QY\u0006$hm\u001c:n+N,'/\u0001\u000bhKR$\u0016m]6t/&$\bnQ1tK:\u000bW.\u001a\u000b\u0005SN,(\u0010E\u0002D\r*\u00042a\u001b9I\u001d\tagN\u0004\u0002T[&\t\u0001%\u0003\u0002p?\u00059\u0001/Y2lC\u001e,\u0017BA9s\u0005\r\u0019V-\u001d\u0006\u0003_~AQ\u0001^\u0003A\u0002A\u000b\u0001bY1tK:\u000bW.\u001a\u0005\u0006m\u0016\u0001\ra^\u0001\u0007i\u0016t\u0017M\u001c;\u0011\u0007yA\b+\u0003\u0002z?\t1q\n\u001d;j_:DQ\u0001X\u0003A\u0002u\u000bAbZ3u\u0007\u0006\u001cX\rV1tWN$2![?\u0000\u0011\u0015qh\u00011\u0001Q\u00039\u0019\u0017m]3J]N$\u0018M\\2f\u0013\u0012DQ\u0001\u0018\u0004A\u0002u\u000b!D\u00197b].LE-\u001a8uS\u001aLWM\u001d$jYR,'/U;fef$B!!\u0002\u0002 AA\u0001'a\u00028\u0003\u0017\ti\"C\u0002\u0002\nE\u0012Q!U;fef\u00042aNA\u0007\u0013\u0011\ty!!\u0005\u0003!Q\u000b'\r\\3FY\u0016lWM\u001c;UsB,\u0017\u0002BA\n\u0003+\u0011Q\u0001V1cY\u0016LA!a\u0006\u0002\u001a\tA\"+\u001a7bi&|g.\u00197UC\ndWmQ8na>tWM\u001c;\u000b\u0007\u0005m1'\u0001\u0006sK2\fG/[8oC2\u0004\"a\u001b9\t\ry<\u0001\u0019AA\u0011!\u0015\t\u0019#a\u0014Q\u001d\u0011\t)#!\u0012\u000f\t\u0005\u001d\u0012\u0011\b\b\u0004q\u0005%\u0012\u0002BA\u0016\u0003[\t\u0001\u0002\u001a2D_:4\u0017nZ\u0005\u0005\u0003_\t\tDA\u0007Rk\u0016\u0014\u0018\u0010\u0012\"TG\",W.\u0019\u0006\u0005\u0003g\t)$A\u0004rk\u0016\u0014\u0018\u0010\u001a2\u000b\u0007\u0005]R#\u0001\u0002eE&!\u00111HA\u001f\u0003\u001d\u0001(o\u001c4jY\u0016LA!a\u0010\u0002B\tqA)\u0019;bE\u0006\u001cXmQ8oM&<'bAA\"g\u0005)!-Y:jG&\u0019A#a\u0012\n\t\u0005%\u00131\n\u0002\f\u0015\u0012\u00147\r\u0015:pM&dWMC\u0002\u0002NM\nAA\u001b3cG&!\u0011\u0011KA*\u0005\r\u0011V\r]\u0005\u0004\u0003+\n$aB!mS\u0006\u001cXm]\u0001,CV$\bn\u001c:ju\u0016$\u0016m]6BG\u000e,7o]!oIJ+G/\u001e:o\u0007\u0006\u001cX-\u00118e)\u0016t\u0017M\u001c;JIR1\u00111LA2\u0003K\u0002Ba\u0011$\u0002^A)a$a\u0018Q!&\u0019\u0011\u0011M\u0010\u0003\rQ+\b\u000f\\33\u0011\u0015y\u0005\u00021\u0001Q\u0011\u0015a\u0006\u00021\u0001^\u0003-9W\r^!mYR\u000b7o[:\u0015\u0013%\fY'!\u001c\u0002x\u0005-\u0005\"\u0002/\n\u0001\u0004i\u0006\"CA8\u0013A\u0005\t\u0019AA9\u0003\u00191\u0017\u000e\u001c;feB\u0019A%a\u001d\n\u0007\u0005UtB\u0001\u0006UCN\\g)\u001b7uKJD\u0011\"!\u001f\n!\u0003\u0005\r!a\u001f\u0002\t\u0005\u0014X-\u0019\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)\u0019\u0001#!!\u000b\t\u00055\u00131\u0011\u0006\u0004\u0003\u000b;\u0012AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u0005\u0003\u0013\u000byH\u0001\u0003Be\u0016\f\u0007\"CAG\u0013A\u0005\t\u0019AAH\u0003\u0011\u0019xN\u001d;\u0011\t\u0005u\u0014\u0011S\u0005\u0005\u0003'\u000byH\u0001\u0003T_J$\u0018\u0001D4fiN#\u0018M\u001d;ECR,GCBAM\u0003W\u000by\u000b\u0005\u0003\u001fq\u0006m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005i&lWM\u0003\u0002\u0002&\u0006!!.\u0019<b\u0013\u0011\tI+a(\u0003\u000f%s7\u000f^1oi\"1\u0011Q\u0016\u0006A\u0002A\u000bA\u0001Z1uK\"1\u0011\u0011\u0017\u0006A\u0002]\f\u0001\u0002^5nKj{g.Z\u0001\u0012O\u0016$H+[7f5>tWm\u00144gg\u0016$H\u0003BA\\\u0003{\u0003B!!(\u0002:&!\u00111XAP\u0005)QvN\\3PM\u001a\u001cX\r\u001e\u0005\u0007\u0003c[\u0001\u0019A<\u0002\u0015\u001d,G/\u00128e\t\u0006$X\r\u0006\u0004\u0002\u001a\u0006\r\u0017Q\u0019\u0005\u0007\u0003[c\u0001\u0019\u0001)\t\r\u0005EF\u00021\u0001x\u0003=9W\r^\"pk:$hi\u001c:Vg\u0016\u0014HCBAf\u0003'\f)\u000e\u0005\u0003D\r\u00065\u0007c\u0001\u0013\u0002P&\u0019\u0011\u0011[\b\u0003\u0013Q\u000b7o[\"pk:$\b\"\u0002/\u000e\u0001\u0004i\u0006\"\u0002<\u000e\u0001\u00049\b")
public class TaskQueriesImpl
implements TaskQueries,
BaseQueryImpl {
    private final TableQuery<TaskTables.TaskTable> tasksQuery;
    private final ExecutionContext ec;
    private final TableQuery<CaseTables.CaseInstanceTable> caseInstanceQuery;
    private final TableQuery<CaseTables.CaseInstanceDefinitionTable> caseDefinitionQuery;
    private final TableQuery<CaseTables.CaseFileTable> caseFileQuery;
    private final TableQuery<CaseTables.PlanItemTable> planItemTableQuery;
    private final TableQuery<TaskTables.TaskTable> taskQuery;
    private final TableQuery<CaseTables.CaseInstanceRoleTable> caseInstanceRoleQuery;
    private final TableQuery<CaseTables.CaseInstanceTeamMemberTable> caseInstanceTeamMemberQuery;
    private final TableQuery<TenantTables.UserRoleTable> rolesQuery;
    private volatile BaseQueryImpl$NotValueFilter$ NotValueFilter$module;
    private volatile BaseQueryImpl$ValueFilter$ ValueFilter$module;
    private volatile BaseQueryImpl$NoFilter$ NoFilter$module;
    private volatile BaseQueryImpl$NotFieldFilter$ NotFieldFilter$module;
    private volatile BaseQueryImpl$FieldFilter$ FieldFilter$module;
    private volatile BaseQueryImpl$JoinedNotFilter$ JoinedNotFilter$module;
    private volatile BaseQueryImpl$OrFilter$ OrFilter$module;
    private transient Logger logger;
    private DatabaseConfig<JdbcProfile> dbConfig;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Query<Tuple2<TenantTables.UserRoleTable, CaseTables.CaseInstanceTeamMemberTable>, Tuple2<UserRoleRecord, CaseTeamMemberRecord>, Seq> membershipQuery(PlatformUser user, Rep<String> caseInstanceId, Rep<String> tenant, Option<String> identifiers) {
        return BaseQueryImpl.membershipQuery$(this, user, caseInstanceId, tenant, identifiers);
    }

    @Override
    public Query<CaseTables.CaseBusinessIdentifierTable, CaseBusinessIdentifierRecord, Seq> addBusinessIdentifiersFilter(Option<String> filterString, Rep<String> caseInstanceId) {
        return BaseQueryImpl.addBusinessIdentifiersFilter$(this, filterString, caseInstanceId);
    }

    public <T extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<T, E> QueryHelper(Query<T, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$((CafienneJDBCConfig)this, query);
    }

    @Override
    public TaskFilter getAllTasks$default$2() {
        return TaskQueries.getAllTasks$default$2$(this);
    }

    @Override
    public Area getAllTasks$default$3() {
        return TaskQueries.getAllTasks$default$3$(this);
    }

    @Override
    public Sort getAllTasks$default$4() {
        return TaskQueries.getAllTasks$default$4$(this);
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceTable> caseInstanceQuery() {
        return this.caseInstanceQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceDefinitionTable> caseDefinitionQuery() {
        return this.caseDefinitionQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseFileTable> caseFileQuery() {
        return this.caseFileQuery;
    }

    @Override
    public TableQuery<CaseTables.PlanItemTable> planItemTableQuery() {
        return this.planItemTableQuery;
    }

    @Override
    public TableQuery<TaskTables.TaskTable> taskQuery() {
        return this.taskQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceRoleTable> caseInstanceRoleQuery() {
        return this.caseInstanceRoleQuery;
    }

    @Override
    public TableQuery<CaseTables.CaseInstanceTeamMemberTable> caseInstanceTeamMemberQuery() {
        return this.caseInstanceTeamMemberQuery;
    }

    @Override
    public TableQuery<TenantTables.UserRoleTable> rolesQuery() {
        return this.rolesQuery;
    }

    @Override
    public BaseQueryImpl$NotValueFilter$ NotValueFilter() {
        if (this.NotValueFilter$module == null) {
            this.NotValueFilter$lzycompute$1();
        }
        return this.NotValueFilter$module;
    }

    @Override
    public BaseQueryImpl$ValueFilter$ ValueFilter() {
        if (this.ValueFilter$module == null) {
            this.ValueFilter$lzycompute$1();
        }
        return this.ValueFilter$module;
    }

    @Override
    public BaseQueryImpl$NoFilter$ NoFilter() {
        if (this.NoFilter$module == null) {
            this.NoFilter$lzycompute$1();
        }
        return this.NoFilter$module;
    }

    @Override
    public BaseQueryImpl$NotFieldFilter$ NotFieldFilter() {
        if (this.NotFieldFilter$module == null) {
            this.NotFieldFilter$lzycompute$1();
        }
        return this.NotFieldFilter$module;
    }

    @Override
    public BaseQueryImpl$FieldFilter$ FieldFilter() {
        if (this.FieldFilter$module == null) {
            this.FieldFilter$lzycompute$1();
        }
        return this.FieldFilter$module;
    }

    @Override
    public BaseQueryImpl$JoinedNotFilter$ JoinedNotFilter() {
        if (this.JoinedNotFilter$module == null) {
            this.JoinedNotFilter$lzycompute$1();
        }
        return this.JoinedNotFilter$module;
    }

    @Override
    public BaseQueryImpl$OrFilter$ OrFilter() {
        if (this.OrFilter$module == null) {
            this.OrFilter$lzycompute$1();
        }
        return this.OrFilter$module;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$caseInstanceQuery_$eq(TableQuery<CaseTables.CaseInstanceTable> x$1) {
        this.caseInstanceQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$caseDefinitionQuery_$eq(TableQuery<CaseTables.CaseInstanceDefinitionTable> x$1) {
        this.caseDefinitionQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$caseFileQuery_$eq(TableQuery<CaseTables.CaseFileTable> x$1) {
        this.caseFileQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$planItemTableQuery_$eq(TableQuery<CaseTables.PlanItemTable> x$1) {
        this.planItemTableQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$taskQuery_$eq(TableQuery<TaskTables.TaskTable> x$1) {
        this.taskQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$caseInstanceRoleQuery_$eq(TableQuery<CaseTables.CaseInstanceRoleTable> x$1) {
        this.caseInstanceRoleQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$caseInstanceTeamMemberQuery_$eq(TableQuery<CaseTables.CaseInstanceTeamMemberTable> x$1) {
        this.caseInstanceTeamMemberQuery = x$1;
    }

    @Override
    public void org$cafienne$service$api$projection$query$BaseQueryImpl$_setter_$rolesQuery_$eq(TableQuery<TenantTables.UserRoleTable> x$1) {
        this.rolesQuery = x$1;
    }

    private Logger logger$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = QueryDBSchema.dbConfig$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dbConfig$lzycompute() : this.dbConfig;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$((CafienneJDBCConfig)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    public JdbcBackend.DatabaseDef db() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
    }

    private boolean isSQLServer$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$((CafienneJDBCConfig)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    public boolean isSQLServer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isSQLServer$lzycompute() : this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$((CafienneJDBCConfig)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    public Dialect<? extends JdbcProfile> dialect() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dialect$lzycompute() : this.dialect;
    }

    public TableQuery<TaskTables.TaskTable> tasksQuery() {
        return this.tasksQuery;
    }

    @Override
    public Future<TaskRecord> getTask(String taskId, PlatformUser user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)taskId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId(), baseQuery.tenant(), (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)_ -> baseQuery, Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result().headOption()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TaskRecord task;
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TaskSearchFailure(taskId);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            TaskRecord taskRecord = task = (TaskRecord)some.value();
            return taskRecord;
        }, this.ec());
    }

    @Override
    public Future<Seq<TaskRecord>> getTasksWithCaseName(String caseName, Option<String> tenant, PlatformUser user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new CaseTables.CaseInstanceTable(this, (Tag)tag))).on((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$2.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$3.id(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)x$4 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(((CaseTables.CaseInstanceTable)((Object)((Object)x$4._2()))).caseName(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)caseName, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(((TaskTables.TaskTable)((Object)((Object)x$5._1()))).tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$6, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)baseQuery -> this.membershipQuery(user, ((TaskTables.TaskTable)((Object)((Object)baseQuery._1()))).caseInstanceId(), ((TaskTables.TaskTable)((Object)((Object)baseQuery._1()))).tenant(), (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)_ -> (TaskTables.TaskTable)((Object)((Object)((Object)baseQuery._1()))), Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query.distinct())).result());
    }

    @Override
    public Future<Seq<TaskRecord>> getCaseTasks(String caseInstanceId, PlatformUser user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$7 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$7.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)caseInstanceId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId(), baseQuery.tenant(), (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)_ -> baseQuery, Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query.distinct())).result()).map((Function1 & Serializable & scala.Serializable)records -> {
            if (records.isEmpty()) {
                throw new CaseSearchFailure(caseInstanceId);
            }
            return records;
        }, this.ec());
    }

    public Query<TaskTables.TaskTable, TaskRecord, Seq> blankIdentifierFilterQuery(Rep<String> caseInstanceId) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$8 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$8.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(caseInstanceId, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
    }

    @Override
    public Future<Tuple2<String, String>> authorizeTaskAccessAndReturnCaseAndTenantId(String taskId, PlatformUser user) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$9 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$9.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)taskId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId(), baseQuery.tenant(), (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)_ -> new Tuple2(baseQuery.caseInstanceId(), baseQuery.tenant()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result().headOption()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 result;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                throw new TaskSearchFailure(taskId);
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Tuple2 tuple2 = result = (Tuple2)some.value();
            return tuple2;
        }, this.ec());
    }

    @Override
    public Future<Seq<TaskRecord>> getAllTasks(PlatformUser user, TaskFilter filter, Area area, Sort sort) {
        Query query;
        Option<String> option = filter.assignee();
        if (option instanceof Some) {
            Some some = (Some)option;
            String assignee = (String)some.value();
            query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$10 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$10.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)assignee, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        } else if (None$.MODULE$.equals(option)) {
            query = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).flatMap((Function1 & Serializable & scala.Serializable)tasks -> TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$11 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$11.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.userId(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)x$12 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$12.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tasks.tenant(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)tenantMembership -> TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new CaseTables.CaseInstanceTeamMemberTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$13 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$13.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tasks.caseInstanceId(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)x$14 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$14.active(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)member -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.caseRole(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tasks.role(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isOwner(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isTenantUser(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.memberId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.userId(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isTenantUser(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)false), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.memberId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tenantMembership.role_name(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)tasksForMyCaseRoles -> tasks, Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms()))));
        } else {
            throw new MatchError(option);
        }
        Query assignmentFilterQuery = query;
        Query query2 = assignmentFilterQuery.filterOpt(filter.tenant(), (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$15.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$16, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.taskState(), (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$17.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$18, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.owner(), (Function2 & Serializable & scala.Serializable)(x$19, x$20) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$19.owner(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$20, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(filter.dueOn(), (Function2 & Serializable & scala.Serializable)(x$21, x$22) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$21.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$greater$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getStartDate((String)x$22, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueOn(), (Function2 & Serializable & scala.Serializable)(x$23, x$24) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$23.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$less$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getEndDate((String)x$24, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueBefore(), (Function2 & Serializable & scala.Serializable)(x$25, x$26) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$25.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$less((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getStartDate((String)x$26, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).filterOpt(filter.dueAfter(), (Function2 & Serializable & scala.Serializable)(x$27, x$28) -> new OptionColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().optionColumnExtensionMethods(x$27.dueDate(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$greater((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(this.getEndDate((String)x$28, filter.timeZone()), (TypedType)TypedType$.MODULE$.typedTypeToOptionTypedType((TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), OptionMapper2$.MODULE$.getOptionMapper2OO((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanOptionColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)baseQuery -> this.membershipQuery(user, baseQuery.caseInstanceId(), baseQuery.tenant(), filter.identifiers()).map((Function1 & Serializable & scala.Serializable)_ -> baseQuery, Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(this.QueryHelper(this.QueryHelper(query2.distinct()).only(area)).order(sort))).result());
    }

    private Option<Instant> getStartDate(String date, Option<String> timeZone) {
        return Option$.MODULE$.apply((Object)LocalDateTime.parse(new StringBuilder(19).append(date).append("T00:00:00.000000000").toString()).toInstant(this.getTimeZoneOffset(timeZone)));
    }

    private ZoneOffset getTimeZoneOffset(Option<String> timeZone) {
        ZoneOffset zoneOffset;
        Option<String> option = timeZone;
        if (option instanceof Some) {
            Some some = (Some)option;
            String offsetId = (String)some.value();
            zoneOffset = ZoneOffset.of(offsetId);
        } else if (None$.MODULE$.equals(option)) {
            zoneOffset = ZoneOffset.UTC;
        } else {
            throw new MatchError(option);
        }
        return zoneOffset;
    }

    private Option<Instant> getEndDate(String date, Option<String> timeZone) {
        return Option$.MODULE$.apply((Object)LocalDateTime.parse(new StringBuilder(19).append(date).append("T23:59:59.999999999").toString()).toInstant(this.getTimeZoneOffset(timeZone)));
    }

    @Override
    public Future<TaskCount> getCountForUser(PlatformUser user, Option<String> tenant) {
        Query claimedTasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$29 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$29.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.userId(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable & scala.Serializable)x$30 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$30.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Completed", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable & scala.Serializable)x$31 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$31.taskState(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"Terminated", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable & scala.Serializable)(x$32, x$33) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$32.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$33, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query unclaimedTasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$34 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$34.assignee(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterOpt(tenant, (Function2 & Serializable & scala.Serializable)(x$35, x$36) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$35.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn(x$36, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)unclaimedTasks -> TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$37 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$37.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.userId(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)x$38 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$38.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(unclaimedTasks.tenant(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable & scala.Serializable)tenantMembership -> TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new CaseTables.CaseInstanceTeamMemberTable(this, (Tag)tag)).filter((Function1 & Serializable & scala.Serializable)x$39 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$39.caseInstanceId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(unclaimedTasks.caseInstanceId(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)x$40 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$40.active(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable & scala.Serializable)member -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.caseRole(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(unclaimedTasks.role(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isOwner(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isTenantUser(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.memberId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.userId(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.isTenantUser(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)false), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.memberId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(tenantMembership.role_name(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)tasksForMyCaseRoles -> unclaimedTasks, Shape$.MODULE$.tableShape(Predef$.MODULE$.$conforms()))));
        Future count = this.db().run((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().recordQueryActionExtensionMethods((Object)claimedTasksQuery.distinct().length(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().intColumnType()))).result()).flatMap((Function1 & Serializable & scala.Serializable)claimTasks -> TaskQueriesImpl.$anonfun$getCountForUser$19(this, unclaimedTasksQuery, BoxesRunTime.unboxToInt((Object)claimTasks)), this.ec());
        return count.map((Function1 & Serializable & scala.Serializable)c -> {
            void var1_1;
            TaskCount tc = new TaskCount(c._1$mcI$sp(), c._2$mcI$sp());
            return var1_1;
        }, this.ec());
    }

    private final void NotValueFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NotValueFilter$module == null) {
                this.NotValueFilter$module = new BaseQueryImpl$NotValueFilter$(this);
            }
        }
    }

    private final void ValueFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.ValueFilter$module == null) {
                this.ValueFilter$module = new BaseQueryImpl$ValueFilter$(this);
            }
        }
    }

    private final void NoFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NoFilter$module == null) {
                this.NoFilter$module = new BaseQueryImpl$NoFilter$(this);
            }
        }
    }

    private final void NotFieldFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.NotFieldFilter$module == null) {
                this.NotFieldFilter$module = new BaseQueryImpl$NotFieldFilter$(this);
            }
        }
    }

    private final void FieldFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.FieldFilter$module == null) {
                this.FieldFilter$module = new BaseQueryImpl$FieldFilter$(this);
            }
        }
    }

    private final void JoinedNotFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.JoinedNotFilter$module == null) {
                this.JoinedNotFilter$module = new BaseQueryImpl$JoinedNotFilter$(this);
            }
        }
    }

    private final void OrFilter$lzycompute$1() {
        TaskQueriesImpl taskQueriesImpl = this;
        synchronized (taskQueriesImpl) {
            if (this.OrFilter$module == null) {
                this.OrFilter$module = new BaseQueryImpl$OrFilter$(this);
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$getCountForUser$20(int claimTasks$1, int unclaimedTasks) {
        return new Tuple2.mcII.sp(claimTasks$1, unclaimedTasks);
    }

    public static final /* synthetic */ Future $anonfun$getCountForUser$19(TaskQueriesImpl $this, Query unclaimedTasksQuery$1, int claimTasks) {
        return $this.db().run((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)((JdbcProfile)$this.dbConfig().profile()).api().recordQueryActionExtensionMethods((Object)unclaimedTasksQuery$1.distinct().length(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)$this.dbConfig().profile()).api().intColumnType()))).result()).map((Function1 & Serializable & scala.Serializable)unclaimedTasks -> TaskQueriesImpl.$anonfun$getCountForUser$20(claimTasks, BoxesRunTime.unboxToInt((Object)unclaimedTasks)), $this.ec());
    }

    public TaskQueriesImpl() {
        TaskQueries.$init$(this);
        CafienneJDBCConfig.$init$((CafienneJDBCConfig)this);
        QueryDBSchema.$init$(this);
        CaseTables.$init$(this);
        TaskTables.$init$(this);
        TenantTables.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        BaseQueryImpl.$init$(this);
        this.tasksQuery = TableQuery$.MODULE$.apply((Function1 & Serializable & scala.Serializable)tag -> new TaskTables.TaskTable(this, (Tag)tag));
    }
}

