/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.api.projection.tenant;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.akka.actor.event.TransactionEvent;
import org.cafienne.identity.IdentityProvider;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.service.api.projection.RecordsPersistence;
import org.cafienne.service.api.projection.query.UserQueries;
import org.cafienne.service.api.projection.record.TenantRecord;
import org.cafienne.service.api.projection.record.TenantRecord$;
import org.cafienne.service.api.projection.record.UserRoleKey;
import org.cafienne.service.api.projection.record.UserRoleKey$;
import org.cafienne.service.api.projection.record.UserRoleRecord;
import org.cafienne.service.api.projection.slick.SlickTransaction;
import org.cafienne.tenant.akka.event.OwnerAdded;
import org.cafienne.tenant.akka.event.OwnerRemoved;
import org.cafienne.tenant.akka.event.TenantEvent;
import org.cafienne.tenant.akka.event.TenantUserCreated;
import org.cafienne.tenant.akka.event.TenantUserDisabled;
import org.cafienne.tenant.akka.event.TenantUserEnabled;
import org.cafienne.tenant.akka.event.TenantUserEvent;
import org.cafienne.tenant.akka.event.TenantUserRoleAdded;
import org.cafienne.tenant.akka.event.TenantUserRoleRemoved;
import org.cafienne.tenant.akka.event.TenantUserUpdated;
import org.cafienne.tenant.akka.event.platform.PlatformEvent;
import org.cafienne.tenant.akka.event.platform.TenantCreated;
import org.cafienne.tenant.akka.event.platform.TenantDisabled;
import org.cafienne.tenant.akka.event.platform.TenantEnabled;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\n\u0015\u0001\u0005B\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!y\u0006A!b\u0001\n\u0007\u0001\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u000b!\u0004A\u0011A5\t\u000fI\u0004!\u0019!C\u0001g\"9\u0011Q\u0001\u0001!\u0002\u0013!\b\"CA\u0004\u0001\t\u0007I\u0011AA\u0005\u0011!\tI\u0002\u0001Q\u0001\n\u0005-\u0001\"CA\u000e\u0001\t\u0007I\u0011AA\u000f\u0011!\t\t\u0004\u0001Q\u0001\n\u0005}\u0001bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002.\u0002!I!a,\u0003#Q+g.\u00198u)J\fgn]1di&|gN\u0003\u0002\u0016-\u00051A/\u001a8b]RT!a\u0006\r\u0002\u0015A\u0014xN[3di&|gN\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005ma\u0012aB:feZL7-\u001a\u0006\u0003;y\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M!\u0001A\t\u00158!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0019\u0011\u0006\f\u0018\u000e\u0003)R!a\u000b\f\u0002\u000bMd\u0017nY6\n\u00055R#\u0001E*mS\u000e\\GK]1og\u0006\u001cG/[8o!\tyS'D\u00011\u0015\t\t$'A\u0003fm\u0016tGO\u0003\u00024i\u0005!\u0011m[6b\u0015\t)B$\u0003\u00027a\tYA+\u001a8b]R,e/\u001a8u!\tAt(D\u0001:\u0015\tQ4(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002={\u0005AA/\u001f9fg\u00064WMC\u0001?\u0003\r\u0019w.\\\u0005\u0003\u0001f\u00121\u0002T1{s2{wmZ5oOB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001\u0012\u0013\u000e\u0003\u0015S!A\u0012\u0011\u0002\rq\u0012xn\u001c;?\u0013\tAE%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%%\u0003-)8/\u001a:Rk\u0016\u0014\u0018.Z:\u0011\u00059\u000bV\"A(\u000b\u0005A3\u0012!B9vKJL\u0018B\u0001*P\u0005-)6/\u001a:Rk\u0016\u0014\u0018.Z:\u0002\u0017A,'o]5ti\u0016t7-\u001a\t\u0003+Zk\u0011AF\u0005\u0003/Z\u0011!CU3d_J$7\u000fU3sg&\u001cH/\u001a8dK\u0006IQo]3s\u0007\u0006\u001c\u0007.\u001a\t\u00035vk\u0011a\u0017\u0006\u00039r\t\u0001\"\u001b3f]RLG/_\u0005\u0003=n\u0013\u0001#\u00133f]RLG/\u001f)s_ZLG-\u001a:\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011$\u0013AC2p]\u000e,(O]3oi&\u0011am\u0019\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q)!N\\8qcR\u00111.\u001c\t\u0003Y\u0002i\u0011\u0001\u0006\u0005\u0006?\u001e\u0001\u001d!\u0019\u0005\u0006+\u001d\u0001\r!\u0011\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006'\u001e\u0001\r\u0001\u0016\u0005\u00061\u001e\u0001\r!W\u0001\bi\u0016t\u0017M\u001c;t+\u0005!\b\u0003B;{\u0003rl\u0011A\u001e\u0006\u0003ob\fq!\\;uC\ndWM\u0003\u0002zI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m4(a\u0002%bg\"l\u0015\r\u001d\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}4\u0012A\u0002:fG>\u0014H-C\u0002\u0002\u0004y\u0014A\u0002V3oC:$(+Z2pe\u0012\f\u0001\u0002^3oC:$8\u000fI\u0001\u0006kN,'o]\u000b\u0003\u0003\u0017\u0001b!\u001e>\u0002\u000e\u0005M\u0001cA?\u0002\u0010%\u0019\u0011\u0011\u0003@\u0003\u0017U\u001bXM\u001d*pY\u0016\\U-\u001f\t\u0004{\u0006U\u0011bAA\f}\nqQk]3s%>dWMU3d_J$\u0017AB;tKJ\u001c\b%A\u0007n_\u0012Lg-[3e+N,'o]\u000b\u0003\u0003?\u0001R!!\t\u0002,\u0005sA!a\t\u0002(9\u0019A)!\n\n\u0003\u0015J1!!\u000b%\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\f\u00020\tA\u0011\n^3sC\ndWMC\u0002\u0002*\u0011\na\"\\8eS\u001aLW\rZ+tKJ\u001c\b%A\u0006iC:$G.Z#wK:$H\u0003BA\u001c\u0003\u000f\u0002RAYA\u001d\u0003{I1!a\u000fd\u0005\u00191U\u000f^;sKB!\u0011qHA\"\u001b\t\t\tEC\u00014\u0013\u0011\t)%!\u0011\u0003\t\u0011{g.\u001a\u0005\u0007\u0003\u0013r\u0001\u0019\u0001\u0018\u0002\u0007\u00154H/A\niC:$G.\u001a)mCR4wN]7Fm\u0016tG\u000f\u0006\u0003\u00028\u0005=\u0003BB\u0019\u0010\u0001\u0004\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006M\u0001\ta2\fGOZ8s[&!\u00111LA+\u00055\u0001F.\u0019;g_JlWI^3oi\u0006y\u0001.\u00198eY\u0016,6/\u001a:Fm\u0016tG\u000f\u0006\u0003\u00028\u0005\u0005\u0004BB\u0019\u0011\u0001\u0004\t\u0019\u0007E\u00020\u0003KJ1!a\u001a1\u0005=!VM\\1oiV\u001bXM]#wK:$\u0018AB2p[6LG\u000f\u0006\u0005\u00028\u00055\u0014\u0011OAA\u0011\u0019\ty'\u0005a\u0001\u0003\u0006QqN\u001a4tKRt\u0015-\\3\t\u000f\u0005M\u0014\u00031\u0001\u0002v\u00051qN\u001a4tKR\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004!\u0006m$bA*\u0002B%!\u0011qPA=\u0005\u0019yeMZ:fi\"9\u00111Q\tA\u0002\u0005\u0015\u0015\u0001\u0005;sC:\u001c\u0018m\u0019;j_:,e/\u001a8ua\u0011\t9)a'\u0011\r\u0005%\u00151SAL\u001b\t\tYIC\u00022\u0003\u001bSA!a$\u0002\u0012\u0006)\u0011m\u0019;pe*\u00111\u0007H\u0005\u0005\u0003+\u000bYI\u0001\tUe\u0006t7/Y2uS>tWI^3oiB!\u0011\u0011TAN\u0019\u0001!A\"!(\u0002\u0002\u0006\u0005\t\u0011!B\u0001\u0003?\u00131a\u0018\u00132#\u0011\t\t+a*\u0011\u0007\r\n\u0019+C\u0002\u0002&\u0012\u0012qAT8uQ&tw\rE\u0002$\u0003SK1!a+%\u0005\r\te._\u0001\u0012O\u0016$Xk]3s%>dWMU3d_J$G\u0003BAY\u0003g\u0003RAYA\u001d\u0003'Aq!!.\u0013\u0001\u0004\ti!A\u0002lKf\u0004")
public class TenantTransaction
implements SlickTransaction<TenantEvent>,
LazyLogging {
    private final String tenant;
    private final RecordsPersistence persistence;
    private final IdentityProvider userCache;
    private final ExecutionContext executionContext;
    private final HashMap<String, TenantRecord> tenants;
    private final HashMap<UserRoleKey, UserRoleRecord> users;
    private final Iterable<String> modifiedUsers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TenantTransaction tenantTransaction = this;
        synchronized (tenantTransaction) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public HashMap<String, TenantRecord> tenants() {
        return this.tenants;
    }

    public HashMap<UserRoleKey, UserRoleRecord> users() {
        return this.users;
    }

    public Iterable<String> modifiedUsers() {
        return this.modifiedUsers;
    }

    @Override
    public Future<Done> handleEvent(TenantEvent evt) {
        Future<Done> future;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(34).append("Handling event of type ").append(evt.getClass().getSimpleName()).append(" on tenant ").append(this.tenant).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TenantEvent tenantEvent = evt;
        if (tenantEvent instanceof PlatformEvent) {
            PlatformEvent platformEvent = (PlatformEvent)tenantEvent;
            future = this.handlePlatformEvent(platformEvent);
        } else if (tenantEvent instanceof TenantUserEvent) {
            TenantUserEvent tenantUserEvent = (TenantUserEvent)tenantEvent;
            future = this.handleUserEvent(tenantUserEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    public Future<Done> handlePlatformEvent(PlatformEvent event) {
        Option option;
        PlatformEvent platformEvent = event;
        if (platformEvent instanceof TenantCreated) {
            TenantCreated tenantCreated = (TenantCreated)platformEvent;
            option = this.tenants().put((Object)tenantCreated.tenantName(), (Object)new TenantRecord(tenantCreated.tenantName(), TenantRecord$.MODULE$.apply$default$2()));
        } else if (platformEvent instanceof TenantDisabled) {
            TenantDisabled tenantDisabled = (TenantDisabled)platformEvent;
            option = this.tenants().put((Object)tenantDisabled.tenantName(), (Object)new TenantRecord(tenantDisabled.tenantName(), false));
        } else if (platformEvent instanceof TenantEnabled) {
            TenantEnabled tenantEnabled = (TenantEnabled)platformEvent;
            option = this.tenants().put((Object)tenantEnabled.tenantName(), (Object)new TenantRecord(tenantEnabled.tenantName(), true));
        } else {
            throw new MatchError((Object)platformEvent);
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public Future<Done> handleUserEvent(TenantUserEvent event) {
        this.userCache.clear(event.userId);
        UserRoleKey key = UserRoleKey$.MODULE$.apply(event);
        return this.getUserRoleRecord(key).map((Function1 & Serializable & scala.Serializable)user -> {
            Option option;
            TenantUserEvent tenantUserEvent = event;
            if (tenantUserEvent instanceof TenantUserCreated) {
                TenantUserCreated tenantUserCreated = (TenantUserCreated)tenantUserEvent;
                String x$1 = tenantUserCreated.name;
                String x$2 = tenantUserCreated.email;
                boolean x$3 = true;
                String x$4 = user.copy$default$1();
                String x$5 = user.copy$default$2();
                String x$6 = user.copy$default$3();
                boolean x$7 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$4, x$5, x$6, x$1, x$2, x$7, x$3));
            } else if (tenantUserEvent instanceof TenantUserUpdated) {
                TenantUserUpdated tenantUserUpdated = (TenantUserUpdated)tenantUserEvent;
                String x$8 = tenantUserUpdated.name;
                String x$9 = tenantUserUpdated.email;
                boolean x$10 = true;
                String x$11 = user.copy$default$1();
                String x$12 = user.copy$default$2();
                String x$13 = user.copy$default$3();
                boolean x$14 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$11, x$12, x$13, x$8, x$9, x$14, x$10));
            } else if (tenantUserEvent instanceof TenantUserRoleAdded) {
                boolean x$15 = true;
                String x$16 = user.copy$default$1();
                String x$17 = user.copy$default$2();
                String x$18 = user.copy$default$3();
                String x$19 = user.copy$default$4();
                String x$20 = user.copy$default$5();
                boolean x$21 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$15));
            } else if (tenantUserEvent instanceof TenantUserRoleRemoved) {
                boolean x$22 = false;
                String x$23 = user.copy$default$1();
                String x$24 = user.copy$default$2();
                String x$25 = user.copy$default$3();
                String x$26 = user.copy$default$4();
                String x$27 = user.copy$default$5();
                boolean x$28 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$22));
            } else if (tenantUserEvent instanceof OwnerAdded) {
                boolean x$29 = true;
                String x$30 = user.copy$default$1();
                String x$31 = user.copy$default$2();
                String x$32 = user.copy$default$3();
                String x$33 = user.copy$default$4();
                String x$34 = user.copy$default$5();
                boolean x$35 = user.copy$default$7();
                option = this.users().put((Object)key, (Object)user.copy(x$30, x$31, x$32, x$33, x$34, x$29, x$35));
            } else if (tenantUserEvent instanceof OwnerRemoved) {
                boolean x$36 = false;
                String x$37 = user.copy$default$1();
                String x$38 = user.copy$default$2();
                String x$39 = user.copy$default$3();
                String x$40 = user.copy$default$4();
                String x$41 = user.copy$default$5();
                boolean x$42 = user.copy$default$7();
                option = this.users().put((Object)key, (Object)user.copy(x$37, x$38, x$39, x$40, x$41, x$36, x$42));
            } else if (tenantUserEvent instanceof TenantUserDisabled) {
                boolean x$43 = false;
                String x$44 = user.copy$default$1();
                String x$45 = user.copy$default$2();
                String x$46 = user.copy$default$3();
                String x$47 = user.copy$default$4();
                String x$48 = user.copy$default$5();
                boolean x$49 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$44, x$45, x$46, x$47, x$48, x$49, x$43));
            } else if (tenantUserEvent instanceof TenantUserEnabled) {
                boolean x$50 = true;
                String x$51 = user.copy$default$1();
                String x$52 = user.copy$default$2();
                String x$53 = user.copy$default$3();
                String x$54 = user.copy$default$4();
                String x$55 = user.copy$default$5();
                boolean x$56 = user.copy$default$6();
                option = this.users().put((Object)key, (Object)user.copy(x$51, x$52, x$53, x$54, x$55, x$56, x$50));
            } else {
                throw new MatchError((Object)tenantUserEvent);
            }
            return Done$.MODULE$;
        }, this.executionContext());
    }

    @Override
    public Future<Done> commit(String offsetName, Offset offset, TransactionEvent<?> transactionEvent) {
        ObjectRef records = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.empty()));
        this.users().values().foreach((Function1 & Serializable & scala.Serializable)role -> ((ListBuffer)records$1.elem).$plus$eq(role));
        ((ListBuffer)records.elem).$plus$plus$eq((TraversableOnce)this.tenants().values());
        ((ListBuffer)records.elem).$plus$eq((Object)OffsetRecord$.MODULE$.apply(offsetName, offset));
        return this.persistence.bulkUpdate((Seq<Object>)((Seq)((ListBuffer)records.elem).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)TenantTransaction.$anonfun$commit$2(r)))));
    }

    private Future<UserRoleRecord> getUserRoleRecord(UserRoleKey key) {
        Future future;
        Option option = this.users().get((Object)key);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserRoleRecord value = (UserRoleRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved user_role[{}] from current transaction cache", new Object[]{key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieving user_role[{}] from database", new Object[]{key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getUserRole(key).map((Function1 & Serializable & scala.Serializable)result -> {
                UserRoleRecord userRoleRecord;
                Option option = result;
                if (option instanceof Some) {
                    UserRoleRecord value;
                    Some some = (Some)option;
                    userRoleRecord = value = (UserRoleRecord)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    userRoleRecord = new UserRoleRecord(key.userId(), key.tenant(), key.role_name(), "", "", false, true);
                } else {
                    throw new MatchError((Object)option);
                }
                return userRoleRecord;
            }, this.executionContext());
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$commit$2(Object r) {
        return r != null;
    }

    public TenantTransaction(String tenant, UserQueries userQueries, RecordsPersistence persistence, IdentityProvider userCache, ExecutionContext executionContext) {
        this.tenant = tenant;
        this.persistence = persistence;
        this.userCache = userCache;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.tenants = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.users = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.modifiedUsers = ((TraversableOnce)this.users().keySet().map((Function1 & Serializable & scala.Serializable)key -> key.userId(), Set$.MODULE$.canBuildFrom())).toSet();
    }
}

