/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.http.storage;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.cafienne.service.infrastructure.route.AuthenticatedRoute;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.command.StorageCommand;
import org.cafienne.storage.actormodel.event.StorageRequestReceived;
import org.cafienne.storage.actormodel.message.StorageActionRejected;
import org.cafienne.storage.actormodel.message.StorageActionStarted;
import org.cafienne.storage.actormodel.message.StorageFailure;
import org.cafienne.storage.archival.command.ArchiveActorData;
import org.cafienne.storage.deletion.command.RemoveActorData;
import org.cafienne.storage.deletion.event.RemovalCompleted;
import org.cafienne.storage.restore.command.RestoreActorData;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005}3qAB\u0004\u0011\u0002\u0007\u0005!\u0003C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003T\u0001\u0011\u0005A\u000bC\u0003W\u0001\u0011%qK\u0001\u0007Ti>\u0014\u0018mZ3S_V$XM\u0003\u0002\t\u0013\u000591\u000f^8sC\u001e,'B\u0001\u0006\f\u0003\u0011AG\u000f\u001e9\u000b\u00051i\u0011aB:feZL7-\u001a\u0006\u0003\u001d=\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQr$D\u0001\u001c\u0015\taR$A\u0003s_V$XM\u0003\u0002\u001f\u0017\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001\u0011\u001c\u0005I\tU\u000f\u001e5f]RL7-\u0019;fIJ{W\u000f^3\u0002\r\u0011Jg.\u001b;%)\u0005\u0019\u0003C\u0001\u000b%\u0013\t)SC\u0001\u0003V]&$\u0018aE5oSRL\u0017\r^3ECR\f'+Z7pm\u0006dGC\u0001\u0015H!\tICI\u0004\u0002+\u0003:\u00111F\u0010\b\u0003Ymr!!L\u001d\u000f\u000592dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011\u0014#\u0001\u0004=e>|GOP\u0005\u0002!%\u0011QgD\u0001\u0007CB\f7\r[3\n\u0005]B\u0014!\u00029fW.|'BA\u001b\u0010\u0013\tQ!H\u0003\u00028q%\u0011A(P\u0001\tg\u000e\fG.\u00193tY*\u0011!BO\u0005\u0003\u007f\u0001\u000baa]3sm\u0016\u0014(B\u0001\u001f>\u0013\t\u00115)A\u0004qC\u000e\\\u0017mZ3\u000b\u0005}\u0002\u0015BA#G\u0005\u0015\u0011v.\u001e;f\u0015\t\u00115\tC\u0003I\u0005\u0001\u0007\u0011*\u0001\u0005nKR\fG-\u0019;b!\tQe*D\u0001L\u0015\taU*\u0001\u0006bGR|'/\\8eK2T!\u0001C\u0007\n\u0005=[%!D!di>\u0014X*\u001a;bI\u0006$\u0018-\u0001\u000bj]&$\u0018.\u0019;f\t\u0006$\u0018-\u0011:dQ&4\u0018\r\u001c\u000b\u0003QICQ\u0001S\u0002A\u0002%\u000b\u0001C]3ti>\u0014X-Q2u_J$\u0015\r^1\u0015\u0005!*\u0006\"\u0002%\u0005\u0001\u0004I\u0015!F1tWN#xN]1hK\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0003QaCQ!W\u0003A\u0002i\u000bqaY8n[\u0006tG\r\u0005\u0002\\;6\tAL\u0003\u0002Z\u0017&\u0011a\f\u0018\u0002\u000f'R|'/Y4f\u0007>lW.\u00198e\u0001")
public interface StorageRoute
extends AuthenticatedRoute {
    public static /* synthetic */ Function1 initiateDataRemoval$(StorageRoute $this, ActorMetadata metadata) {
        return $this.initiateDataRemoval(metadata);
    }

    default public Function1<RequestContext, Future<RouteResult>> initiateDataRemoval(ActorMetadata metadata) {
        return this.askStorageCoordinator((StorageCommand)new RemoveActorData(metadata));
    }

    public static /* synthetic */ Function1 initiateDataArchival$(StorageRoute $this, ActorMetadata metadata) {
        return $this.initiateDataArchival(metadata);
    }

    default public Function1<RequestContext, Future<RouteResult>> initiateDataArchival(ActorMetadata metadata) {
        return this.askStorageCoordinator((StorageCommand)new ArchiveActorData(metadata));
    }

    public static /* synthetic */ Function1 restoreActorData$(StorageRoute $this, ActorMetadata metadata) {
        return $this.restoreActorData(metadata);
    }

    default public Function1<RequestContext, Future<RouteResult>> restoreActorData(ActorMetadata metadata) {
        return this.askStorageCoordinator((StorageCommand)new RestoreActorData(metadata));
    }

    private Function1<RequestContext, Future<RouteResult>> askStorageCoordinator(StorageCommand command) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.onComplete((Function0 & Serializable)() -> this.caseSystem().gateway().request((Object)command)), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                Object value = success.value();
                Object object = value;
                if (object instanceof StorageRequestReceived) {
                    return this.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Accepted(), Marshaller$.MODULE$.fromStatusCode()));
                }
                if (object instanceof StorageActionStarted) {
                    return this.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Accepted(), Marshaller$.MODULE$.fromStatusCode()));
                }
                if (object instanceof StorageActionRejected) {
                    BoxedUnit boxedUnit2;
                    StorageActionRejected storageActionRejected = (StorageActionRejected)object;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Removal of {} is rejected with reason {}", new Object[]{command.metadata(), storageActionRejected.msg()});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    return this.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.NotFound(), Marshaller$.MODULE$.fromStatusCode()));
                }
                if (object instanceof RemovalCompleted) {
                    return this.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> new StringBuilder(12).append("Cannot find ").append(command.metadata()).toString(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (object instanceof StorageFailure) {
                    StorageFailure storageFailure = (StorageFailure)object;
                    return this.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> storageFailure.getMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Received an unexpected response after asking {} a command of type {}. Response is of type {}", new Object[]{command.metadata(), command.getClass().getSimpleName(), object.getClass().getSimpleName()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Accepted(), Marshaller$.MODULE$.fromStatusCode()));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return this.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> e.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            }
            throw new MatchError((Object)try_);
        });
    }

    public static void $init$(StorageRoute $this) {
    }
}

