/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.infrastructure.authentication;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import java.util.Arrays;
import java.util.HashSet;
import org.cafienne.service.infrastructure.authentication.MissingClaimsException;
import org.cafienne.service.infrastructure.authentication.TokenContext;
import org.cafienne.service.infrastructure.configuration.OIDCConfiguration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q2A\u0001B\u0003\u0001!!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003-\u0001\u0011\u0005SF\u0001\bDY\u0006LWn\u001d,fe&4\u0017.\u001a:\u000b\u0005\u00199\u0011AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003\u0011%\ta\"\u001b8ge\u0006\u001cHO];diV\u0014XM\u0003\u0002\u000b\u0017\u000591/\u001a:wS\u000e,'B\u0001\u0007\u000e\u0003!\u0019\u0017MZ5f]:,'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002c\u0001\n\u001c;5\t1C\u0003\u0002\u0015+\u0005!\u0001O]8d\u0015\t1r#A\u0002koRT!\u0001G\r\u0002\u00119LWNY;tINT\u0011AG\u0001\u0004G>l\u0017B\u0001\u000f\u0014\u0005a!UMZ1vYRTu\u000bV\"mC&l7OV3sS\u001aLWM\u001d\t\u0003=}i\u0011!B\u0005\u0003A\u0015\u0011A\u0002V8lK:\u001cuN\u001c;fqR\faaY8oM&<\u0007CA\u0012'\u001b\u0005!#BA\u0013\b\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011q\u0005\n\u0002\u0012\u001f&#5iQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002+WA\u0011a\u0004\u0001\u0005\u0006C\t\u0001\rAI\u0001\u0007m\u0016\u0014\u0018NZ=\u0015\u00079\"$\b\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003V]&$\b\"B\u001b\u0004\u0001\u00041\u0014AB2mC&l7\u000f\u0005\u00028q5\tQ#\u0003\u0002:+\ta!j\u0016+DY\u0006LWn]*fi\")1h\u0001a\u0001;\u000591m\u001c8uKb$\b")
public class ClaimsVerifier
extends DefaultJWTClaimsVerifier<TokenContext> {
    public void verify(JWTClaimsSet claims, TokenContext context) {
        super.verify(claims, (SecurityContext)context);
        String userIdClaim = context.issuer().userIdClaim();
        String userId = claims.getStringClaim(userIdClaim);
        if (userId == null) {
            throw new MissingClaimsException(new StringBuilder(34).append("Invalid token: claim '").append(userIdClaim).append("' is missing").toString());
        }
        context.createUser(userId, claims);
    }

    public ClaimsVerifier(OIDCConfiguration config) {
        super(new JWTClaimsSet.Builder().build(), new HashSet<Object>(Arrays.asList((Object[])new String[]{"exp"})));
    }
}

