/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.infrastructure.route;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.cafienne.actormodel.ActorType;
import org.cafienne.actormodel.message.command.ModelCommand;
import org.cafienne.actormodel.message.response.ActorExistsFailure;
import org.cafienne.actormodel.message.response.ActorInStorage;
import org.cafienne.actormodel.message.response.CommandFailure;
import org.cafienne.actormodel.message.response.EngineChokedFailure;
import org.cafienne.actormodel.message.response.ModelResponse;
import org.cafienne.actormodel.message.response.SecurityFailure;
import org.cafienne.cmmn.actorapi.response.CaseNotModifiedResponse;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupCreatedResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupResponse;
import org.cafienne.humantask.actorapi.response.HumanTaskResponse;
import org.cafienne.persistence.infrastructure.lastmodified.LastModifiedHeader;
import org.cafienne.persistence.querydb.query.exception.CaseSearchFailure;
import org.cafienne.persistence.querydb.query.exception.ConsentGroupSearchFailure;
import org.cafienne.persistence.querydb.query.exception.SearchFailure;
import org.cafienne.persistence.querydb.query.exception.TaskSearchFailure;
import org.cafienne.persistence.querydb.query.exception.TenantSearchFailure;
import org.cafienne.service.infrastructure.route.LastModifiedDirectives;
import org.cafienne.system.CaseSystem;
import org.cafienne.tenant.actorapi.response.TenantOwnersResponse;
import org.cafienne.tenant.actorapi.response.TenantResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class CommandRouteExecutor$
implements LastModifiedDirectives {
    public static final CommandRouteExecutor$ MODULE$ = new CommandRouteExecutor$();
    private static Marshaller<ModelResponse, HttpEntity.Strict> modelResponseMarshaller;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        LastModifiedDirectives.$init$(MODULE$);
    }

    @Override
    public <R extends ModelResponse> Function1<RequestContext, Future<RouteResult>> completeWithLMH(StatusCodes.Success statusCode, R response, String headerName) {
        return LastModifiedDirectives.completeWithLMH$(this, statusCode, response, headerName);
    }

    @Override
    public <R extends ModelResponse> Function1<RequestContext, Future<RouteResult>> completeOnlyLMH(StatusCodes.Success statusCode, R response, String headerName) {
        return LastModifiedDirectives.completeOnlyLMH$(this, statusCode, response, headerName);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> readLastModifiedHeader(String headerName, Function1<LastModifiedHeader, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return LastModifiedDirectives.readLastModifiedHeader$(this, headerName, subRoute);
    }

    @Override
    public Directive<BoxedUnit> writeLastModifiedHeader(ModelResponse response, String header) {
        return LastModifiedDirectives.writeLastModifiedHeader$(this, response, header);
    }

    @Override
    public Marshaller<ModelResponse, HttpEntity.Strict> modelResponseMarshaller() {
        return modelResponseMarshaller;
    }

    @Override
    public void org$cafienne$service$infrastructure$route$LastModifiedDirectives$_setter_$modelResponseMarshaller_$eq(Marshaller<ModelResponse, HttpEntity.Strict> x$1) {
        modelResponseMarshaller = x$1;
    }

    private Logger logger$lzycompute() {
        CommandRouteExecutor$ commandRouteExecutor$ = this;
        synchronized (commandRouteExecutor$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Function1<RequestContext, Future<RouteResult>> askModelActor(CaseSystem caseSystem, ModelCommand command) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onComplete((Function0 & Serializable)() -> caseSystem.engine().request(command)), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                ModelResponse value = (ModelResponse)success.value();
                ModelResponse modelResponse = value;
                if (modelResponse instanceof SecurityFailure) {
                    SecurityFailure securityFailure = (SecurityFailure)modelResponse;
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> securityFailure.exception().getMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof ActorInStorage) {
                    ActorInStorage actorInStorage = (ActorInStorage)modelResponse;
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> MODULE$.readSearchFailure(x3$1.actorType, actorInStorage.getActorId()).getLocalizedMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof EngineChokedFailure) {
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> "An error happened in the server; check the server logs for more information", Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof ActorExistsFailure) {
                    ActorExistsFailure actorExistsFailure = (ActorExistsFailure)modelResponse;
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> actorExistsFailure.exception().getMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof CommandFailure) {
                    CommandFailure commandFailure = (CommandFailure)modelResponse;
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> commandFailure.exception().getMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof HumanTaskResponse) {
                    HumanTaskResponse humanTaskResponse = (HumanTaskResponse)modelResponse;
                    return MODULE$.completeWithLMH(StatusCodes$.MODULE$.Accepted(), humanTaskResponse, "Case-Last-Modified");
                }
                if (modelResponse instanceof CaseNotModifiedResponse) {
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotModified(), (Function0 & Serializable)() -> "Transition has no effect", Marshaller$.MODULE$.StringMarshaller());
                }
                if (modelResponse instanceof CaseResponse) {
                    CaseResponse caseResponse = (CaseResponse)modelResponse;
                    return MODULE$.completeWithLMH(StatusCodes$.MODULE$.OK(), caseResponse, "Case-Last-Modified");
                }
                if (modelResponse instanceof TenantOwnersResponse) {
                    TenantOwnersResponse tenantOwnersResponse = (TenantOwnersResponse)modelResponse;
                    return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.OK(), (Function0 & Serializable)() -> tenantOwnersResponse, MODULE$.modelResponseMarshaller());
                }
                if (modelResponse instanceof TenantResponse) {
                    TenantResponse tenantResponse = (TenantResponse)modelResponse;
                    return MODULE$.completeOnlyLMH(StatusCodes$.MODULE$.NoContent(), tenantResponse, "Tenant-Last-Modified");
                }
                if (modelResponse instanceof ConsentGroupCreatedResponse) {
                    ConsentGroupCreatedResponse consentGroupCreatedResponse = (ConsentGroupCreatedResponse)modelResponse;
                    return MODULE$.completeWithLMH(StatusCodes$.MODULE$.OK(), consentGroupCreatedResponse, "Consent-Group-Last-Modified");
                }
                if (modelResponse instanceof ConsentGroupResponse) {
                    ConsentGroupResponse consentGroupResponse = (ConsentGroupResponse)modelResponse;
                    return MODULE$.completeOnlyLMH(StatusCodes$.MODULE$.Accepted(), consentGroupResponse, "Consent-Group-Last-Modified");
                }
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("Received an unexpected response after asking CaseSystem a command of type {}. Response is of type {}", new Object[]{command.getDescription(), modelResponse.getClass().getSimpleName()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.OK(), Marshaller$.MODULE$.fromStatusCode()));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> e.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            }
            throw new MatchError((Object)try_);
        });
    }

    public SearchFailure readSearchFailure(ActorType actorType, String actorId) {
        BoxedUnit boxedUnit;
        ActorType actorType2 = actorType;
        if (ActorType.Case.equals(actorType2)) {
            return new CaseSearchFailure(actorId);
        }
        if (ActorType.Tenant.equals(actorType2)) {
            return new TenantSearchFailure(actorId);
        }
        if (ActorType.Process.equals(actorType2)) {
            return new TaskSearchFailure(actorId);
        }
        if (ActorType.Group.equals(actorType2)) {
            return new ConsentGroupSearchFailure(actorId);
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Received 'ActorInStorage' response with unknown actor type {} on actor {}", new Object[]{actorType, actorId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CaseSearchFailure(actorId);
    }

    private CommandRouteExecutor$() {
    }
}

