/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.infrastructure.configuration;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.cafienne.infrastructure.config.util.ConfigReader;
import org.cafienne.json.JSONReader;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0005e4Aa\u0004\t\u00017!Aq\u0005\u0001BC\u0002\u0013\u00053\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u0003-\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\u0002qBa\u0001\u0013\u0001!\u0002\u0013i\u0004bB%\u0001\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\u001f\t\u000b-\u0003A\u0011\u0001'\t\u000bA\u0003A\u0011A)\t\u0011\u0001\u0004\u0001R1A\u0005\u0002\u0005Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006k\u0002!\tA\u001e\u0002\u0014\u0013N\u001cX/\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0006\u0003#I\tQbY8oM&<WO]1uS>t'BA\n\u0015\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016T!!\u0006\f\u0002\u000fM,'O^5dK*\u0011q\u0003G\u0001\tG\u00064\u0017.\u001a8oK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012*\u001b\u0005!#BA\u0013'\u0003\u0011)H/\u001b7\u000b\u0005\u001dB\u0013AB2p]\u001aLwM\u0003\u0002\u0014-%\u0011!\u0006\n\u0002\r\u0007>tg-[4SK\u0006$WM]\u000b\u0002YA\u0011QfM\u0007\u0002])\u0011qe\f\u0006\u0003aE\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002e\u0005\u00191m\\7\n\u0005Qr#AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\tA$\b\u0005\u0002:\u00015\t\u0001\u0003C\u0003(\u0007\u0001\u0007A&\u0001\u0004jgN,XM]\u000b\u0002{A\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001\u0011\u0010\u000e\u0003\u0005S!A\u0011\u000e\u0002\rq\u0012xn\u001c;?\u0013\t!e$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#\u001f\u0003\u001dI7o];fe\u0002\n1\"^:fe&#7\t\\1j[\u0006aQo]3s\u0013\u0012\u001cE.Y5nA\u0005Y\u0001.Y:NKR\fG-\u0019;b+\u0005i\u0005CA\u000fO\u0013\tyeDA\u0004C_>dW-\u00198\u0002\u00115,G/\u00193bi\u0006,\u0012A\u0015\t\u0003'zk\u0011\u0001\u0016\u0006\u0003+Z\u000b!a\u001c9\u000b\u0005]C\u0016aA:eW*\u0011\u0011LW\u0001\bG>tg.Z2u\u0015\tYF,\u0001\u0004pa\u0016t\u0017\u000e\u001a\u0006\u0003;F\n\u0001B\\5nEV\u001cHm]\u0005\u0003?R\u0013AcT%E\u0007B\u0013xN^5eKJlU\r^1eCR\f\u0017aC6fsN+G.Z2u_J,\u0012A\u0019\t\u0004G\"TW\"\u00013\u000b\u0005\u00154\u0017\u0001\u00029s_\u000eT!a\u001a/\u0002\t)|7/Z\u0005\u0003S\u0012\u0014aBS,T\u0017\u0016L8+\u001a7fGR|'\u000f\u0005\u0002dW&\u0011A\u000e\u001a\u0002\u0010'\u0016\u001cWO]5us\u000e{g\u000e^3yi\u0006Iq,\\3uC\u0012\fG/Y\u000b\u0002_B\u0019Q\u0004\u001d*\n\u0005Et\"AB(qi&|g.\u0001\u0006`[\u0016$\u0018\rZ1uC\u0002\nqC]3bIN#\u0018\r^5d\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0003I\u000b\u0001D]3bI\u0012Kh.Y7jG\u000e{gNZ5hkJ\fG/[8o)\t\u0011v\u000fC\u0003y\u001d\u0001\u0007Q(\u0001\u0005f]\u0012\u0004x.\u001b8u\u0001")
public class IssuerConfiguration
implements ConfigReader {
    private JWSKeySelector<SecurityContext> keySelector;
    private final Config config;
    private final String issuer;
    private final String userIdClaim;
    private final Option<OIDCProviderMetadata> _metadata;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public void printConfig(boolean includeDefaults) {
        ConfigReader.printConfig$((ConfigReader)this, (boolean)includeDefaults);
    }

    public boolean printConfig$default$1() {
        return ConfigReader.printConfig$default$1$((ConfigReader)this);
    }

    public void warn(String msg) {
        ConfigReader.warn$((ConfigReader)this, (String)msg);
    }

    public Number readNumber(String path, Number number) {
        return ConfigReader.readNumber$((ConfigReader)this, (String)path, (Number)number);
    }

    public long readLong(String path, long l) {
        return ConfigReader.readLong$((ConfigReader)this, (String)path, (long)l);
    }

    public int readInt(String path, int n) {
        return ConfigReader.readInt$((ConfigReader)this, (String)path, (int)n);
    }

    public String readString(String path, String string) {
        return ConfigReader.readString$((ConfigReader)this, (String)path, (String)string);
    }

    public String readString$default$2() {
        return ConfigReader.readString$default$2$((ConfigReader)this);
    }

    public <T> T readEnum(String path, Class<T> enumClass, T t) {
        return (T)ConfigReader.readEnum$((ConfigReader)this, (String)path, enumClass, t);
    }

    public <T> Null$ readEnum$default$3() {
        return ConfigReader.readEnum$default$3$((ConfigReader)this);
    }

    public boolean readBoolean(String path, boolean bl) {
        return ConfigReader.readBoolean$((ConfigReader)this, (String)path, (boolean)bl);
    }

    public FiniteDuration readDuration(String name, FiniteDuration finiteDuration) {
        return ConfigReader.readDuration$((ConfigReader)this, (String)name, (FiniteDuration)finiteDuration);
    }

    public Seq<String> readStrings(String path, Seq<String> defaultValue) {
        return ConfigReader.readStrings$((ConfigReader)this, (String)path, defaultValue);
    }

    public Seq<String> readStrings$default$2() {
        return ConfigReader.readStrings$default$2$((ConfigReader)this);
    }

    public List<String> readStringList(String path, List<String> defaultValue) {
        return ConfigReader.readStringList$((ConfigReader)this, (String)path, defaultValue);
    }

    public List<String> readStringList$default$2() {
        return ConfigReader.readStringList$default$2$((ConfigReader)this);
    }

    public ConfigReader getConfigReader(String path, Config defaultValue) {
        return ConfigReader.getConfigReader$((ConfigReader)this, (String)path, (Config)defaultValue);
    }

    public Config getConfigReader$default$2() {
        return ConfigReader.getConfigReader$default$2$((ConfigReader)this);
    }

    public Config readConfig(String path, Config defaultValue) {
        return ConfigReader.readConfig$((ConfigReader)this, (String)path, (Config)defaultValue);
    }

    public Config readConfig$default$2() {
        return ConfigReader.readConfig$default$2$((ConfigReader)this);
    }

    public Seq<ConfigReader> readConfigList(String path, Seq<Config> defaultValue) {
        return ConfigReader.readConfigList$((ConfigReader)this, (String)path, defaultValue);
    }

    public Seq<Config> readConfigList$default$2() {
        return ConfigReader.readConfigList$default$2$((ConfigReader)this);
    }

    public void requires(String errorPrefixMessage, Seq<String> paths) {
        ConfigReader.requires$((ConfigReader)this, (String)errorPrefixMessage, paths);
    }

    public Nothing$ fail(String msg) {
        return ConfigReader.fail$((ConfigReader)this, (String)msg);
    }

    private Logger logger$lzycompute() {
        IssuerConfiguration issuerConfiguration = this;
        synchronized (issuerConfiguration) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Config config() {
        return this.config;
    }

    public String issuer() {
        return this.issuer;
    }

    public String userIdClaim() {
        return this.userIdClaim;
    }

    public boolean hasMetadata() {
        return this._metadata().nonEmpty();
    }

    public OIDCProviderMetadata metadata() {
        return (OIDCProviderMetadata)this._metadata().get();
    }

    private JWSKeySelector<SecurityContext> keySelector$lzycompute() {
        IssuerConfiguration issuerConfiguration = this;
        synchronized (issuerConfiguration) {
            if (!this.bitmap$0) {
                JWKSource keySource = JWKSourceBuilder.create((URL)this.metadata().getJWKSetURI().toURL()).build();
                HashSet algorithms = new HashSet(this.metadata().getIDTokenJWSAlgs());
                this.keySelector = new JWSVerificationKeySelector(algorithms, keySource);
                this.bitmap$0 = true;
            }
        }
        return this.keySelector;
    }

    public JWSKeySelector<SecurityContext> keySelector() {
        if (!this.bitmap$0) {
            return this.keySelector$lzycompute();
        }
        return this.keySelector;
    }

    private Option<OIDCProviderMetadata> _metadata() {
        return this._metadata;
    }

    public OIDCProviderMetadata readStaticConfiguration() {
        String keysUrl = this.readString("key-url", this.readString$default$2());
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        subjectTypes.add(SubjectType.PUBLIC);
        OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer(this.issuer()), subjectTypes, new URI(keysUrl));
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.RS256;
        metadata.setIDTokenJWSAlgs(Collections.singletonList(expectedJWSAlg));
        String authorizationUrl = this.readString("authorization-url", this.readString$default$2());
        metadata.setAuthorizationEndpointURI(new URI(authorizationUrl));
        String tokenUrl = this.readString("token-url", this.readString$default$2());
        metadata.setTokenEndpointURI(new URI(tokenUrl));
        return metadata;
    }

    public OIDCProviderMetadata readDynamicConfiguration(String endpoint) {
        BoxedUnit boxedUnit;
        OIDCProviderMetadata metadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(endpoint));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(34).append("Retrieved dynamic info from IDP ").append(endpoint).append(": ").append(JSONReader.parse((String)metadata.toJSONObject().toJSONString())).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return metadata;
    }

    public IssuerConfiguration(Config config) {
        Some some;
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        ConfigReader.$init$((ConfigReader)this);
        this.issuer = this.readString("issuer", this.readString$default$2());
        this.userIdClaim = this.readString("user-id-claim", "sub");
        if (config.hasPath("key-url")) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading static info for IDP {}", (Object)this.issuer());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = new Some((Object)this.readStaticConfiguration());
        } else {
            String connectUrl = this.readString("connect-url", this.readString$default$2());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(connectUrl))) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Reading dynamic info for IDP {} from connect-url {}", new Object[]{this.issuer(), connectUrl});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = new Some((Object)this.readDynamicConfiguration(connectUrl));
            } else if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.issuer()))) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Reading dynamic info for IDP {}", (Object)this.issuer());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = new Some((Object)this.readDynamicConfiguration(this.issuer()));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Encountered empty IDP configuration; this configuration will be skipped");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            }
        }
        this._metadata = some;
    }
}

