/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.http;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.ServerBuilder;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RouteResult$;
import org.cafienne.service.http.anonymous.AnonymousRequestRoutes;
import org.cafienne.service.http.cases.CasesRoutes;
import org.cafienne.service.http.consentgroup.route.ConsentGroupRoutes;
import org.cafienne.service.http.debug.DebugRoute;
import org.cafienne.service.http.identifiers.route.IdentifierRoutes;
import org.cafienne.service.http.platform.CaseEngineHealthRoute;
import org.cafienne.service.http.platform.PlatformRoutes;
import org.cafienne.service.http.repository.RepositoryRoute;
import org.cafienne.service.http.storage.StorageRoutes;
import org.cafienne.service.http.swagger.SwaggerHttpServiceRoute;
import org.cafienne.service.http.tasks.TaskRoutes;
import org.cafienne.service.http.tenant.route.TenantRoutes;
import org.cafienne.service.infrastructure.configuration.OIDCConfiguration;
import org.cafienne.service.infrastructure.route.CaseServiceRoute;
import org.cafienne.system.CaseSystem;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000554AAC\u0006\u0001)!AQ\u0005\u0001BC\u0002\u0013\u0005a\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001d\u0019\u0004A1A\u0005\u0002QBa!\u0010\u0001!\u0002\u0013)\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002!\t\u000b=\u0003A\u0011\u0001)\t\u000bY\u0003A\u0011A,\u0003)\r\u000b7/Z#oO&tW\r\u0013;uaN+'O^3s\u0015\taQ\"\u0001\u0003iiR\u0004(B\u0001\b\u0010\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001E\t\u0002\u0011\r\fg-[3o]\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dG5\tQD\u0003\u0002\u001f?\u0005a1oY1mC2|wmZ5oO*\u0011\u0001%I\u0001\tif\u0004Xm]1gK*\t!%A\u0002d_6L!\u0001J\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u000bG\u0006\u001cXmU=ti\u0016lW#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)z\u0011AB:zgR,W.\u0003\u0002-S\tQ1)Y:f'f\u001cH/Z7\u0002\u0017\r\f7/Z*zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004CA\u0019\u0001\u001b\u0005Y\u0001\"B\u0013\u0004\u0001\u00049\u0013!E8jI\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u0005i1m\u001c8gS\u001e,(/\u0019;j_:T!AO\u0007\u0002\u001d%tgM]1tiJ,8\r^;sK&\u0011Ah\u000e\u0002\u0012\u001f&#5iQ8oM&<WO]1uS>t\u0017AE8jI\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\naA]8vi\u0016\u001cX#\u0001!\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u0015;\u0012AC2pY2,7\r^5p]&\u0011qI\u0011\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA%M\u001b\u0005Q%BA&:\u0003\u0015\u0011x.\u001e;f\u0013\ti%J\u0001\tDCN,7+\u001a:wS\u000e,'k\\;uK\u00069!o\\;uKN\u0004\u0013\u0001C1eIJ{W\u000f^3\u0015\u0005E#\u0006C\u0001\fS\u0013\t\u0019vC\u0001\u0003V]&$\b\"B+\t\u0001\u0004A\u0015\u0001E2bg\u0016\u001cVM\u001d<jG\u0016\u0014v.\u001e;f\u0003\u0015\u0019H/\u0019:u)\u0005A\u0006cA-]=6\t!L\u0003\u0002\\/\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005uS&A\u0002$viV\u0014X\r\u0005\u0002`U:\u0011\u0001\r[\u0007\u0002C*\u0011!mY\u0001\tg\u000e\fG.\u00193tY*\u0011A\u0002\u001a\u0006\u0003K\u001a\fQ\u0001]3lW>T!aZ\t\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tI\u0017-\u0001\u0003IiR\u0004\u0018BA6m\u00055\u0019VM\u001d<fe\nKg\u000eZ5oO*\u0011\u0011.\u0019")
public class CaseEngineHttpServer
implements LazyLogging {
    private final CaseSystem caseSystem;
    private final OIDCConfiguration oidcConfiguration;
    private final ListBuffer<CaseServiceRoute> routes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseEngineHttpServer caseEngineHttpServer = this;
        synchronized (caseEngineHttpServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    public OIDCConfiguration oidcConfiguration() {
        return this.oidcConfiguration;
    }

    public ListBuffer<CaseServiceRoute> routes() {
        return this.routes;
    }

    public void addRoute(CaseServiceRoute caseServiceRoute) {
        this.routes().$plus$eq((Object)caseServiceRoute);
    }

    public Future<Http.ServerBinding> start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - loading swagger documentation of the routes");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ListBuffer apiClasses = (ListBuffer)this.routes().flatMap((Function1 & Serializable)route -> route.apiClasses());
        ObjectRef mainRoute = ObjectRef.create(new SwaggerHttpServiceRoute(this, apiClasses.toSet()).route());
        ((IterableOnceOps)this.routes().map((Function1 & Serializable)x$1 -> x$1.route())).foreach((Function1 & Serializable)route -> {
            CaseEngineHttpServer.routeAppender$1(route, mainRoute);
            return BoxedUnit.UNIT;
        });
        Function1 apiRoutes = (Function1)mainRoute.elem;
        String apiHost = this.caseSystem().config().api().bindHost();
        int apiPort = this.caseSystem().config().api().bindPort();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Cafienne HTTP Server - starting on {}:{}", new Object[]{apiHost, BoxesRunTime.boxToInteger((int)apiPort)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorSystem system = this.caseSystem().system();
        ServerBuilder httpServer = Http$.MODULE$.apply((ClassicActorSystemProvider)system).newServerAt(apiHost, apiPort);
        return httpServer.bindFlow(RouteResult$.MODULE$.routeToFlow(apiRoutes, (ClassicActorSystemProvider)system));
    }

    private static final void routeAppender$1(Function1 route, ObjectRef mainRoute$1) {
        mainRoute$1.elem = Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1)mainRoute$1.elem, route}));
    }

    public CaseEngineHttpServer(CaseSystem caseSystem) {
        block0: {
            this.caseSystem = caseSystem;
            LazyLogging.$init$((LazyLogging)this);
            this.oidcConfiguration = new OIDCConfiguration(caseSystem.config().api().security());
            this.routes = new ListBuffer();
            this.addRoute(new CaseEngineHealthRoute(this));
            this.addRoute(new CasesRoutes(this));
            this.addRoute(new IdentifierRoutes(this));
            this.addRoute(new TaskRoutes(this));
            this.addRoute(new TenantRoutes(this));
            this.addRoute(new ConsentGroupRoutes(this));
            this.addRoute(new PlatformRoutes(this));
            this.addRoute(new RepositoryRoute(this));
            this.addRoute(new StorageRoutes(this));
            this.addRoute(new DebugRoute(this));
            if (!caseSystem.config().api().anonymousConfig().enabled()) break block0;
            this.addRoute(new AnonymousRequestRoutes(this));
        }
    }
}

