/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.infrastructure.authentication;

import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.proc.BadJWTException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import org.cafienne.actormodel.identity.IdentityRegistration;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.service.infrastructure.authentication.AuthenticatedUser;
import org.cafienne.service.infrastructure.authentication.AuthenticatedUserReader;
import org.cafienne.service.infrastructure.authentication.CannotReachIDPException;
import org.cafienne.service.infrastructure.authentication.TokenContext;
import org.cafienne.service.infrastructure.authentication.TokenVerificationException;
import org.cafienne.service.infrastructure.authentication.TokenVerificationException$;
import org.cafienne.service.infrastructure.configuration.OIDCConfiguration;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00154AAC\u0006\u0001-!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003*\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011m\u0002!\u0011!Q\u0001\fqBQA\u0011\u0001\u0005\u0002\rCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004P\u0001\u0001\u0006I\u0001\u0014\u0005\u0006!\u0002!\t!\u0015\u0002\u000e)>\\WM\u001c,fe&4\u0017.\u001a:\u000b\u00051i\u0011AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003\u001d=\ta\"\u001b8ge\u0006\u001cHO];diV\u0014XM\u0003\u0002\u0011#\u000591/\u001a:wS\u000e,'B\u0001\n\u0014\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nAb]2bY\u0006dwnZ4j]\u001eT!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014 \u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002!U\u001cXM\u001d*fO&\u001cHO]1uS>tW#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001C5eK:$\u0018\u000e^=\u000b\u00059\n\u0012AC1di>\u0014Xn\u001c3fY&\u0011\u0001g\u000b\u0002\u0015\u0013\u0012,g\u000e^5usJ+w-[:ue\u0006$\u0018n\u001c8\u0002#U\u001cXM\u001d*fO&\u001cHO]1uS>t\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011q'D\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005e2$!E(J\t\u000e\u001buN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8gS\u001e\u0004\u0013AA3d!\ti\u0004)D\u0001?\u0015\ty\u0014$\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0011 \u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002E\u0011&#\"!R$\u0011\u0005\u0019\u0003Q\"A\u0006\t\u000bm2\u00019\u0001\u001f\t\u000b\u001d2\u0001\u0019A\u0015\t\u000bI2\u0001\u0019\u0001\u001b\u0002\u0015U\u001cXM\u001d*fC\u0012,'/F\u0001M!\t1U*\u0003\u0002O\u0017\t9\u0012)\u001e;iK:$\u0018nY1uK\u0012,6/\u001a:SK\u0006$WM]\u0001\fkN,'OU3bI\u0016\u0014\b%\u0001\u000ed_:4XM\u001d;U_\u0006+H\u000f[3oi&\u001c\u0017\r^3e+N,'\u000f\u0006\u0002S1B\u0019QhU+\n\u0005Qs$A\u0002$viV\u0014X\r\u0005\u0002G-&\u0011qk\u0003\u0002\u0012\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Vg\u0016\u0014\b\"B-\n\u0001\u0004Q\u0016!\u0002;pW\u0016t\u0007CA.c\u001d\ta\u0006\r\u0005\u0002^35\taL\u0003\u0002`+\u00051AH]8pizJ!!Y\r\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003Cf\u0001")
public class TokenVerifier
implements LazyLogging {
    private final IdentityRegistration userRegistration;
    private final OIDCConfiguration config;
    private final ExecutionContext ec;
    private final AuthenticatedUserReader userReader;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TokenVerifier tokenVerifier = this;
        synchronized (tokenVerifier) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public IdentityRegistration userRegistration() {
        return this.userRegistration;
    }

    public OIDCConfiguration config() {
        return this.config;
    }

    private AuthenticatedUserReader userReader() {
        return this.userReader;
    }

    public Future<AuthenticatedUser> convertToAuthenticatedUser(String token) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            AuthenticatedUser authenticatedUser;
            try {
                TokenContext context = this.userReader().createUserContext(token);
                this.userReader().process(token, context);
                HealthMonitor$.MODULE$.idp().isOK();
                this.userRegistration().cacheUserToken((UserIdentity)context.authenticatedUser(), token);
                authenticatedUser = context.authenticatedUser();
            }
            catch (RemoteKeySourceException rp) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failure in contacting IDP. Check IDP configuration settings of the case engine.", (Throwable)rp);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                CannotReachIDPException failure = new CannotReachIDPException("Cannot reach the IDP to validate credentials", rp);
                HealthMonitor$.MODULE$.idp().hasFailed((Throwable)failure);
                throw failure;
            }
            catch (Throwable other) {
                HealthMonitor$.MODULE$.idp().isOK();
                Throwable throwable = other;
                if (throwable instanceof BadJWTException) {
                    BadJWTException badJWTException = (BadJWTException)throwable;
                    String string = badJWTException.getMessage();
                    String string2 = "Expired JWT";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new TokenVerificationException("JWT Token failure: token is expired");
                    }
                    if (badJWTException.getCause() instanceof ParseException) {
                        throw new TokenVerificationException(new StringBuilder(21).append("Token parse failure: ").append(badJWTException.getCause().getLocalizedMessage()).toString());
                    }
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(15).append("Invalid token: ").append(badJWTException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof BadJOSEException) {
                    BoxedUnit boxedUnit;
                    BadJOSEException badJOSEException = (BadJOSEException)throwable;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Encountered JWT issues", (Throwable)badJOSEException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(26).append("Token cannot be verified: ").append(badJOSEException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof ParseException) {
                    ParseException parseException = (ParseException)throwable;
                    throw TokenVerificationException$.MODULE$.apply(new StringBuilder(21).append("Token parse failure: ").append(parseException.getLocalizedMessage()).toString());
                }
                if (throwable instanceof TokenVerificationException) {
                    TokenVerificationException tokenVerificationException = (TokenVerificationException)throwable;
                    throw tokenVerificationException;
                }
                if (throwable != null) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Unexpected or unforeseen exception during token verification; throwing it further", throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new TokenVerificationException(new StringBuilder(35).append("Token verification failure of type ").append(throwable2.getClass().getSimpleName()).toString(), throwable2);
                }
                throw new MatchError((Object)throwable);
            }
            return authenticatedUser;
        }, this.ec);
    }

    public TokenVerifier(IdentityRegistration userRegistration, OIDCConfiguration config, ExecutionContext ec) {
        this.userRegistration = userRegistration;
        this.config = config;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.userReader = new AuthenticatedUserReader(this);
    }
}

