/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.infrastructure.route;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.ExceptionHandler;
import org.apache.pekko.http.scaladsl.server.ExceptionHandler$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.IdentityRegistration;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.persistence.infrastructure.lastmodified.LastModifiedHeader;
import org.cafienne.persistence.querydb.query.exception.SearchFailure;
import org.cafienne.service.infrastructure.authentication.AuthenticatedUser;
import org.cafienne.service.infrastructure.authentication.AuthenticationDirectives;
import org.cafienne.service.infrastructure.authentication.AuthenticationException;
import org.cafienne.service.infrastructure.authentication.CannotReachIDPException;
import org.cafienne.service.infrastructure.configuration.OIDCConfiguration;
import org.cafienne.service.infrastructure.route.CaseServiceRoute;
import org.cafienne.service.infrastructure.route.LastModifiedDirectives;
import org.cafienne.service.infrastructure.route.UnhealthyCaseSystem;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005-da\u0002\b\u0010!\u0003\r\tA\u0007\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0011\"\u00115\u0011\u001di\u0004A1A\u0005DyBq!\u0012\u0001C\u0002\u0013\u0005c\tC\u0003N\u0001\u0011\u0005c\nC\u0003^\u0001\u0011%a\fC\u0003~\u0001\u0011%a\u0010C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003G\u0002A\u0011AA3\u0011\u0019\tI\u0007\u0001C\u0001_\t\u0011\u0012)\u001e;iK:$\u0018nY1uK\u0012\u0014v.\u001e;f\u0015\t\u0001\u0012#A\u0003s_V$XM\u0003\u0002\u0013'\u0005q\u0011N\u001c4sCN$(/^2ukJ,'B\u0001\u000b\u0016\u0003\u001d\u0019XM\u001d<jG\u0016T!AF\f\u0002\u0011\r\fg-[3o]\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0006\u0001m\tSe\u000b\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"A\b\n\u0005\u0011z!\u0001E\"bg\u0016\u001cVM\u001d<jG\u0016\u0014v.\u001e;f!\t1\u0013&D\u0001(\u0015\tA\u0013#\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\n\u0005):#\u0001G!vi\",g\u000e^5dCRLwN\u001c#je\u0016\u001cG/\u001b<fgB\u0011!\u0005L\u0005\u0003[=\u0011a\u0003T1ti6{G-\u001b4jK\u0012$\u0015N]3di&4Xm]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003A\u0002\"\u0001H\u0019\n\u0005Ij\"\u0001B+oSR\f\u0011\"^:fe\u000e\u000b7\r[3\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u0011%$WM\u001c;jifT!AO\u000b\u0002\u0015\u0005\u001cGo\u001c:n_\u0012,G.\u0003\u0002=o\t!\u0012\nZ3oi&$\u0018PU3hSN$(/\u0019;j_:\f!!\u001a=\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002E\u0003\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007G>tg-[4\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!AS\t\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\ta\u0015JA\tP\u0013\u0012\u001b5i\u001c8gS\u001e,(/\u0019;j_:\f\u0001#\u001a=dKB$\u0018n\u001c8IC:$G.\u001a:\u0016\u0003=\u0003\"\u0001U.\u000e\u0003ES!AU*\u0002\rM,'O^3s\u0015\t!V+\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t1v+\u0001\u0003iiR\u0004(B\u0001-Z\u0003\u0015\u0001Xm[6p\u0015\tQv#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00039F\u0013\u0001#\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:\u0002;!\fg\u000e\u001a7f\u0013:4\u0018\r\\5e\u0007>lW.\u00198e\u000bb\u001cW\r\u001d;j_:$\"aX;\u0011\u0005\u0001\u0014hBA1q\u001d\t\u0011wN\u0004\u0002d]:\u0011A-\u001c\b\u0003K2t!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%L\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tQv#\u0003\u0002Y3&\u0011akV\u0005\u0003)VK!AU*\n\u0005E\f\u0016a\u00029bG.\fw-Z\u0005\u0003gR\u0014QAU8vi\u0016T!!])\t\u000bY4\u0001\u0019A<\u0002\u0003%\u0004\"\u0001_>\u000e\u0003eT!A_\u001d\u0002\u0013\u0015D8-\u001a9uS>t\u0017B\u0001?z\u0005]IeN^1mS\u0012\u001cu.\\7b]\u0012,\u0005pY3qi&|g.\u0001\niC:$G.Z%E!\u0016C8-\u001a9uS>tGCA0\u0000\u0011\u001d\t\ta\u0002a\u0001\u0003\u0007\t\u0011!\u001a\t\u0004M\u0005\u0015\u0011bAA\u0004O\t92)\u00198o_R\u0014V-Y2i\u0013\u0012\u0003V\t_2faRLwN\\\u0001\u001eQ\u0006tG\r\\3BkRDWM\u001c;jG\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]R\u0019q,!\u0004\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012\u0005\t1\u000fE\u0002'\u0003'I1!!\u0006(\u0005]\tU\u000f\u001e5f]RL7-\u0019;j_:,\u0005pY3qi&|g.\u0001\u000fiC:$G.Z!vi\"|'/\u001b>bi&|g.\u0012=dKB$\u0018n\u001c8\u0015\u0007}\u000bY\u0002C\u0004\u0002\u0010%\u0001\r!!\b\u0011\t\u0005}\u0011q\u0005\b\u0005\u0003C\t)CD\u0002h\u0003GI\u0011AH\u0005\u0003cvIA!!\u000b\u0002,\tIQ\t_2faRLwN\u001c\u0006\u0003cv\tAb\u001c9uS>t\u0017\r\\+tKJ$2aXA\u0019\u0011\u001d\t\u0019D\u0003a\u0001\u0003k\t\u0001b];c%>,H/\u001a\t\u00079\u0005]\u00121H0\n\u0007\u0005eRDA\u0005Gk:\u001cG/[8ocA\u0019a'!\u0010\n\u0007\u0005}rG\u0001\u0007QY\u0006$hm\u001c:n+N,'\u000fK\u0006\u000b\u0003\u0007\nI%a\u0013\u0002P\u0005E\u0003c\u0001\u000f\u0002F%\u0019\u0011qI\u000f\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0005\u00055\u0013A[8qi&|g.\u00197Vg\u0016\u0014\b%[:!C\u0002\"X-\u001c9pe\u0006\u0014\u0018\u0010I:xSR\u001c\u0007\u000e\t;pA\u0015t\u0017M\u00197fAUtW&Y;uQ\u0016tG/[2bi\u0016$\u0007%Y2dKN\u001c\bEZ8sAI,\u0017\rZ5oO\u0002*g/\u001a8ug\u0002Jg\u000e\t;iK\u0002\"WMY;hAI|W\u000f^3\u0002\u000bMLgnY3\"\u0005\u0005M\u0013!B\u0019/c9\u0002\u0014!E1vi\",g\u000e^5dCR,G-V:feR\u0019q,!\u0017\t\u000f\u0005M2\u00021\u0001\u0002\\A1A$a\u000e\u0002^}\u00032AJA0\u0013\r\t\tg\n\u0002\u0012\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Vg\u0016\u0014\u0018!\u0003<bY&$Wk]3s)\ry\u0016q\r\u0005\b\u0003ga\u0001\u0019AA\u001b\u0003]\u0019\u0017m]3TsN$X-\\'vgR\u0014U\rS3bYRD\u0017\u0010")
public interface AuthenticatedRoute
extends CaseServiceRoute,
AuthenticationDirectives,
LastModifiedDirectives {
    public void org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$userCache_$eq(IdentityRegistration var1);

    public void org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$ex_$eq(ExecutionContext var1);

    public void org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$config_$eq(OIDCConfiguration var1);

    @Override
    public IdentityRegistration userCache();

    @Override
    public ExecutionContext ex();

    @Override
    public OIDCConfiguration config();

    public static /* synthetic */ ExceptionHandler exceptionHandler$(AuthenticatedRoute $this) {
        return $this.exceptionHandler();
    }

    @Override
    default public ExceptionHandler exceptionHandler() {
        return ExceptionHandler$.MODULE$.apply((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AuthenticatedRoute $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CannotReachIDPException) {
                    CannotReachIDPException cannotReachIDPException = (CannotReachIDPException)A1;
                    return (B1)this.$outer.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleIDPException(cannotReachIDPException);
                }
                if (A1 instanceof AuthenticationException) {
                    AuthenticationException authenticationException = (AuthenticationException)A1;
                    return (B1)this.$outer.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthenticationException(authenticationException);
                }
                if (A1 instanceof AuthorizationException) {
                    AuthorizationException authorizationException = (AuthorizationException)A1;
                    return (B1)this.$outer.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthorizationException((Exception)((Object)authorizationException));
                }
                if (A1 instanceof InvalidCommandException) {
                    InvalidCommandException invalidCommandException = (InvalidCommandException)A1;
                    return (B1)this.$outer.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleInvalidCommandException(invalidCommandException);
                }
                if (A1 instanceof SearchFailure) {
                    SearchFailure searchFailure = (SearchFailure)A1;
                    return (B1)this.$outer.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> searchFailure.getMessage(), Marshaller$.MODULE$.StringMarshaller());
                }
                if (A1 instanceof SecurityException) {
                    SecurityException securityException = (SecurityException)A1;
                    return (B1)this.$outer.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthorizationException(securityException);
                }
                return (B1)this.$outer.defaultExceptionHandler(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CannotReachIDPException) {
                    return true;
                }
                if (throwable instanceof AuthenticationException) {
                    return true;
                }
                if (throwable instanceof AuthorizationException) {
                    return true;
                }
                if (throwable instanceof InvalidCommandException) {
                    return true;
                }
                if (throwable instanceof SearchFailure) {
                    return true;
                }
                if (throwable instanceof SecurityException) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.cafienne.persistence.querydb.query.exception.SearchFailure )}, serializedLambda);
            }
        });
    }

    public static /* synthetic */ Function1 org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleInvalidCommandException$(AuthenticatedRoute $this, InvalidCommandException i) {
        return $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleInvalidCommandException(i);
    }

    default public Function1<RequestContext, Future<RouteResult>> org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleInvalidCommandException(InvalidCommandException i) {
        if (this.logger().underlying().isDebugEnabled()) {
            return (Function1)Directive$.MODULE$.addDirectiveApply(this.extractUri(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)uri -> (Function1)Directive$.MODULE$.addDirectiveApply(this.extractMethod(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)method -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(20).append("Invalid command on ").append(method.value()).append(" ").append(uri).toString(), (Throwable)i);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> i.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            }));
        }
        return this.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> i.getMessage(), Marshaller$.MODULE$.StringMarshaller());
    }

    public static /* synthetic */ Function1 org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleIDPException$(AuthenticatedRoute $this, CannotReachIDPException e) {
        return $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleIDPException(e);
    }

    default public Function1<RequestContext, Future<RouteResult>> org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleIDPException(CannotReachIDPException e) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Service cannot validate security tokens, because IDP is not reachable");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.complete((Function0 & Serializable)() -> {
            StatusCodes.ServerError x$1 = StatusCodes$.MODULE$.ServiceUnavailable();
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(e.getMessage());
            Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4), Marshaller$.MODULE$.fromResponse());
        }).andThen((Function1 & Serializable)g -> g);
    }

    public static /* synthetic */ Function1 org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthenticationException$(AuthenticatedRoute $this, AuthenticationException s) {
        return $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthenticationException(s);
    }

    default public Function1<RequestContext, Future<RouteResult>> org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthenticationException(AuthenticationException s) {
        return this.complete((Function0 & Serializable)() -> {
            StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.Unauthorized();
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(s.getMessage());
            Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4), Marshaller$.MODULE$.fromResponse());
        });
    }

    public static /* synthetic */ Function1 org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthorizationException$(AuthenticatedRoute $this, Exception s) {
        return $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthorizationException(s);
    }

    default public Function1<RequestContext, Future<RouteResult>> org$cafienne$service$infrastructure$route$AuthenticatedRoute$$handleAuthorizationException(Exception s) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.extractMethod(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)method -> (Function1)Directive$.MODULE$.addDirectiveApply(this.extractUri(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)uri -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(33).append("Authorization issue in request ").append(method.name()).append(" ").append(uri).append(" ").toString(), (Throwable)s);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(72).append("Authorization issue in request ").append(method.name()).append(" ").append(uri).append(" (enable info logging for stack trace): ").append(s.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.complete((Function0 & Serializable)() -> {
                StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.Unauthorized();
                HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(s.getMessage());
                Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
                HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4), Marshaller$.MODULE$.fromResponse());
            });
        }));
    }

    public static /* synthetic */ Function1 optionalUser$(AuthenticatedRoute $this, Function1 subRoute) {
        return $this.optionalUser((Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>>)subRoute);
    }

    default public Function1<RequestContext, Future<RouteResult>> optionalUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        if (this.caseSystem().config().developerRouteOpen()) {
            return (Function1)subRoute.apply(null);
        }
        return this.validUser(subRoute);
    }

    public static /* synthetic */ Function1 authenticatedUser$(AuthenticatedRoute $this, Function1 subRoute) {
        return $this.authenticatedUser((Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>>)subRoute);
    }

    default public Function1<RequestContext, Future<RouteResult>> authenticatedUser(Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.authenticatedUser(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)user -> {
            this.caseSystemMustBeHealthy();
            return this.readLastModifiedHeader("Tenant-Last-Modified", (Function1 & Serializable)header -> (Function1)Directive$.MODULE$.addDirectiveApply(this.onComplete((Function0 & Serializable)() -> header.available()), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$1 -> (Function1)subRoute.apply(user)));
        });
    }

    public static /* synthetic */ Function1 validUser$(AuthenticatedRoute $this, Function1 subRoute) {
        return $this.validUser((Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>>)subRoute);
    }

    default public Function1<RequestContext, Future<RouteResult>> validUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return this.readLastModifiedHeader("Tenant-Last-Modified", (Function1 & Serializable)tlm -> (Function1)Directive$.MODULE$.addDirectiveApply(this.platformUser((LastModifiedHeader)tlm), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)platformUser -> {
            this.caseSystemMustBeHealthy();
            return (Function1)subRoute.apply(platformUser);
        }));
    }

    public static /* synthetic */ void caseSystemMustBeHealthy$(AuthenticatedRoute $this) {
        $this.caseSystemMustBeHealthy();
    }

    default public void caseSystemMustBeHealthy() {
        if (!HealthMonitor$.MODULE$.ok()) {
            throw new UnhealthyCaseSystem("Refusing request, because Case System is not healthy");
        }
    }

    public static void $init$(AuthenticatedRoute $this) {
        $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$userCache_$eq($this.caseSystem().identityRegistration());
        $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$ex_$eq((ExecutionContext)$this.caseSystem().system().dispatcher());
        $this.org$cafienne$service$infrastructure$route$AuthenticatedRoute$_setter_$config_$eq($this.httpService().oidcConfiguration());
    }
}

