/**
 * 
 */
package org.caiguoqing.salay.client;

import java.net.InetSocketAddress;

import org.caiguoqing.salay.entity.Message;
import org.caiguoqing.salay.pub.Config;
import org.caiguoqing.salay.pub.MessageDecoder;
import org.caiguoqing.salay.pub.MessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

/**
 * @author caiguoqing0427
 * 
 */
public class Client {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private volatile Channel channel;
	private RecvPubHandler recvPubHandler;
	private String host;
	private int port;
	private volatile boolean isConnected = false;
	
	public Client(){
		Config config = new Config();
		host = config.getHost();
		port = config.getPort();
	}
	
	public void setRecvPubHandler(RecvPubHandler recvPubHandler){
		this.recvPubHandler = recvPubHandler;
	}
	
	public void run(){
		if(recvPubHandler == null){
			logger.error("recvPubHandler is null");
			return;
		}
		EventLoopGroup group = new NioEventLoopGroup();
		Bootstrap b = new Bootstrap();
		b.group(group);
		b.channel(NioSocketChannel.class);
		b.remoteAddress(new InetSocketAddress(host, port));
		b.handler(new ChannelInitializer<Channel>() {
			public void initChannel(Channel ch) throws Exception {
				channel = ch;
				logger.info("connect to " + host + ":" + port);
			 	ch.pipeline().addLast(
					new MessageEncoder(),
					new MessageDecoder(),
					new ClientHandler(recvPubHandler));
			 	isConnected = true;
			}
		});
		b.connect();
	}
	
	public void sub(String key){
		sub(new String[]{key});
	}
	
	public void sub(String[] keys){
		send(Message.SUB,keys,null);
	}
	
	public void unsub(String key){
		unsub(new String[]{key});
	}
	
	public void unsub(String[] keys){
		send(Message.UNSUB,keys,null);
	}
	
	public void pub(String[] keys,Object data){
		send(Message.PUB,keys,data);
	}
	
	public void pub(String key,Object data){
		pub(new String[]{key}, data);
	}
	
	private void send(int type,String[] keys,Object data){
		if(channel == null){
			logger.error("channel is not prepared");
			return;
		}
		Message message = new Message();
		message.setType(type);
		message.setKeys(keys);
		message.setData(data);
		channel.writeAndFlush(message);
	}
	
	public boolean isConnected(){
		return isConnected;
	}
}
