/**
 * 
 */
package org.caiguoqing.salay.client;

import org.caiguoqing.salay.entity.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

/**
 * @author caiguoqing0427
 * 
 */
public class ClientHandler extends ChannelInboundHandlerAdapter {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private RecvPubHandler handler;
	
	public ClientHandler(RecvPubHandler handler){
		this.handler = handler;
	}
	
	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInboundHandlerAdapter#channelRead(io.netty.channel.ChannelHandlerContext, java.lang.Object)
	 */
	@Override
	public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
		Message message = (Message)msg;
		if(handler != null){
			if(message.getType() != Message.PUB){
				logger.error("the message is not pub message:" + message.toString());
				return;
			}
			String[] keys = message.getKeys();
			if(keys == null){
				logger.error("message is damaged:" + message.toString());
				return;
			}
			for(String key : keys){
				handler.handle(key,message.getData());
			}
		}else{
			logger.error("recvPubHandler is null");
		}
	}

	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInboundHandlerAdapter#exceptionCaught(io.netty.channel.ChannelHandlerContext, java.lang.Throwable)
	 */
	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
		logger.error(cause.toString());
		super.exceptionCaught(ctx, cause);
	}

}
