/**
 * 
 */
package org.caiguoqing.salay.pub;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * @author caiguoqing0427
 * 
 */
public class Config {
	private static String host;
	private static int port;
	private static int poolSize;
	
	static{
		FileInputStream fis = null;
		try {
			fis = new FileInputStream("src/main/resources/config.properties");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			System.exit(0);
		}
		Properties p = new Properties();
		try {
			p.load(fis);
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
		}
		host = p.getProperty("server_host");
		port = Integer.parseInt(p.getProperty("server_port"));
		poolSize = Integer.parseInt(p.getProperty("server_pool"));
		p = null;
		try {
			fis.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public String getHost(){
		return host;
	}
	
	public int getPort(){
		return port;
	}

	public int getPoolSize() {
		return poolSize;
	}	
}
