/**
 * 
 */
package org.caiguoqing.salay.pub;

import java.util.List;

import org.caiguoqing.salay.entity.Message;

import com.alibaba.fastjson.JSONObject;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;

/**
 * @author caiguoqing0427
 * 
 */
public class MessageDecoder extends ByteToMessageDecoder {
	
	/* (non-Javadoc)
	 * @see io.netty.handler.codec.ByteToMessageDecoder#decode(io.netty.channel.ChannelHandlerContext, io.netty.buffer.ByteBuf, java.util.List)
	 */
	@Override
	protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
		//header not found
		if(in.readableBytes() < 4){
			return;
		}
		in.markReaderIndex();//mark index
		int length = in.readInt();//read header
		if(length <= 0){
			return;
		}
		//data not received
		if(in.readableBytes() < length){
			in.resetReaderIndex();//reset index
			return;
		}
		byte[] buffer = new byte[length];
		in.readBytes(buffer);
		Message message = JSONObject.parseObject(buffer,Message.class);
		out.add(message);
	}

}
