/**
 * 
 */
package org.caiguoqing.salay.server;

import org.caiguoqing.salay.pub.MessageDecoder;
import org.caiguoqing.salay.pub.MessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;

/**
 * @author caiguoqing0427
 * 
 */
public class AcceptHandler extends ChannelInitializer<SocketChannel> {
	private Logger logger = LoggerFactory.getLogger(AcceptHandler.class);

	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInitializer#initChannel(io.netty.channel.Channel)
	 */
	@Override
	protected void initChannel(SocketChannel ch) throws Exception {
		logger.info(ch.remoteAddress().toString() + " connected");
		ch.pipeline().addLast(
			new MessageEncoder(),
			new MessageDecoder(),
			new ListenHandler());
	}

	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInitializer#exceptionCaught(io.netty.channel.ChannelHandlerContext, java.lang.Throwable)
	 */
	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
		logger.error(cause.toString());
		super.exceptionCaught(ctx, cause);
	}

}
