/**
 * 
 */
package org.caiguoqing.salay.server;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

import org.caiguoqing.salay.entity.Message;
import org.caiguoqing.salay.entity.PublishData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.channel.Channel;
/**
 * @author caiguoqing0427
 * 
 */
public class Context {
	private Logger logger = LoggerFactory.getLogger(Context.class);
	private static Context context = new Context();
	private static ConcurrentHashMap<String, List<Channel>> subList 
		= new ConcurrentHashMap<String, List<Channel>>();
	private static LinkedBlockingQueue<PublishData> pubList 
		= new LinkedBlockingQueue<PublishData>();
	
	private Context(){
		
	}
	
	public static Context getInstance(){
		return context;
	}
	
	public void sub(String[] keys, Channel channel){
		SocketAddress address = channel.remoteAddress();
		for(String key : keys){
			List<Channel> list = subList.get(key);
			if(list == null){
				list = new ArrayList<Channel>();
				subList.put(key, list);
			}
			list.add(channel);
			logger.info(address + " sub " + key);
		}
	}
	
	public void unsub(String[] keys, Channel channel){
		SocketAddress address = channel.remoteAddress();
		for(String key : keys){
			List<Channel> list = subList.get(key);
			if(list != null){
				list.remove(channel);
				logger.info(address + " unsub " + key);
			}
		}
	}
	
	public void pub(Message msg, Channel fromChannel){
		SocketAddress address = fromChannel.remoteAddress();
		String[] keys = msg.getKeys();
		for(String key : keys){
			Message newMsg = new Message(msg);
			newMsg.setKeys(new String[]{key});
			logger.info(address + " pub " + key);
			List<Channel> list = subList.get(key);
			if(list != null){
				for(Channel channel : list){
					try {
						pubList.put(new PublishData(channel,newMsg));
					} catch (InterruptedException e) {
						logger.error(address + " pub " + key + " fail:" + e.toString());
					}
				}
			}
		}
	}
	
	public PublishData getPub(){
		try {
			return pubList.take();
		} catch (InterruptedException e) {
			logger.error("getpub fail:" + e.toString());
			return null;
		}
	}
}
